/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.tools.OBB;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface OBBEntity {
    public List<OBB> getOBBs();

    default public boolean enableAABB() {
        return this.getOBBs().isEmpty();
    }

    default public boolean isInObb(BlockPos pos, Vec3 vec3) {
        List<OBB> obbList = this.getOBBs();
        Vec3 vec = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        AABB aabb1 = new AABB(vec, vec).inflate(0.3, 0.6, 0.3);
        for (OBB obb : obbList) {
            if (!OBB.isColliding(obb = obb.move(vec3), aabb1)) continue;
            return true;
        }
        return false;
    }

    default public boolean isInObb(Entity entity, Vec3 vec3) {
        List<OBB> obbList = this.getOBBs();
        for (OBB obb : obbList) {
            OBBEntity obbEntity2;
            obb = obb.move(vec3);
            if (entity instanceof OBBEntity && !(obbEntity2 = (OBBEntity)entity).enableAABB()) {
                List<OBB> obbList2 = obbEntity2.getOBBs();
                for (OBB obb2 : obbList2) {
                    if (!OBB.isColliding(obb, obb2)) continue;
                    return true;
                }
                continue;
            }
            if (!OBB.isColliding(obb, entity.getBoundingBox())) continue;
            return true;
        }
        return false;
    }
}

