/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.SenpaiEntity;
import com.atsuishio.superbwarfare.entity.projectile.PtkmProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Ptkm1rEntity
extends Entity
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(Ptkm1rEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.defineId(Ptkm1rEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(Ptkm1rEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(Ptkm1rEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int aimingTime;
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().multiply(0.02f, ModDamageTypes.CUSTOM_EXPLOSION).multiply(0.02f, ModDamageTypes.MINE).multiply(0.02f, ModDamageTypes.PROJECTILE_EXPLOSION).multiply(0.02f, (ResourceKey<DamageType>)DamageTypes.EXPLOSION);

    public Ptkm1rEntity(EntityType<Ptkm1rEntity> type, Level world) {
        super(type, world);
    }

    public Ptkm1rEntity(LivingEntity owner, Level level) {
        super((EntityType)ModEntities.PTKM_1R.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.getUUID());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty()).define(LAST_ATTACKER_UUID, (Object)"undefined").define(TARGET_UUID, (Object)"undefined").define(HEALTH, (Object)Float.valueOf(40.0f));
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        if (source.getEntity() != null) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)source.getEntity().getStringUUID());
        }
        this.entityData.set(HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(HEALTH)).floatValue() - amount));
        return super.hurt(source, amount);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.getOwner();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        compound.putString("LastAttacker", (String)this.entityData.get(LAST_ATTACKER_UUID));
        compound.putString("Target", (String)this.entityData.get(TARGET_UUID));
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        }
        if (compound.contains("LastAttacker")) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)compound.getString("LastAttacker"));
        }
        if (compound.contains("Target")) {
            this.entityData.set(TARGET_UUID, (Object)compound.getString("Target"));
        }
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            try {
                uuid = this.getServer() == null ? UUID.fromString(s) : OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player) && player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (!player.getAbilities().instabuild) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.PTKM_1R.get()));
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        if (((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            this.triggerExplode();
        }
        if (this.tickCount == 1) {
            this.level().playSound(null, BlockPos.containing((Position)this.position()), (SoundEvent)ModSounds.PTKM_1R_DEPLOY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (this.tickCount > 20 && this.onGround()) {
            this.findTarget();
        }
        this.refreshDimensions();
    }

    public void findTarget() {
        int range = 40;
        Entity target = null;
        List<Entity> list = new SeekTool.Builder(this).withinRange(range).build();
        for (Entity entity : list) {
            Player player;
            boolean condition;
            boolean bl = condition = entity.onGround() && this.getOwner() != entity && (!(entity instanceof Player) || !(player = (Player)entity).isCreative() && !player.isSpectator()) && this.getOwner() != null && !SeekTool.IS_FRIENDLY.test((Entity)this.getOwner(), entity) && entity != this.getOwner().getVehicle() && !entity.isShiftKeyDown() && (entity.getBoundingBox().getSize() > 1.5 || entity instanceof VehicleEntity || entity instanceof SenpaiEntity) && entity.getDeltaMovement().lengthSqr() > 0.009;
            if (!condition) continue;
            target = entity;
            break;
        }
        if (target != null) {
            float targetXRot;
            double distance = target.distanceTo((Entity)this);
            if (distance < (double)range) {
                targetXRot = -40.0f;
                this.look(target.position());
                if (distance < (double)(range - 5)) {
                    ++this.aimingTime;
                } else if (this.aimingTime > 0) {
                    --this.aimingTime;
                }
            } else {
                this.setXRot(0.0f);
                targetXRot = 0.0f;
            }
            float diffX = Math.clamp((float)-60.0f, (float)60.0f, (float)Mth.wrapDegrees((float)(targetXRot - this.getXRot())));
            this.setXRot(this.getXRot() + 0.25f * diffX);
            if (this.aimingTime > 10) {
                this.shoot(target, distance);
            }
        } else if (this.aimingTime > 0) {
            --this.aimingTime;
        }
    }

    private void shoot(Entity entity, double distance) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PtkmProjectileEntity ptkmProjectile = new PtkmProjectileEntity(this.getOwner(), (Level)serverLevel);
            ptkmProjectile.setDamage(500.0f);
            ptkmProjectile.setExplosionDamage(80.0f);
            ptkmProjectile.setExplosionRadius(7.0f);
            ptkmProjectile.setTarget(entity);
            ptkmProjectile.setShootTime((int)(0.5 * distance));
            ptkmProjectile.setPos(this.position().x, this.getEyePosition().y, this.position().z);
            ptkmProjectile.shoot(this.getLookAngle().x, this.getLookAngle().y, this.getLookAngle().z, 4.0f, 0.4f);
            serverLevel.addFreshEntity((Entity)ptkmProjectile);
            int count = 6;
            for (float i = 1.0f; i < 8.0f; i += 0.5f) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.position().x + (double)i * this.getLookAngle().x, this.getEyePosition().y + (double)i * this.getLookAngle().y, this.position().z + (double)i * this.getLookAngle().z, Mth.clamp((int)count--, (int)1, (int)3), 0.15, 0.15, 0.15, 0.0025);
            }
            ParticleTool.spawnSmallExplosionParticles((Level)serverLevel, this.position());
            this.discard();
        }
    }

    public void look(Vec3 pTarget) {
        Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.apply((Entity)this);
        double d0 = (pTarget.x - vec3.x) * 0.2;
        double d2 = (pTarget.z - vec3.z) * 0.2;
        float diffY = Mth.wrapDegrees((float)(Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f)) - this.getYRot()));
        this.setYRot(this.getYRot() + 0.5f * diffY);
    }

    private void triggerExplode() {
        new CustomExplosion.Builder(this).damage(100.0f).radius(6.0f).attacker((Entity)this.getOwner()).withParticleType(ParticleTool.ParticleType.HUGE).explode();
        this.discard();
    }

    private PlayState movementPredicate(AnimationState<Ptkm1rEntity> event) {
        if (this.onGround()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.ptkm.deploy"));
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

