/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.GrapeshotEntity;
import com.atsuishio.superbwarfare.entity.projectile.GunGrenadeEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CannonShellEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float fireProbability = 0.0f;
    private int fireTime = 0;
    private Type type = Type.AP;
    private int sparedAmount = 50;
    private int sparedAngle = 15;

    public CannonShellEntity(EntityType<? extends CannonShellEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
    }

    public CannonShellEntity durability(int durability) {
        this.durability = durability;
        return this;
    }

    @ParametersAreNonnullByDefault
    public boolean isColliding(BlockPos pPos, BlockState pState) {
        return true;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putFloat("FireProbability", this.fireProbability);
        pCompound.putInt("FireTime", this.fireTime);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("FireProbability")) {
            this.fireProbability = pCompound.getFloat("FireProbability");
        }
        if (pCompound.contains("FireTime")) {
            this.fireTime = pCompound.getInt("FireTime");
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.HE_5_INCHES.get();
    }

    @Override
    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (this.level() instanceof ServerLevel) {
            if (this.type != Type.AP) {
                this.causeExplode(blockHitResult.getLocation());
                this.discard();
                return;
            }
            BlockPos resultPos = blockHitResult.getBlockPos();
            float hardness = this.level().getBlockState(resultPos).getBlock().defaultDestroyTime();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.getLocation());
                        this.firstHit = false;
                        Mod.queueServerWork(3, () -> ((CannonShellEntity)this).discard());
                    }
                    if (((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                        this.level().destroyBlock(resultPos, true);
                    }
                }
            } else {
                this.causeExplode(blockHitResult.getLocation());
                this.discard();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.getLocation());
                this.discard();
            }
        }
    }

    @Override
    public void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (this.level() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity;
            Entity entity2 = entityHitResult.getEntity();
            if (this.getOwner() != null && entity2 == this.getOwner().getVehicle()) {
                return;
            }
            if (this.type == Type.GRAPE) {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeGrapeShotHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), 0.5f * this.damage);
            } else {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeProjectileHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.damage);
            }
            if (entity2 instanceof LivingEntity) {
                entity2.invulnerableTime = 0;
            }
            if ((entity = this.getOwner()) instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            ParticleTool.cannonHitParticles(this.level(), this.position(), (Entity)this);
            this.causeExplode(entityHitResult.getLocation());
            if (entity2 instanceof VehicleEntity) {
                this.discard();
            }
        }
    }

    @Override
    public void tick() {
        if (this.type == Type.GRAPE) {
            this.releaseGrapeShot((LivingEntity)this.getOwner());
        }
        super.tick();
        this.mediumTrail();
        this.destroyBlock();
        if (this.tickCount > 600) {
            if (this.level() instanceof ServerLevel) {
                this.causeExplode(this.position());
            }
            this.discard();
        }
        if (this.type == Type.CM && this.tickCount > 3) {
            Entity target;
            int sparedTime = 7;
            BlockHitResult hitResult = this.level().clip(new ClipContext(this.position(), this.position().add(this.getDeltaMovement().scale((double)sparedTime)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this));
            if (hitResult.getType() == HitResult.Type.BLOCK) {
                this.releaseClusterMunitions((LivingEntity)this.getOwner());
            }
            if ((target = TraceTool.findLookingEntity((Entity)this, this.getDeltaMovement().scale((double)sparedTime).length())) != null && target != this) {
                this.releaseClusterMunitions((LivingEntity)this.getOwner());
            }
        }
    }

    public void releaseClusterMunitions(LivingEntity shooter) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.spawnMediumExplosionParticles((Level)serverLevel, this.position());
            for (int index0 = 0; index0 < this.sparedAmount; ++index0) {
                GunGrenadeEntity gunGrenadeEntity = new GunGrenadeEntity((Entity)shooter, (Level)serverLevel, 6.0f * this.damage / (float)this.sparedAmount, 5.0f * this.explosionDamage / (float)this.sparedAmount, this.explosionRadius / 2.0f);
                gunGrenadeEntity.setPos(this.position().x, this.position().y, this.position().z);
                gunGrenadeEntity.shoot(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, (float)((double)(this.random.nextFloat() * 0.2f) + (double)0.4f * this.getDeltaMovement().length()), this.sparedAngle);
                serverLevel.addFreshEntity((Entity)gunGrenadeEntity);
            }
            this.discard();
        }
    }

    public void releaseGrapeShot(LivingEntity shooter) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int index0 = 0; index0 < this.sparedAmount; ++index0) {
                GrapeshotEntity grapeProjectileEntity = new GrapeshotEntity((Entity)shooter, (Level)serverLevel, this.damage / (float)this.sparedAmount);
                grapeProjectileEntity.setPos(this.xo, this.yo, this.zo);
                grapeProjectileEntity.shoot(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, (float)((double)(this.random.nextFloat() * 0.2f) + (double)0.9f * this.getDeltaMovement().length()), this.sparedAngle);
                serverLevel.addFreshEntity((Entity)grapeProjectileEntity);
            }
            this.discard();
        }
    }

    @Override
    public void syncMotion() {
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientMotionSyncMessage((Entity)this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public boolean discardAfterExplode() {
        return true;
    }

    private PlayState movementPredicate(AnimationState<CannonShellEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cannon_shell.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.07f;
    }

    @Override
    public boolean forceLoadChunk() {
        return true;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setSparedAmount(int sparedAmount) {
        this.sparedAmount = sparedAmount;
    }

    public void setSparedAngle(int sparedAngle) {
        this.sparedAngle = sparedAngle;
    }

    public static enum Type {
        AP,
        HE,
        CM,
        GRAPE;

    }
}

