/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.GunGrenadeEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MediumRocketEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private Type type = Type.AP;
    private float fireProbability = 0.0f;
    private int fireTime = 0;
    private int sparedAmount = 50;
    private int sparedAngle = 15;

    public MediumRocketEntity(EntityType<? extends MediumRocketEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public MediumRocketEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel, float damage, float radius, float explosionDamage, float fireProbability, int fireTime, Type type, int sparedAmount, int sparedAngle) {
        super(pEntityType, pX, pY, pZ, pLevel);
        this.noCulling = true;
        this.damage = damage;
        this.explosionRadius = radius;
        this.explosionDamage = explosionDamage;
        this.fireProbability = fireProbability;
        this.fireTime = fireTime;
        this.type = type;
        this.sparedAmount = sparedAmount;
        this.sparedAngle = sparedAngle;
    }

    public MediumRocketEntity durability(int durability) {
        this.durability = durability;
        return this;
    }

    @ParametersAreNonnullByDefault
    public boolean isColliding(BlockPos pPos, BlockState pState) {
        return true;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putFloat("FireProbability", this.fireProbability);
        pCompound.putInt("FireTime", this.fireTime);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("FireProbability")) {
            this.fireProbability = pCompound.getFloat("FireProbability");
        }
        if (pCompound.contains("FireTime")) {
            this.fireTime = pCompound.getInt("FireTime");
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.SMALL_ROCKET.get();
    }

    @Override
    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (this.level() instanceof ServerLevel) {
            if (this.type == Type.HE || this.type == Type.CM) {
                this.causeExplode(blockHitResult.getLocation());
                this.discard();
                return;
            }
            BlockPos resultPos = blockHitResult.getBlockPos();
            float hardness = this.level().getBlockState(resultPos).getBlock().defaultDestroyTime();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.getLocation());
                        this.firstHit = false;
                        Mod.queueServerWork(3, () -> ((MediumRocketEntity)this).discard());
                    }
                    if (((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                        this.level().destroyBlock(resultPos, true);
                    }
                }
            } else {
                this.causeExplode(blockHitResult.getLocation());
                this.discard();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.getLocation());
                this.discard();
            }
        }
    }

    @Override
    public void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (this.tickCount < 2) {
            return;
        }
        if (this.level() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity;
            Entity entity2 = entityHitResult.getEntity();
            if (this.getOwner() != null && entity2 == this.getOwner().getVehicle() && this.tickCount < 2) {
                return;
            }
            DamageHandler.doDamage(entity2, ModDamageTypes.causeProjectileHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.damage);
            if (entity2 instanceof LivingEntity) {
                entity2.invulnerableTime = 0;
            }
            if ((entity = this.getOwner()) instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            ParticleTool.cannonHitParticles(this.level(), this.position(), (Entity)this);
            this.causeExplode(entityHitResult.getLocation());
            if (entity2 instanceof VehicleEntity) {
                this.discard();
            }
        }
    }

    @Override
    public void tick() {
        BlockHitResult hitResult;
        super.tick();
        this.largeTrail();
        this.destroyBlock();
        if (this.tickCount > 600 || this.isInWater()) {
            if (this.level() instanceof ServerLevel) {
                this.causeExplode(this.position());
            }
            this.discard();
        }
        if (this.type == Type.CM && (hitResult = this.level().clip(new ClipContext(this.position(), this.position().add(this.getDeltaMovement().scale(8.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this))).getType() == HitResult.Type.BLOCK) {
            this.releaseClusterMunitions((LivingEntity)this.getOwner());
        }
    }

    @Override
    public void syncMotion() {
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientMotionSyncMessage((Entity)this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public boolean discardAfterExplode() {
        return true;
    }

    private void releaseClusterMunitions(LivingEntity shooter) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.spawnMediumExplosionParticles((Level)serverLevel, this.position());
            for (int index0 = 0; index0 < this.sparedAmount; ++index0) {
                GunGrenadeEntity gunGrenadeEntity = new GunGrenadeEntity((Entity)shooter, (Level)serverLevel, 6.0f * this.damage / (float)this.sparedAmount, 5.0f * this.explosionDamage / (float)this.sparedAmount, this.explosionRadius / 2.0f);
                gunGrenadeEntity.setPos(this.position().x, this.position().y, this.position().z);
                gunGrenadeEntity.shoot(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, (float)((double)(this.random.nextFloat() * 0.2f) + (double)0.4f * this.getDeltaMovement().length()), this.sparedAngle);
                serverLevel.addFreshEntity((Entity)gunGrenadeEntity);
            }
            this.discard();
        }
    }

    private PlayState movementPredicate(AnimationState<MediumRocketEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.rpg.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.7f;
    }

    @Override
    public boolean forceLoadChunk() {
        return true;
    }

    public static enum Type {
        AP,
        HE,
        CM;

    }
}

