/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PtkmProjectileEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int shootTime = 3;
    @Nullable
    private Entity target = null;

    public PtkmProjectileEntity(EntityType<? extends PtkmProjectileEntity> type, Level level) {
        super(type, level);
        this.damage = 500.0f;
        this.explosionDamage = 80.0f;
        this.explosionRadius = 7.0f;
    }

    public PtkmProjectileEntity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.PTKM_PROJECTILE.get()), (Entity)entity, level);
        this.damage = 500.0f;
        this.explosionDamage = 80.0f;
        this.explosionRadius = 7.0f;
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.PTKM_1R.get();
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (this.level() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity;
            Entity entity2 = entityHitResult.getEntity();
            if (this.getOwner() != null && entity2 == this.getOwner().getVehicle()) {
                return;
            }
            if (this.target != null && this.tickCount > this.shootTime) {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeProjectileHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.damage);
            } else {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeProjectileHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), 20.0f);
            }
            if (entity2 instanceof LivingEntity) {
                entity2.invulnerableTime = 0;
            }
            if ((entity = this.getOwner()) instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.explode(entityHitResult.getLocation());
            this.discard();
        }
    }

    @Override
    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (this.level() instanceof ServerLevel) {
            this.explode(blockHitResult.getLocation());
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.largeTrail();
        if (this.target != null) {
            if (this.tickCount == this.shootTime) {
                Vec3 targetVel = this.target.getDeltaMovement();
                Vec3 targetVec = RangeTool.calculateFiringSolution(this.position(), this.target.getBoundingBox().getCenter(), targetVel, 15.0, 0.05);
                this.setDeltaMovement(targetVec.scale(15.0));
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    float i;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.playSound(null, BlockPos.containing((Position)this.position()), (SoundEvent)ModSounds.EXPLOSION_AIR.get(), SoundSource.BLOCKS, 8.0f, 1.0f);
                    ParticleTool.spawnSmallExplosionParticles((Level)serverLevel, this.position());
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.LARGE_SMOKE, this.position().x, this.position().y, this.position().z, 40, 0.5, 0.25, 0.5, 0.01, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.position().x, this.position().y, this.position().z, 30, 0.5, 0.25, 0.5, 0.005, true);
                    PtkmProjectileEntity.spawnDirectionalParticles((Entity)this, 55, 3.25, serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE);
                    PtkmProjectileEntity.spawnDirectionalParticles((Entity)this, 50, 3.0, serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE);
                    PtkmProjectileEntity.spawnDirectionalParticles((Entity)this, 45, 2.75, serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE);
                    PtkmProjectileEntity.spawnDirectionalParticles((Entity)this, 40, 2.5, serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE);
                    int count = 8;
                    for (i = 0.0f; i < this.distanceTo(this.target); i += 0.5f) {
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, this.position().x + (double)i * this.getDeltaMovement().normalize().x, this.position().y + (double)i * this.getDeltaMovement().normalize().y, this.position().z + (double)i * this.getDeltaMovement().normalize().z, Mth.clamp((int)count--, (int)2, (int)8), 0.25, 0.25, 0.25, 0.0025, true);
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.FLAME, this.position().x + (double)i * this.getDeltaMovement().normalize().x, this.position().y + (double)i * this.getDeltaMovement().normalize().y, this.position().z + (double)i * this.getDeltaMovement().normalize().z, Mth.clamp((int)count--, (int)2, (int)8), 0.25, 0.25, 0.25, 0.0025, true);
                    }
                    for (i = 0.0f; i < 16.0f; i += 0.5f) {
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.position().x + (double)i * this.getDeltaMovement().scale((double)-1.0).normalize().x, this.position().y + (double)i * this.getDeltaMovement().scale((double)-1.0).normalize().y, this.position().z + (double)i * this.getDeltaMovement().scale((double)-1.0).normalize().z, Mth.clamp((int)count--, (int)2, (int)8), 0.25, 0.25, 0.25, 0.0025, true);
                    }
                }
            }
        } else if (this.tickCount > 100) {
            this.explode(this.position());
        }
    }

    public void explode(Vec3 pos) {
        new CustomExplosion.Builder((Entity)this).damageSource(ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), (Entity)this, this.getOwner())).damage(this.explosionDamage).radius(this.explosionRadius).position(pos).withParticleType(ParticleTool.ParticleType.MEDIUM).particlePosition(pos).explode();
    }

    public void setShootTime(int time) {
        this.shootTime = time;
    }

    public void setTarget(Entity entity) {
        this.target = entity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void spawnDirectionalParticles(Entity projectile, int count, double radius, ServerLevel level, SimpleParticleType particle) {
        Vec3 deltaMovement = projectile.getDeltaMovement();
        Vec3 direction = deltaMovement.normalize();
        Vec3 position = projectile.position();
        Vec3 randomPerp = PtkmProjectileEntity.getRandomPerpendicular(direction);
        Vec3 u = randomPerp.normalize();
        Vec3 v = direction.cross(u).normalize();
        PtkmProjectileEntity.spawnCircularParticles(level, position, u, v, count, radius, particle);
    }

    private static Vec3 getRandomPerpendicular(Vec3 dir) {
        Vec3 candidate1 = new Vec3(dir.y, -dir.x, 0.0);
        if (candidate1.lengthSqr() > 1.0E-4) {
            return candidate1;
        }
        return new Vec3(0.0, dir.z, -dir.y);
    }

    private static void spawnCircularParticles(ServerLevel level, Vec3 center, Vec3 u, Vec3 v, int count, double radius, SimpleParticleType particle) {
        for (int i = 0; i < count; ++i) {
            double theta = Math.PI * 2 * (double)i / (double)count;
            double xOffset = radius * (Math.cos(theta) * u.x + Math.sin(theta) * v.x);
            double yOffset = radius * (Math.cos(theta) * u.y + Math.sin(theta) * v.y);
            double zOffset = radius * (Math.cos(theta) * u.z + Math.sin(theta) * v.z);
            Vec3 pos = center.add(xOffset, yOffset, zOffset);
            PtkmProjectileEntity.spawnParticle(level, pos, particle);
        }
    }

    private static void spawnParticle(ServerLevel level, Vec3 pos, SimpleParticleType particle) {
        ParticleTool.sendParticle(level, particle, pos.x, pos.y, pos.z, 1, 0.02, 0.02, 0.02, 1.0E-4, true);
    }

    @Override
    public void largeTrail() {
        if (this.level().isClientSide && this.tickCount > 0) {
            double l = this.getDeltaMovement().length();
            for (double i = 0.0; i < l; i += 1.0) {
                Vec3 startPos = new Vec3(this.xo, this.yo, this.zo);
                Vec3 pos = startPos.add(this.getDeltaMovement().normalize().scale(-i));
                this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isFastMoving() {
        return false;
    }
}

