/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RgoGrenadeEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int fuse = 80;

    public RgoGrenadeEntity(EntityType<? extends RgoGrenadeEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
        this.explosionDamage = ((Integer)ExplosionConfig.RGO_GRENADE_EXPLOSION_DAMAGE.get()).intValue();
        this.explosionRadius = ((Integer)ExplosionConfig.RGO_GRENADE_EXPLOSION_RADIUS.get()).intValue();
    }

    public RgoGrenadeEntity(EntityType<? extends RgoGrenadeEntity> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
        this.noCulling = true;
        this.explosionDamage = ((Integer)ExplosionConfig.RGO_GRENADE_EXPLOSION_DAMAGE.get()).intValue();
        this.explosionRadius = ((Integer)ExplosionConfig.RGO_GRENADE_EXPLOSION_RADIUS.get()).intValue();
    }

    public RgoGrenadeEntity(LivingEntity entity, Level level, int fuse) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.RGO_GRENADE.get()), (Entity)entity, level);
        this.noCulling = true;
        this.explosionDamage = ((Integer)ExplosionConfig.RGO_GRENADE_EXPLOSION_DAMAGE.get()).intValue();
        this.explosionRadius = ((Integer)ExplosionConfig.RGO_GRENADE_EXPLOSION_RADIUS.get()).intValue();
        this.fuse = fuse;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putFloat("Fuse", (float)this.fuse);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Fuse")) {
            this.fuse = pCompound.getInt("Fuse");
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.RGO_GRENADE.get();
    }

    protected void onHit(@NotNull HitResult result) {
        if (this.level() instanceof ServerLevel) {
            switch (result.getType()) {
                case BLOCK: {
                    BlockHitResult blockResult = (BlockHitResult)result;
                    BlockPos resultPos = blockResult.getBlockPos();
                    BlockState state = this.level().getBlockState(resultPos);
                    Block block = state.getBlock();
                    if (block instanceof BellBlock) {
                        BellBlock bell = (BellBlock)block;
                        bell.attemptToRing(this.level(), resultPos, blockResult.getDirection());
                    }
                    ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.2f);
                    break;
                }
                case ENTITY: {
                    LivingEntity living;
                    EntityHitResult entityResult = (EntityHitResult)result;
                    Entity entity = entityResult.getEntity();
                    if (this.getOwner() != null && this.getOwner().getVehicle() != null && entity == this.getOwner().getVehicle()) {
                        return;
                    }
                    Entity entity2 = this.getOwner();
                    if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).level().isClientSide() && living instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)living;
                        living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    if (entity instanceof DroneEntity) break;
                    ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.2f);
                    break;
                }
            }
        }
    }

    @Override
    public void tick() {
        Level level;
        super.tick();
        --this.fuse;
        if (this.fuse <= 0) {
            this.discard();
            if (!this.level().isClientSide) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.2f);
            }
        }
        if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, this.xo, this.yo, this.zo, 1, 0.0, 0.0, 0.0, 0.01, true);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

