/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.client.particle.CustomSmokeOption;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SmokeDecoyEntity
extends Entity {
    public int life = 400;
    public int igniteTime = 4;
    public boolean releaseSmoke = true;

    public SmokeDecoyEntity(EntityType<? extends SmokeDecoyEntity> type, Level level) {
        super(type, level);
    }

    public SmokeDecoyEntity(EntityType<? extends SmokeDecoyEntity> type, Level level, boolean release) {
        super(type, level);
        this.releaseSmoke = release;
    }

    public SmokeDecoyEntity(Level level) {
        super((EntityType)ModEntities.SMOKE_DECOY.get(), level);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        if (compoundTag.contains("IgniteTime")) {
            this.igniteTime = compoundTag.getInt("IgniteTime");
        }
        if (compoundTag.contains("Life")) {
            this.life = compoundTag.getInt("Life");
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        compoundTag.putInt("IgniteTime", this.igniteTime);
        compoundTag.putInt("Life", this.life);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.tickCount == this.igniteTime) {
            if (this.releaseSmoke) {
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ParticleTool.sendParticle(serverLevel, new CustomSmokeOption(1.0f, 1.0f, 1.0f), this.xo, this.yo, this.zo, 50, 0.0, 0.0, 0.0, 0.07, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.LARGE_SMOKE, this.xo, this.yo, this.zo, 10, 1.0, 1.0, 1.0, 0.1, true);
                    ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.xo, this.yo, this.zo, 30, 0.0, 0.0, 0.0, 0.2, true);
                }
                this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.SMOKE_FIRE.get(), this.getSoundSource(), 2.0f, this.random.nextFloat() * 0.05f + 1.0f);
            }
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (this.tickCount > this.life) {
            this.discard();
        }
    }

    public void decoyShoot(Entity entity, Vec3 shootVec, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = shootVec.normalize().add(this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy), this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy), this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy)).scale((double)pVelocity);
        this.setDeltaMovement(entity.getDeltaMovement().scale(0.75).add(vec3));
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }
}

