/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.CustomDamageProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class TaserBulletEntity
extends AbstractArrow
implements GeoEntity,
CustomDamageProjectile {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private Vec3 initialPos;
    private float damage = 1.0f;
    private int volt = 0;
    private int wireLength = 0;
    private boolean stopped = false;

    public TaserBulletEntity(EntityType<? extends TaserBulletEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public float getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    public int getVolt() {
        return this.volt;
    }

    public void setVolt(int volt) {
        this.volt = volt;
    }

    public int getWireLength() {
        return this.wireLength;
    }

    public void setWireLength(int wireLength) {
        this.wireLength = wireLength;
    }

    public void playerTouch(@NotNull Player pEntity) {
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    /*
     * Unable to fully structure code
     */
    protected void onHitEntity(EntityHitResult result) {
        block5: {
            entity = result.getEntity();
            if (this.getOwner() != null && this.getOwner().getVehicle() != null && entity == this.getOwner().getVehicle()) {
                return;
            }
            var4_3 = this.getOwner();
            if (var4_3 instanceof LivingEntity && !(living = (LivingEntity)var4_3).level().isClientSide() && living instanceof ServerPlayer) {
                player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!(entity instanceof LivingEntity)) break block5;
            living = (LivingEntity)entity;
            entity.invulnerableTime = 0;
            DamageHandler.doDamage(entity, ModDamageTypes.causeShockDamage(this.level().registryAccess(), this.getOwner()), this.damage);
            if (living instanceof Player && (player = (Player)living).isCreative()) {
                return;
            }
            if (living.level().isClientSide()) break block5;
            if (!(living instanceof Creeper)) ** GOTO lbl-1000
            creeper = (Creeper)living;
            var6_5 = living.level();
            if (var6_5 instanceof ServerLevel) {
                serverLevel = (ServerLevel)var6_5;
                creeper.thunderHit(serverLevel, new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)serverLevel));
            } else lbl-1000:
            // 2 sources

            {
                living.addEffect(new MobEffectInstance(ModMobEffects.SHOCK, 100 + this.volt * 30, this.volt), this.getOwner());
            }
        }
        this.discard();
    }

    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        BlockPos resultPos = blockHitResult.getBlockPos();
        BlockState state = this.level().getBlockState(resultPos);
        Block block = state.getBlock();
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.attemptToRing(this.level(), resultPos, blockHitResult.getDirection());
        }
    }

    public void tick() {
        super.tick();
        if (this.tickCount == 1) {
            this.initialPos = this.position();
        }
        if (this.initialPos != null && this.position().distanceTo(this.initialPos) > (double)(10 + 4 * this.wireLength) && !this.stopped) {
            this.stopped = true;
            this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
        }
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

