/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class A10Entity
extends GeoVehicleEntity {
    public A10Entity(EntityType<A10Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.25f) * damage.floatValue() * (this.getHealth() > 0.1f ? 0.4f : 0.05f)));
    }

    @Override
    public void onEngine1Damaged(Vec3 pos) {
        if (this.level().isClientSide) {
            float random = 2.0f * (this.random.nextFloat() - 0.5f);
            this.addRandomParticle((ParticleOptions)ModParticleTypes.FIRE_STAR.get(), pos, 0.0f, this.level(), 0.25f, 5);
            this.addRandomParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos, 0.5f, this.level(), 0.001f, 1);
            this.addRandomParticle(new CustomCloudOption(1.0f, 0.25f, 0.0f, (int)(240.0f + 40.0f * random), 2.5f + 0.5f * random, -0.07f, true, true), pos, 0.5f, this.level(), 1.5f, 1);
        }
    }

    @Override
    public void onEngine2Damaged(Vec3 pos) {
        if (this.level().isClientSide) {
            float random = 2.0f * (this.random.nextFloat() - 0.5f);
            this.addRandomParticle((ParticleOptions)ModParticleTypes.FIRE_STAR.get(), pos, 0.0f, this.level(), 0.25f, 5);
            this.addRandomParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos, 0.5f, this.level(), 0.001f, 1);
            this.addRandomParticle(new CustomCloudOption(1.0f, 0.25f, 0.0f, (int)(240.0f + 40.0f * random), 2.5f + 0.5f * random, -0.07f, true, true), pos, 0.5f, this.level(), 1.5f, 1);
        }
    }

    @Override
    public double getMouseSensitivity() {
        return ClientEventHandler.zoomVehicle ? 0.03 : 0.07;
    }
}

