/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Vector3f;
import org.joml.Vector4d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class AnnihilatorEntity
extends ArtilleryEntity {
    public static final EntityDataAccessor<Float> LASER_LEFT_LENGTH = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LASER_MIDDLE_LENGTH = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LASER_RIGHT_LENGTH = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public AnnihilatorEntity(EntityType<AnnihilatorEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LASER_LEFT_LENGTH, (Object)Float.valueOf(0.0f)).define(LASER_MIDDLE_LENGTH, (Object)Float.valueOf(0.0f)).define(LASER_RIGHT_LENGTH, (Object)Float.valueOf(0.0f));
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (player.getMainHandItem().getItem() == ModItems.FIRING_PARAMETERS.get() && player.isCrouching()) {
            this.setTarget(player.getOffhandItem());
            return InteractionResult.SUCCESS;
        }
        if (player.getOffhandItem().getItem() == ModItems.FIRING_PARAMETERS.get() && player.isCrouching()) {
            this.setTarget(player.getOffhandItem());
            return InteractionResult.SUCCESS;
        }
        if (stack.is(ModTags.Items.TOOLS_CROWBAR) && !player.isCrouching()) {
            if (((Float)this.entityData.get(CHARGE_PROGRESS)).floatValue() >= 1.0f) {
                this.vehicleShoot((LivingEntity)player, "Main");
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public void setTarget(ItemStack stack) {
        FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
        if (parameters == null) {
            return;
        }
        BlockPos pos = parameters.pos();
        int targetX = pos.getX();
        int targetY = pos.getY();
        int targetZ = pos.getZ();
        this.entityData.set(TARGET_POS, (Object)new Vector3f((float)targetX, (float)targetY, (float)targetZ));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 3.0f) * damage.floatValue()));
    }

    @Override
    public void baseTick() {
        super.baseTick();
        String weaponName = "Main";
        GunData data = this.getGunData(weaponName);
        if (data != null) {
            ProjectileInfo projectileInfo = data.compute().projectile();
            String projectileType = projectileInfo.type;
            String projectileTypeStr = projectileType.trim().toLowerCase(Locale.ROOT);
            int rpm = (int)Math.ceil((float)(20.0f / ((float)this.vehicleWeaponRpm(weaponName) / 60.0f)));
            if (projectileTypeStr.equals("ray") && ((Float)this.entityData.get(CHARGE_PROGRESS)).floatValue() < 1.0f && this.getEnergy() > data.compute().ammoCostPerShoot) {
                float chargeSpeed = 1.0f / (float)rpm;
                this.entityData.set(CHARGE_PROGRESS, (Object)Float.valueOf(Mth.clamp((float)(((Float)this.entityData.get(CHARGE_PROGRESS)).floatValue() + chargeSpeed), (float)0.0f, (float)1.0f)));
            }
        }
    }

    private float laserLength(Vec3 pos, LivingEntity living, GunData data) {
        BlockHitResult result = this.level().clip(new ClipContext(pos, pos.add(this.getBarrelVector(1.0f).scale(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        Vec3 hitPos = result.getLocation();
        BlockPos blockPos = result.getBlockPos();
        float hardness = this.level().getBlockState(blockPos).getBlock().defaultDestroyTime();
        if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue() && hardness != -1.0f) {
            Block.dropResources((BlockState)this.level().getBlockState(blockPos), (LevelAccessor)this.level(), (BlockPos)blockPos, null);
            this.level().destroyBlock(blockPos, true);
        }
        this.causeLaserExplode(hitPos, data, (Entity)living);
        this.level().explode((Entity)living, hitPos.x, hitPos.y, hitPos.z, (float)(data.compute().explosionRadius * 0.5), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        return (float)pos.distanceTo(hitPos);
    }

    private float laserLengthEntity(Vec3 pos, LivingEntity living, GunData data) {
        if (this.level() instanceof ServerLevel) {
            AABB aabb;
            double blockReach;
            double distance = 262144.0;
            HitResult hitResult = TraceTool.pickNew(pos, 512.0, this.getBarrelVector(1.0f), this);
            if (hitResult.getType() != HitResult.Type.MISS && (distance = hitResult.getLocation().distanceToSqr(pos)) > (blockReach = 5.0) * blockReach) {
                Vec3 posB = hitResult.getLocation();
                hitResult = BlockHitResult.miss((Vec3)posB, (Direction)Direction.getNearest((double)pos.x, (double)pos.y, (double)pos.z), (BlockPos)BlockPos.containing((Position)posB));
            }
            Vec3 viewVec = this.getBarrelVector(1.0f);
            Vec3 toVec = pos.add(viewVec.x * 512.0, viewVec.y * 512.0, viewVec.z * 512.0);
            EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)this, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = this.getBoundingBox().expandTowards(viewVec.scale(512.0)).inflate(1.0)), p -> !p.isSpectator(), (double)distance);
            if (entityhitresult != null) {
                Vec3 targetPos = entityhitresult.getLocation();
                double distanceToTarget = pos.distanceToSqr(targetPos);
                if (distanceToTarget > distance || distanceToTarget > 262144.0) {
                    hitResult = BlockHitResult.miss((Vec3)targetPos, (Direction)Direction.getNearest((double)viewVec.x, (double)viewVec.y, (double)viewVec.z), (BlockPos)BlockPos.containing((Position)targetPos));
                } else if (distanceToTarget < distance) {
                    hitResult = entityhitresult;
                }
                if (hitResult.getType() == HitResult.Type.ENTITY) {
                    Entity passenger = this.getFirstPassenger();
                    Entity target = ((EntityHitResult)hitResult).getEntity();
                    DamageHandler.doDamage(target, ModDamageTypes.causeLaserDamage(this.level().registryAccess(), this, passenger), (float)data.compute().damage);
                    target.invulnerableTime = 0;
                    this.causeLaserExplode(targetPos, data, (Entity)living);
                    return (float)pos.distanceTo(hitResult.getLocation());
                }
            }
        }
        return 512.0f;
    }

    private void causeLaserExplode(Vec3 vec3, GunData gunData, Entity living) {
        float radius = (float)gunData.compute().explosionRadius;
        ParticleTool.ParticleType particleType = radius <= 4.0f ? ParticleTool.ParticleType.SMALL : (radius > 4.0f && radius < 10.0f ? ParticleTool.ParticleType.MEDIUM : (radius >= 10.0f && radius < 20.0f ? ParticleTool.ParticleType.HUGE : ParticleTool.ParticleType.GIANT));
        this.createCustomExplosion().damage((float)gunData.compute().explosionDamage).radius(radius).attacker(living).position(vec3).withParticleType(particleType).explode();
    }

    @Override
    public void vehicleShoot(LivingEntity living, String weaponName) {
        GunData data = this.getGunData(weaponName);
        this.shoot(living, data);
    }

    @Override
    public void vehicleShoot(LivingEntity living, UUID uuid, Vec3 targetPos) {
        GunData data = this.getGunData((Entity)living);
        this.shoot(living, data);
    }

    public void shoot(LivingEntity living, GunData gunData) {
        if (gunData == null) {
            return;
        }
        if (this.level() instanceof ServerLevel) {
            this.entityData.set(CHARGE_PROGRESS, (Object)Float.valueOf(0.0f));
            this.consumeEnergy(gunData.compute().ammoCostPerShoot);
            Matrix4d transform = this.getBarrelTransform(1.0f);
            Vector4d worldPosition1 = this.transformPosition(transform, 2.703, -0.045, 15.75);
            Vector4d worldPosition2 = this.transformPosition(transform, 0.0, -0.045, 15.75);
            Vector4d worldPosition3 = this.transformPosition(transform, -2.703, -0.045, 15.75);
            Vec3 barrelLeftPos = new Vec3(worldPosition1.x, worldPosition1.y, worldPosition1.z);
            Vec3 barrelMiddlePos = new Vec3(worldPosition2.x, worldPosition2.y, worldPosition2.z);
            Vec3 barrelRightPos = new Vec3(worldPosition3.x, worldPosition3.y, worldPosition3.z);
            for (int i = 0; i < 10; ++i) {
                Mod.queueServerWork(i, () -> {
                    this.entityData.set(LASER_LEFT_LENGTH, (Object)Float.valueOf(Math.min((float)this.laserLength(barrelLeftPos, living, gunData), (float)this.laserLengthEntity(barrelLeftPos, living, gunData))));
                    this.entityData.set(LASER_MIDDLE_LENGTH, (Object)Float.valueOf(Math.min((float)this.laserLength(barrelMiddlePos, living, gunData), (float)this.laserLengthEntity(barrelMiddlePos, living, gunData))));
                    this.entityData.set(LASER_RIGHT_LENGTH, (Object)Float.valueOf(Math.min((float)this.laserLength(barrelRightPos, living, gunData), (float)this.laserLengthEntity(barrelRightPos, living, gunData))));
                });
            }
            int reloadTime = (int)Mth.clamp((float)(20.0f / ((float)Math.max((int)this.vehicleWeaponRpm("Main"), (int)1) / 60.0f)), (float)1.0f, (float)2.1474836E9f);
            Mod.queueServerWork(reloadTime - 20, () -> {
                if (this.isAlive()) {
                    this.level().playSound(null, this.getOnPos(), gunData.compute().soundInfo.vehicleReload, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            });
            gunData.shakePlayers(this);
            this.playShootSound3p(living, gunData, barrelMiddlePos);
        }
    }

    @Override
    public boolean canShoot(LivingEntity living) {
        GunData gunData = this.getGunData(this.getSeatIndex((Entity)living));
        return gunData != null && gunData.canShoot(this.getAmmoSupplier()) && this.canConsume(gunData.compute().ammoCostPerShoot);
    }

    private PlayState movementPredicate(AnimationState<AnnihilatorEntity> event) {
        if (((Float)this.entityData.get(CHARGE_PROGRESS)).floatValue() < 1.0f) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.annihilator.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.annihilator.idle"));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }
}

