/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public class PrismTankEntity
extends GeoVehicleEntity {
    public PrismTankEntity(EntityType<PrismTankEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    public void hitBlock(Vec3 pos, GunData gunData, Entity shooter) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (gunData.compute().explosionRadius > 0.0) {
                this.findNearEntity(pos, gunData, shooter);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, pos.x, pos.y, pos.z, 24, 0.0, 0.0, 0.0, 0.2, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, pos.x, pos.y, pos.z, 8, 0.0, 0.0, 0.0, 0.4, true);
            } else {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, pos.x, pos.y, pos.z, 4, 0.0, 0.0, 0.0, 0.05, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, pos.x, pos.y, pos.z, 2, 0.0, 0.0, 0.0, 0.15, true);
            }
        }
    }

    public void hitEntity(Vec3 pos, GunData gunData, Entity shooter) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (gunData.compute().explosionRadius > 0.0) {
                this.findNearEntity(pos, gunData, shooter);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, pos.x, pos.y, pos.z, 24, 0.0, 0.0, 0.0, 0.2, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, pos.x, pos.y, pos.z, 8, 0.0, 0.0, 0.0, 0.4, true);
            } else {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, pos.x, pos.y, pos.z, 4, 0.0, 0.0, 0.0, 0.05, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, pos.x, pos.y, pos.z, 2, 0.0, 0.0, 0.0, 0.15, true);
            }
        }
    }

    public void findNearEntity(Vec3 vec, GunData gunData, Entity shooter) {
        double aoeDamage = gunData.compute().explosionDamage;
        double range = gunData.compute().explosionRadius;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<Entity> entities = new SeekTool.Builder(this).withinRange(vec, range).notItsVehicle().baseFilter().smokeFilter().noVehicle().differentTeam().build();
            for (Entity e : entities) {
                double dis = vec.distanceTo(e.getEyePosition());
                float i = 0.0f;
                while ((double)i < dis) {
                    Vec3 toVec = vec.vectorTo(e.getEyePosition()).normalize();
                    Vec3 pos = vec.add(toVec.scale((double)i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0, true);
                    i += 0.2f;
                }
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, e.getX(), e.getEyeY(), e.getZ(), 4, 0.0, 0.0, 0.0, 0.15, true);
                DamageHandler.doDamage(e, ModDamageTypes.causeLaserDamage(this.level().registryAccess(), this, shooter), (float)(aoeDamage - Mth.clamp((double)(dis / range), (double)0.0, (double)0.75) * aoeDamage));
                if (!(shooter instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)shooter;
                Holder holder = Holder.direct((Object)((SoundEvent)ModSounds.INDICATION.get()));
                player.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public float getWheelMaxHealth() {
        return 100.0f;
    }

    @Override
    public float getEngineMaxHealth() {
        return 150.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component firstPersonAmmoComponent(GunData data, Player player) {
        String name = data.compute().name;
        if (name == null || name.isBlank()) {
            return Component.empty();
        }
        return Component.translatable((String)name, (Object[])new Object[]{(int)(25.0 + data.heat.get()) + " \u00b0C"});
    }
}

