/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.block.VehicleAssemblingTableBlock;
import com.atsuishio.superbwarfare.block.property.BlockPart;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.menu.VehicleAssemblingMenu;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class VehicleAssemblingTableVehicleEntity
extends GeoVehicleEntity
implements HasCustomInventoryScreen,
MenuProvider {
    public float deltaXo;
    public float deltaYo;
    public float deltaX;
    public float deltaY;
    public int jumpCooldown;

    public VehicleAssemblingTableVehicleEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public VehicleAssemblingTableVehicleEntity(Level world) {
        this((EntityType)ModEntities.VEHICLE_ASSEMBLING_TABLE.get(), world);
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.getMainHandItem().is(ModTags.Items.TOOLS_CROWBAR) && !player.isCrouching()) {
            if (!this.level().isClientSide && this.getPassengers().isEmpty()) {
                BlockPos blockPos;
                Direction facing = this.getDirection();
                Vec3 currentPos = this.position();
                Vec3 targetPos = switch (facing) {
                    case Direction.WEST -> currentPos.add(-0.5, 0.0, -0.5);
                    case Direction.EAST -> currentPos.add(0.5, 0.0, 0.5);
                    case Direction.NORTH -> currentPos.add(0.5, 0.0, -0.5);
                    case Direction.SOUTH -> currentPos.add(-0.5, 0.0, 0.5);
                    default -> currentPos;
                };
                BlockPos targetBlockPos = BlockPos.containing((Position)targetPos);
                boolean canPlace = true;
                for (BlockPart part : BlockPart.values()) {
                    blockPos = part.relative(targetBlockPos, facing);
                    BlockState blockState = this.level().getBlockState(blockPos);
                    if (blockState.canBeReplaced()) continue;
                    canPlace = false;
                    break;
                }
                if (canPlace) {
                    for (BlockPart part : BlockPart.values()) {
                        blockPos = part.relative(targetBlockPos, facing);
                        BlockState state = (BlockState)((BlockState)((VehicleAssemblingTableBlock)((Object)ModBlocks.VEHICLE_ASSEMBLING_TABLE.get())).defaultBlockState().setValue((Property)VehicleAssemblingTableBlock.FACING, (Comparable)facing)).setValue(VehicleAssemblingTableBlock.BLOCK_PART, (Comparable)((Object)part));
                        this.level().setBlock(blockPos, state, 3);
                    }
                    this.discard();
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.vehicle_assembling_table.warn").withStyle(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
        return super.interact(player, hand);
    }

    @Override
    public void baseTick() {
        this.deltaXo = this.deltaX;
        this.deltaYo = this.deltaY;
        super.baseTick();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        this.deltaX = this.getMouseMoveSpeedY();
        if (this.leftInputDown() && this.rightInputDown()) {
            this.deltaX = 0.0f;
        } else if (this.leftInputDown()) {
            this.deltaX = -1.0f;
        } else if (this.rightInputDown()) {
            this.deltaX = 1.0f;
        }
        float f = this.onGround() ? 0.85f : 0.9f;
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, (double)f, (double)f));
        if (this.isInWater() && this.tickCount % 4 == 0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            if (this.lastTickSpeed > 0.4) {
                this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, this.getFirstPassenger() == null ? this : this.getFirstPassenger()), (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
            }
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.getFirstPassenger();
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.95f));
        if (passenger == null || this.isInWater()) {
            this.setLeftInputDown(false);
            this.setRightInputDown(false);
            this.setForwardInputDown(false);
            this.setBackInputDown(false);
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.96, 1.0, 0.96));
        } else if (passenger instanceof Player) {
            if (this.forwardInputDown()) {
                this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 0.1f), (float)1.0f)));
            }
            this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * 0.8f));
            if (this.backInputDown()) {
                this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - (((Float)this.entityData.get(POWER)).floatValue() > 0.0f ? 0.1f : 0.01f)), (float)(this.onGround() ? -0.2f : 0.2f))));
                if (this.rightInputDown()) {
                    this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.4f));
                } else if (this.leftInputDown()) {
                    this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.4f));
                }
            } else if (this.rightInputDown()) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.4f));
            } else if (this.leftInputDown()) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.4f));
            }
            if (this.downInputDown()) {
                this.entityData.set(POWER, (Object)Float.valueOf(0.0f));
            }
            if (this.upInputDown() && this.onGround() && this.jumpCooldown == 0) {
                this.jumpCooldown = 40;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.playSound(null, this.getOnPos(), (SoundEvent)ModSounds.WHEEL_CHAIR_JUMP.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                }
                Vec3 movement = this.getForward().multiply(1.0, 0.0, 1.0).normalize().scale(0.7);
                this.setDeltaMovement(this.getDeltaMovement().add(movement.x, 1.0, movement.z));
            }
            float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.wrapDegrees((float)(passenger.getYHeadRot() - this.getYRot())));
            float diffX = Math.clamp((float)-60.0f, (float)60.0f, (float)Mth.wrapDegrees((float)(passenger.getXRot() - this.getXRot())));
            float addX = Mth.clamp((float)(Math.min((float)((float)Math.max((double)(this.getDeltaMovement().length() - 0.1), (double)0.01)), (float)0.9f) * diffX), (float)-4.0f, (float)4.0f);
            float addZ = ((Float)this.entityData.get(DELTA_ROT)).floatValue() - (this.onGround() ? 0.0f : 0.01f) * diffY * (float)this.getDeltaMovement().length();
            float yRotSync = (float)(-Mth.clamp((double)(50.0 * this.getDeltaMovement().length()), (double)2.0, (double)4.0) * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue());
            this.setYRot(this.getYRot() + yRotSync);
            this.setXRot(Mth.clamp((float)(this.getXRot() + addX), (float)(this.onGround() ? -12.0f : -120.0f), (float)(this.onGround() ? 3.0f : 120.0f)));
            this.setZRot(this.getRoll() - 0.2f * addZ);
        }
        double powerValue = 0.05 * (double)((Float)this.entityData.get(POWER)).floatValue();
        this.setDeltaMovement(this.getDeltaMovement().add(this.getForward().multiply(1.0, 0.0, 1.0).normalize().multiply(powerValue, powerValue, powerValue)));
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.level() instanceof ServerLevel) {
            ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()));
            item.setPickUpDelay(50);
            this.level().addFreshEntity((Entity)item);
        }
    }

    @Override
    @NotNull
    public List<ItemStack> getRetrieveItems() {
        return List.of(new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()));
    }

    @Override
    public void openCustomInventoryScreen(@NotNull Player player) {
        player.openMenu((MenuProvider)this);
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new VehicleAssemblingMenu(i, inventory, ContainerLevelAccess.NULL, true);
    }
}

