/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.energy.SyncedEntityEnergyStorage;
import com.atsuishio.superbwarfare.capability.energy.VehicleEnergyStorage;
import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.StringOrVec3;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.data.gun.SoundInfo;
import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehiclePropertyModifier;
import com.atsuishio.superbwarfare.data.vehicle.subdata.CameraPos;
import com.atsuishio.superbwarfare.data.vehicle.subdata.DestroyInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.DismountInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineType;
import com.atsuishio.superbwarfare.data.vehicle.subdata.OBBInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeatInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleContainerType;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleType;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.entity.vehicle.Tom6Entity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleMiscUtils;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleMotionUtils;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleWeaponUtils;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.menu.VehicleMenu;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.resource.vehicle.VehicleResource;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileCalculator;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.world.TDMSavedData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector4d;

public abstract class VehicleEntity
extends Entity
implements VehiclePropertyModifier,
HasCustomInventoryScreen,
ContainerEntity,
OBBEntity {
    public static final String TAG_SEAT_INDEX = "SBWSeatIndex";
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> OVERRIDE = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> LAST_DRIVER_UUID = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> AI_TURRET_TARGET_UUID = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> AI_PASSENGER_WEAPON_TARGET_UUID = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> DELTA_ROT = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> MOUSE_SPEED_X = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> MOUSE_SPEED_Y = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<List<Integer>> SELECTED_WEAPON = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    public static final EntityDataAccessor<Float> TURRET_HEALTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> L_WHEEL_HEALTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> R_WHEEL_HEALTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> MAIN_ENGINE_HEALTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> SUB_ENGINE_HEALTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> TURRET_DAMAGED = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> L_WHEEL_DAMAGED = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> R_WHEEL_DAMAGED = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> MAIN_ENGINE_DAMAGED = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SUB_ENGINE_DAMAGED = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> HORN_VOLUME = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static Consumer<VehicleEntity> playTrackSound = vehicle -> {};
    public static Consumer<VehicleEntity> playEngineSound = vehicle -> {};
    public static Consumer<VehicleEntity> playSwimSound = vehicle -> {};
    public static Consumer<VehicleEntity> playHornSound = vehicle -> {};
    public static Consumer<VehicleEntity> playFireSound = vehicle -> {};
    public static boolean ignoreEntityGroundCheckStepping = false;
    public static final EntityDataAccessor<Float> SERVER_YAW = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> SERVER_PITCH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> CANNON_RECOIL_TIME = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> CANNON_RECOIL_FORCE = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> POWER = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> YAW_WHILE_SHOOT = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> AMMO = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DECOY_READY = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> PROPELLER_ROT = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> GEAR_ROT = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> GEAR_UP = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> FORWARD_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> BACK_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> LEFT_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> RIGHT_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> UP_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DOWN_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DECOY_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> FIRE_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SPRINT_INPUT_DOWN = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> PLANE_BREAK = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> LASER_LENGTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LASER_SCALE = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LASER_SCALE_O = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> CHARGE_PROGRESS = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Map<String, GunData>> GUN_DATA_MAP = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.VEHICLE_GUN_DATA_MAP_SERIALIZER.get()));
    private List<OBB> obbCache;
    private List<OBBInfo> obbInfoCache = new ArrayList<OBBInfo>();
    private EngineInfo engineCache;
    protected int interpolationSteps;
    protected double xO;
    protected double yO;
    protected double zO;
    protected float roll;
    public float prevRoll;
    public int repairCoolDown = this.maxRepairCoolDown();
    private boolean crash;
    private float turretYRot;
    private float turretXRot;
    public float turretYRotO;
    public float turretXRotO;
    public float turretYRotLock;
    private float gunYRot;
    private float gunXRot;
    public float gunYRotO;
    public float gunXRotO;
    protected int noPassengerTime;
    @Nullable
    protected Player damageDebugResultReceiver = null;
    private Vec3 previousVelocity = Vec3.ZERO;
    protected double acceleration;
    public int decoyReloadCoolDown;
    public double lastTickSpeed;
    protected double lastTickVerticalSpeed;
    public int collisionCoolDown;
    private boolean wasEngineRunning = false;
    private boolean wasHornWorking = false;
    private boolean wasFiring = false;
    public double targetSpeed;
    public float rudderRot;
    public float rudderRotO;
    private float leftWheelRot;
    private float rightWheelRot;
    public float leftWheelRotO;
    public float rightWheelRotO;
    public float leftTrackO;
    public float rightTrackO;
    private float leftTrack;
    private float rightTrack;
    private float propellerRot;
    public float propellerRotO;
    protected double recoilShake;
    public double recoilShakeO;
    public double velocityO;
    private double velocity;
    private float flap1LRot;
    public float flap1LRotO;
    private float flap1RRot;
    public float flap1RRotO;
    private float flap1L2Rot;
    public float flap1L2RotO;
    private float flap1R2Rot;
    public float flap1R2RotO;
    private float flap2LRot;
    public float flap2LRotO;
    private float flap2RRot;
    public float flap2RRotO;
    private float flap3Rot;
    public float flap3RotO;
    private float gearRotO;
    private float gearRot;
    public boolean engineStart;
    public boolean engineStartOver;
    public int holdTick;
    public int holdPowerTick;
    public float destroyRot;
    public int jumpCoolDown;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    private final List<Entity> orderedPassengers = this.generatePassengersList();
    public Function<Entity, Integer> entityIndexOverride = null;
    protected IEnergyStorage energyStorage = null;
    protected boolean isInitialized;
    protected Map<String, Function<Float, Matrix4d>> positionTransform = new HashMap<String, Function<Float, Matrix4d>>();
    protected Map<String, Function<Float, Vec3>> vectorTransform = new HashMap<String, Function<Float, Vec3>>();
    protected Map<String, Function<Float, Quaterniond>> rotationTransform = new HashMap<String, Function<Float, Quaterniond>>();

    public Map<String, GunData> getGunDataMap() {
        Map rawMap = (Map)this.entityData.get(GUN_DATA_MAP);
        HashMap<String, GunData> newMap = new HashMap<String, GunData>();
        Map<String, DefaultGunData> weapons = this.computed().weapons();
        for (Map.Entry<String, DefaultGunData> kv : weapons.entrySet()) {
            GunData data = (GunData)rawMap.get(kv.getKey());
            if (data == null) {
                data = GunData.from(new ItemStack((ItemLike)ModItems.VEHICLE_GUN.get()));
            }
            data.defaultDataSupplier = kv::getValue;
            newMap.put(kv.getKey(), data);
        }
        return newMap;
    }

    @Nullable
    public SeatInfo getSeat(int seatIndex) {
        if (seatIndex < 0) {
            return null;
        }
        List<SeatInfo> seats = this.computed().seats();
        if (seatIndex >= seats.size()) {
            return null;
        }
        return seats.get(seatIndex);
    }

    @Nullable
    public SeatInfo getSeat(Entity passenger) {
        return this.getSeat(this.getSeatIndex(passenger));
    }

    @Nullable
    public GunData getGunData(int seatIndex) {
        if (seatIndex < 0) {
            return null;
        }
        List selectedWeapon = (List)this.entityData.get(SELECTED_WEAPON);
        if (seatIndex >= selectedWeapon.size()) {
            return null;
        }
        return this.getGunData(seatIndex, (int)((Integer)selectedWeapon.get(seatIndex)));
    }

    @Nullable
    public GunData getGunData(int seatIndex, int weaponIndex) {
        SeatInfo seat = this.getSeat(seatIndex);
        if (seat == null) {
            return null;
        }
        List<String> weapons = seat.weapons();
        if (weaponIndex < 0 || weaponIndex >= weapons.size()) {
            return null;
        }
        return this.getGunData(weapons.get(weaponIndex));
    }

    @Nullable
    public GunData getGunData(Entity passenger, int weaponIndex) {
        return this.getGunData(this.getSeatIndex(passenger), weaponIndex);
    }

    @Nullable
    public GunData getGunData(Entity passenger) {
        return this.getGunData(passenger, this.getSelectedWeapon(this.getSeatIndex(passenger)));
    }

    @Nullable
    public GunData getGunData(String name) {
        return this.getGunDataMap().get(name);
    }

    @Nullable
    public String getGunName(int seatIndex) {
        if (seatIndex < 0) {
            return null;
        }
        SeatInfo seat = this.getSeat(seatIndex);
        if (seat == null) {
            return null;
        }
        List selectedWeapon = (List)this.entityData.get(SELECTED_WEAPON);
        if (seatIndex >= selectedWeapon.size()) {
            return null;
        }
        Integer weaponIndex = (Integer)selectedWeapon.get(seatIndex);
        if (weaponIndex < 0) {
            return null;
        }
        List<String> weapons = seat.weapons();
        if (weaponIndex >= weapons.size()) {
            return null;
        }
        return this.getGunName(seatIndex, weaponIndex);
    }

    @Nullable
    public String getGunName(int seatIndex, int weaponIndex) {
        if (seatIndex < 0) {
            return null;
        }
        SeatInfo seat = this.getSeat(seatIndex);
        if (seat == null) {
            return null;
        }
        List selectedWeapon = (List)this.entityData.get(SELECTED_WEAPON);
        if (seatIndex >= selectedWeapon.size()) {
            return null;
        }
        List<String> weapons = seat.weapons();
        if (weaponIndex >= weapons.size()) {
            return null;
        }
        return weapons.get(weaponIndex);
    }

    public void modifyGunData(int seatIndex, int weaponIndex, @NotNull Consumer<GunData> consumer) {
        this.modifyGunData(this.getGunName(seatIndex, weaponIndex), consumer);
    }

    public void modifyGunData(int seatIndex, @NotNull Consumer<GunData> consumer) {
        this.modifyGunData(this.getGunName(seatIndex), consumer);
    }

    public void modifyGunData(@Nullable String name, @NotNull Consumer<GunData> consumer) {
        if (name == null) {
            return;
        }
        Map<String, GunData> map = this.getGunDataMap();
        GunData data = this.getGunData(name);
        if (data == null) {
            return;
        }
        data = data.copy();
        consumer.accept(data);
        data.save();
        map.put(name, data);
        this.entityData.set(GUN_DATA_MAP, map, true);
    }

    public void setCrash(boolean crash) {
        this.crash = crash;
    }

    public VehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.registerTransforms();
        this.initOBB();
        if (this.hasEnergyStorage()) {
            this.energyStorage = new VehicleEnergyStorage(this);
        }
        this.isInitialized = true;
        this.setHealth(this.getMaxHealth());
    }

    private void initOBB() {
        this.obbInfoCache = ((DefaultVehicleData)this.data().getDefault().copy()).obb.stream().filter(Objects::nonNull).toList();
    }

    public List<OBBInfo> getOBB() {
        return this.obbInfoCache;
    }

    public void onSyncedDataUpdated(@NotNull List<SynchedEntityData.DataValue<?>> dataValues) {
        super.onSyncedDataUpdated(dataValues);
        this.data().update();
    }

    public void processInput(short keys) {
        this.setLeftInputDown((keys & 1) > 0);
        this.setRightInputDown((keys & 2) > 0);
        this.setForwardInputDown((keys & 4) > 0);
        this.setBackInputDown((keys & 8) > 0);
        this.setUpInputDown((keys & 0x10) > 0);
        this.setDownInputDown((keys & 0x20) > 0);
        this.setDecoyInputDown((keys & 0x40) > 0);
        this.setFireInputDown((keys & 0x80) > 0);
        this.setSprintInputDown((keys & 0x100) > 0);
    }

    public boolean forwardInputDown() {
        return (Boolean)this.entityData.get(FORWARD_INPUT_DOWN);
    }

    public boolean backInputDown() {
        return (Boolean)this.entityData.get(BACK_INPUT_DOWN);
    }

    public boolean leftInputDown() {
        return (Boolean)this.entityData.get(LEFT_INPUT_DOWN);
    }

    public boolean rightInputDown() {
        return (Boolean)this.entityData.get(RIGHT_INPUT_DOWN);
    }

    public boolean upInputDown() {
        return (Boolean)this.entityData.get(UP_INPUT_DOWN);
    }

    public boolean downInputDown() {
        return (Boolean)this.entityData.get(DOWN_INPUT_DOWN);
    }

    public boolean fireInputDown() {
        return (Boolean)this.entityData.get(FIRE_INPUT_DOWN);
    }

    public boolean decoyInputDown() {
        return (Boolean)this.entityData.get(DECOY_INPUT_DOWN);
    }

    public boolean sprintInputDown() {
        return (Boolean)this.entityData.get(SPRINT_INPUT_DOWN);
    }

    public void setForwardInputDown(boolean set) {
        this.entityData.set(FORWARD_INPUT_DOWN, (Object)set);
    }

    public void setBackInputDown(boolean set) {
        this.entityData.set(BACK_INPUT_DOWN, (Object)set);
    }

    public void setLeftInputDown(boolean set) {
        this.entityData.set(LEFT_INPUT_DOWN, (Object)set);
    }

    public void setRightInputDown(boolean set) {
        this.entityData.set(RIGHT_INPUT_DOWN, (Object)set);
    }

    public void setUpInputDown(boolean set) {
        this.entityData.set(UP_INPUT_DOWN, (Object)set);
    }

    public void setDownInputDown(boolean set) {
        this.entityData.set(DOWN_INPUT_DOWN, (Object)set);
    }

    public void setFireInputDown(boolean set) {
        this.entityData.set(FIRE_INPUT_DOWN, (Object)set);
    }

    public void setDecoyInputDown(boolean set) {
        this.entityData.set(DECOY_INPUT_DOWN, (Object)set);
    }

    public void setSprintInputDown(boolean set) {
        this.entityData.set(SPRINT_INPUT_DOWN, (Object)set);
    }

    public void mouseInput(double x, double y) {
        this.entityData.set(MOUSE_SPEED_X, (Object)Float.valueOf((float)x));
        this.entityData.set(MOUSE_SPEED_Y, (Object)Float.valueOf((float)y));
    }

    public float getMouseMoveSpeedY() {
        return ((Float)this.entityData.get(MOUSE_SPEED_Y)).floatValue();
    }

    public float getMouseMoveSpeedX() {
        return ((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue();
    }

    protected void resizeItems() {
        int currentSize;
        int newSize = this.getContainerSize();
        if (newSize == (currentSize = this.items.size())) {
            return;
        }
        if (newSize > currentSize) {
            NonNullList newItems = NonNullList.withSize((int)newSize, (Object)ItemStack.EMPTY);
            for (int i = 0; i < currentSize; ++i) {
                newItems.set(i, (Object)((ItemStack)this.items.get(i)));
            }
            this.items = newItems;
        } else {
            for (int i = newSize; i < currentSize; ++i) {
                ItemStack excessStack = (ItemStack)this.items.get(i);
                if (excessStack.isEmpty()) continue;
                this.spawnAtLocation(excessStack.copy());
            }
            NonNullList newItems = NonNullList.withSize((int)newSize, (Object)ItemStack.EMPTY);
            for (int i = 0; i < newSize; ++i) {
                newItems.set(i, (Object)((ItemStack)this.items.get(i)));
            }
            this.items = newItems;
        }
        this.setChanged();
    }

    public int countItem(@Nullable Item item) {
        if (item == null || !this.hasContainer()) {
            return 0;
        }
        return InventoryTool.countItem(this.items, item);
    }

    public boolean hasItem(Item item) {
        if (!this.hasContainer()) {
            return false;
        }
        return this.countItem(item) > 0;
    }

    public int consumeItem(Item item, int count) {
        if (!this.hasContainer()) {
            return 0;
        }
        return InventoryTool.consumeItem(this.items, item, count);
    }

    public void insertItem(Item item, int count) {
        if (!this.hasContainer()) {
            return;
        }
        int rest = InventoryTool.insertItem(this.items, item, count, this.getMaxStackSize());
        if (rest > 0) {
            ItemStack stackToDrop = new ItemStack((ItemLike)item, rest);
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stackToDrop));
        }
    }

    public int getContainerSize() {
        VehicleContainerType type = this.computed().vehicleContainerType;
        if (type == null) {
            return 0;
        }
        if (type.hasMenu()) {
            return 102;
        }
        return this.computed().vehicleContainerType.getSize();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (!this.hasContainer() || slot >= this.getContainerSize() || slot < 0) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int pAmount) {
        if (!this.hasContainer() || slot >= this.getContainerSize() || slot < 0) {
            return ItemStack.EMPTY;
        }
        return ContainerHelper.removeItem(this.items, (int)slot, (int)pAmount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        if (!this.hasContainer() || slot >= this.getContainerSize() || slot < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(slot, (Object)ItemStack.EMPTY);
        return itemstack;
    }

    public void setItem(int slot, @NotNull ItemStack pStack) {
        if (!this.hasContainer() || slot >= this.getContainerSize() || slot < 0) {
            return;
        }
        int limit = org.joml.Math.min((int)this.getMaxStackSize(), (int)pStack.getMaxStackSize());
        if (!pStack.isEmpty() && pStack.getCount() > limit) {
            Mod.LOGGER.warn("try inserting ItemStack {} exceeding the maximum stack size: {}, clamped to {}", (Object)pStack.getItem(), (Object)limit, (Object)limit);
            pStack.setCount(limit);
        }
        this.items.set(slot, (Object)pStack);
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return this.hasContainer() && !this.isRemoved() && this.position().closerThan((Position)pPlayer.position(), 8.0);
    }

    public void clearContent() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public boolean hasContainer() {
        return this.getContainerSize() > 0;
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        int stackCount;
        if (!this.hasContainer() || slot >= this.getContainerSize() || slot < 0) {
            return false;
        }
        ItemStack currentStack = (ItemStack)this.items.get(slot);
        if (!currentStack.isEmpty() && currentStack.getItem() != stack.getItem()) {
            return false;
        }
        int currentCount = currentStack.getCount();
        int combinedCount = currentCount + (stackCount = stack.getCount());
        if (combinedCount > this.getMaxStackSize() || combinedCount > stack.getMaxStackSize()) {
            return false;
        }
        return super.canPlaceItem(slot, stack);
    }

    public boolean canTakeItem(@NotNull Container target, int slot, @NotNull ItemStack stack) {
        if (!this.hasContainer() || slot >= this.getContainerSize() || slot < 0) {
            return false;
        }
        return super.canTakeItem(target, slot, stack);
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        if (!this.level().isClientSide && pReason != Entity.RemovalReason.DISCARDED) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(pReason);
    }

    public void openCustomInventoryScreen(Player pPlayer) {
        pPlayer.openMenu((MenuProvider)this);
        if (!pPlayer.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)pPlayer);
        }
    }

    public ResourceKey<LootTable> getLootTable() {
        return null;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTable) {
    }

    public long getLootTableSeed() {
        return 0L;
    }

    public void setLootTableSeed(long pLootTableSeed) {
    }

    public boolean hasMenu() {
        return this.computed().vehicleContainerType.hasMenu();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, Player pPlayer) {
        if (!pPlayer.isSpectator() && this.hasMenu()) {
            DefaultVehicleData computed = this.computed();
            VehicleContainerType type = computed.vehicleContainerType;
            if (type == null || !type.hasMenu()) {
                return null;
            }
            return new VehicleMenu(ModMenuTypes.VEHICLE_MENU_HUGE.get(), pContainerId, pPlayerInventory, (Container)this, 6, 17, false);
        }
        return null;
    }

    public void stopOpen(@NotNull Player pPlayer) {
        this.level().gameEvent((Holder)GameEvent.CONTAINER_CLOSE, this.position(), GameEvent.Context.of((Entity)pPlayer));
    }

    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        return this.items;
    }

    public void clearItemStacks() {
        this.items.clear();
    }

    private ArrayList<Entity> generatePassengersList() {
        ArrayList<Entity> list = new ArrayList<Entity>(this.getMaxPassengers());
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            list.add(null);
        }
        return list;
    }

    protected void initSeatData(int targetSize) {
        this.padList(this.orderedPassengers, targetSize, null, null);
    }

    protected <T> void padList(@NotNull List<T> list, int targetSize, T defaultValue, @Nullable Consumer<T> onRemove) {
        while (targetSize != list.size()) {
            if (targetSize > list.size()) {
                list.add(defaultValue);
                continue;
            }
            T last = list.removeLast();
            if (last == null || onRemove == null) continue;
            onRemove.accept(last);
        }
    }

    protected void checkSeatsSize() {
        int targetSize = this.computed().seats().size();
        if (targetSize == this.orderedPassengers.size()) {
            return;
        }
        this.initSeatData(targetSize);
    }

    public List<Entity> getOrderedPassengers() {
        this.checkSeatsSize();
        return this.orderedPassengers;
    }

    protected void addPassenger(@NotNull Entity pPassenger) {
        int index;
        if (pPassenger.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        this.checkSeatsSize();
        if (this.entityIndexOverride != null && this.entityIndexOverride.apply(pPassenger) != -1) {
            index = this.entityIndexOverride.apply(pPassenger);
        } else {
            index = 0;
            for (Entity passenger : this.orderedPassengers) {
                if (passenger == null) break;
                ++index;
            }
        }
        if (index >= this.getMaxPassengers() || index < 0) {
            return;
        }
        this.orderedPassengers.set(index, pPassenger);
        pPassenger.getPersistentData().putInt(TAG_SEAT_INDEX, index);
        this.passengers = ImmutableList.copyOf(this.orderedPassengers.stream().filter(Objects::nonNull).toList());
        this.gameEvent((Holder)GameEvent.ENTITY_MOUNT, pPassenger);
    }

    protected void removePassenger(@NotNull Entity pPassenger) {
        if (pPassenger.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.checkSeatsSize();
        int index = this.getSeatIndex(pPassenger);
        if (index == -1) {
            return;
        }
        this.orderedPassengers.set(index, null);
        this.passengers = ImmutableList.copyOf(this.orderedPassengers.stream().filter(Objects::nonNull).toList());
        pPassenger.boardingCooldown = 60;
        this.gameEvent((Holder)GameEvent.ENTITY_DISMOUNT, pPassenger);
    }

    public VehicleData data() {
        return VehicleData.from(this);
    }

    public DefaultVehicleData computed() {
        return VehicleData.compute(this);
    }

    public float maxUpStep() {
        return this.computed().upStep;
    }

    @Nullable
    public Entity getFirstPassenger() {
        this.checkSeatsSize();
        if (this.orderedPassengers.isEmpty()) {
            return null;
        }
        return this.orderedPassengers.getFirst();
    }

    @Nullable
    public Entity getNthEntity(int index) {
        this.checkSeatsSize();
        if (index >= this.orderedPassengers.size() || index < 0) {
            return null;
        }
        return this.orderedPassengers.get(index);
    }

    public boolean changeSeat(Entity entity, int index) {
        if (index < 0 || index >= this.getMaxPassengers()) {
            return false;
        }
        this.checkSeatsSize();
        if (this.orderedPassengers.get(index) != null) {
            return false;
        }
        if (!this.orderedPassengers.contains(entity)) {
            return false;
        }
        this.orderedPassengers.set(this.orderedPassengers.indexOf(entity), null);
        this.orderedPassengers.set(index, entity);
        entity.getPersistentData().putInt(TAG_SEAT_INDEX, index);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getPlayers(s -> true).forEach(p -> p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)this)));
        }
        return true;
    }

    public int getSeatIndex(Entity entity) {
        this.checkSeatsSize();
        return this.orderedPassengers.indexOf(entity);
    }

    public int getTagSeatIndex(Entity entity) {
        return entity.getPersistentData().getInt(TAG_SEAT_INDEX);
    }

    public Vec3 getThirdPersonCameraPosition() {
        Vec3 pos = this.computed().thirdPersonCameraPos;
        if (pos == null) {
            pos = new Vec3(0.0, 1.0, 3.0);
        }
        return new Vec3(pos.z + ClientMouseHandler.custom3pDistanceLerp, pos.y, pos.x);
    }

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    public float getYaw(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.yRotO, (float)this.getYRot());
    }

    public float getPitch(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.xRotO, (float)this.getXRot());
    }

    public void setZRot(float rot) {
        this.roll = rot;
    }

    public void turretTurnSound(float diffX, float diffY, float pitch) {
        if (this instanceof MortarEntity) {
            return;
        }
        if (this.level().isClientSide && ((double)org.joml.Math.abs((float)diffY) > 0.5 || (double)org.joml.Math.abs((float)diffX) > 0.5)) {
            this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), (SoundEvent)ModSounds.TURRET_TURN.get(), this.getSoundSource(), (float)Math.min(0.15 * (double)Math.max(Mth.abs((float)diffX), Mth.abs((float)diffY)), 0.75), this.random.nextFloat() * 0.05f + pitch, false);
        }
    }

    public boolean shouldSendHitParticles() {
        return this.computed().sendHitParticles;
    }

    public boolean shouldSendHitSounds() {
        return true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public EntityDataAccessor<Integer> getEnergyDataAccessor() {
        return ENERGY;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OVERRIDE, (Object)"").define(HEALTH, (Object)Float.valueOf(this.getMaxHealth())).define(LAST_ATTACKER_UUID, (Object)"undefined").define(LAST_DRIVER_UUID, (Object)"undefined").define(GUN_DATA_MAP, new HashMap()).define(AI_TURRET_TARGET_UUID, (Object)"undefined").define(AI_PASSENGER_WEAPON_TARGET_UUID, (Object)"undefined").define(DELTA_ROT, (Object)Float.valueOf(0.0f)).define(MOUSE_SPEED_X, (Object)Float.valueOf(0.0f)).define(MOUSE_SPEED_Y, (Object)Float.valueOf(0.0f)).define(TURRET_HEALTH, (Object)Float.valueOf(this.getTurretMaxHealth())).define(L_WHEEL_HEALTH, (Object)Float.valueOf(this.getWheelMaxHealth())).define(R_WHEEL_HEALTH, (Object)Float.valueOf(this.getWheelMaxHealth())).define(MAIN_ENGINE_HEALTH, (Object)Float.valueOf(this.getEngineMaxHealth())).define(SUB_ENGINE_HEALTH, (Object)Float.valueOf(this.getEngineMaxHealth())).define(TURRET_DAMAGED, (Object)false).define(L_WHEEL_DAMAGED, (Object)false).define(R_WHEEL_DAMAGED, (Object)false).define(MAIN_ENGINE_DAMAGED, (Object)false).define(SUB_ENGINE_DAMAGED, (Object)false).define(CANNON_RECOIL_TIME, (Object)0).define(CANNON_RECOIL_FORCE, (Object)Float.valueOf(0.0f)).define(POWER, (Object)Float.valueOf(0.0f)).define(YAW_WHILE_SHOOT, (Object)Float.valueOf(0.0f)).define(SERVER_YAW, (Object)Float.valueOf(this.getYRot())).define(SERVER_PITCH, (Object)Float.valueOf(this.getXRot())).define(AMMO, (Object)0).define(DECOY_READY, (Object)false).define(GEAR_ROT, (Object)Float.valueOf(0.0f)).define(GEAR_UP, (Object)false).define(FORWARD_INPUT_DOWN, (Object)false).define(BACK_INPUT_DOWN, (Object)false).define(LEFT_INPUT_DOWN, (Object)false).define(RIGHT_INPUT_DOWN, (Object)false).define(UP_INPUT_DOWN, (Object)false).define(DOWN_INPUT_DOWN, (Object)false).define(FIRE_INPUT_DOWN, (Object)false).define(DECOY_INPUT_DOWN, (Object)false).define(SPRINT_INPUT_DOWN, (Object)false).define(PLANE_BREAK, (Object)Float.valueOf(0.0f)).define(SELECTED_WEAPON, (Object)IntList.of((int[])new int[this.getMaxPassengers()])).define(ENERGY, (Object)0).define(PROPELLER_ROT, (Object)Float.valueOf(0.0f)).define(HORN_VOLUME, (Object)Float.valueOf(0.0f)).define(LASER_LENGTH, (Object)Float.valueOf(0.0f)).define(LASER_SCALE, (Object)Float.valueOf(0.0f)).define(LASER_SCALE_O, (Object)Float.valueOf(0.0f)).define(CHARGE_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public void consumeEnergy(int amount) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to consume energy of vehicle {}, but it has no energy storage", (Object)this.getName());
            return;
        }
        if (this.level() instanceof ServerLevel) {
            this.energyStorage.extractEnergy(amount, false);
        }
    }

    protected boolean canConsume(int amount) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to check if can consume energy of vehicle {}, but it has no energy storage", (Object)this.getName());
            return false;
        }
        return this.getEnergy() >= amount;
    }

    public int getEnergy() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get energy of vehicle {}, but it has no energy storage", (Object)this.getName());
            return Integer.MAX_VALUE;
        }
        return this.energyStorage.getEnergyStored();
    }

    @Nullable
    public IEnergyStorage getEnergyStorage() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get energy storage of vehicle {}, but it has no energy storage", (Object)this.getName());
        }
        return this.energyStorage;
    }

    protected void setEnergy(int pEnergy) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to set energy of vehicle {}, but it has no energy storage", (Object)this.getName());
            return;
        }
        int targetEnergy = Mth.clamp((int)pEnergy, (int)0, (int)this.getMaxEnergy());
        if (targetEnergy > this.energyStorage.getEnergyStored()) {
            this.energyStorage.receiveEnergy(targetEnergy - this.energyStorage.getEnergyStored(), false);
        } else {
            this.energyStorage.extractEnergy(this.energyStorage.getEnergyStored() - targetEnergy, false);
        }
    }

    public int getMaxEnergy() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get max energy of vehicle {}, but it has no energy storage", (Object)this.getName());
            return Integer.MAX_VALUE;
        }
        return this.computed().maxEnergy;
    }

    public boolean hasEnergyStorage() {
        return this.computed().maxEnergy > 0;
    }

    public boolean canShoot(LivingEntity living) {
        GunData gunData = this.getGunData(this.getSeatIndex((Entity)living));
        return gunData != null && gunData.canShoot(this.getAmmoSupplier());
    }

    public int vehicleWeaponRpm(LivingEntity living) {
        GunData data = this.getGunData(this.getSeatIndex((Entity)living));
        if (data == null || data.compute().rpm <= 0) {
            return 60;
        }
        return data.compute().rpm;
    }

    public int vehicleWeaponRpm(int seatIndex) {
        GunData data = this.getGunData(seatIndex);
        if (data == null || data.compute().rpm <= 0) {
            return 60;
        }
        return data.compute().rpm;
    }

    public int vehicleWeaponRpm(String weaponName) {
        GunData data = this.getGunData(weaponName);
        if (data == null || data.compute().rpm <= 0) {
            return 1;
        }
        return data.compute().rpm;
    }

    public int getWeaponHeat(LivingEntity living) {
        GunData gunData = this.getGunData(this.getSeatIndex((Entity)living));
        if (gunData == null) {
            return 0;
        }
        return Math.toIntExact(Math.round(gunData.heat.get()));
    }

    public int getWeaponHeat(int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return 0;
        }
        return Math.toIntExact(Math.round(gunData.heat.get()));
    }

    public int getWeaponHeat(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 0;
        }
        return Math.toIntExact(Math.round(gunData.heat.get()));
    }

    public int getWeaponHeat(int seatIndex, int weaponIndex) {
        GunData gunData = this.getGunData(seatIndex, weaponIndex);
        if (gunData == null) {
            return 0;
        }
        return Math.toIntExact(Math.round(gunData.heat.get()));
    }

    public int getShootAnimationTimer(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 0;
        }
        return gunData.shootAnimationTimer.get();
    }

    public int getShootAnimationTimer(int seatIndex, int weaponIndex) {
        GunData gunData = this.getGunData(seatIndex, weaponIndex);
        if (gunData == null) {
            return 0;
        }
        return gunData.shootAnimationTimer.get();
    }

    public void vehicleShoot(LivingEntity living, String weaponName) {
        this.modifyGunData(weaponName, (GunData data) -> {
            if (!data.canShoot(this.getAmmoSupplier())) {
                return;
            }
            data.shoot(new ShootParameters(this.getAmmoSupplier(), (Entity)living, (ServerLevel)this.level(), this.getShootPos(weaponName, 1.0f), this.getShootVec(weaponName, 1.0f), (GunData)data, data.compute().spread, true, null, null));
        });
        GunData gunData = this.getGunData(weaponName);
        this.afterShoot(gunData, this.getShootVec(weaponName, 1.0f));
        this.playShootSound3p(living, weaponName);
    }

    public void vehicleShoot(LivingEntity living, @Nullable UUID uuid, @Nullable Vec3 targetPos) {
        int seatIndex = this.getSeatIndex((Entity)living);
        this.modifyGunData(seatIndex, (GunData data) -> {
            if (!data.canShoot(this.getAmmoSupplier())) {
                return;
            }
            data.shoot(new ShootParameters(this.getAmmoSupplier(), (Entity)living, (ServerLevel)this.level(), this.getShootPos((Entity)living, 1.0f), this.getShootVec((Entity)living, 1.0f), (GunData)data, data.compute().spread, true, uuid, targetPos));
        });
        GunData gunData = this.getGunData(seatIndex);
        this.afterShoot(gunData, this.getShootVec((Entity)living, 1.0f));
        this.playShootSound3p(living, seatIndex);
    }

    public void afterShoot(GunData gunData, Vec3 shootVec) {
        if (gunData != null) {
            DefaultGunData computedGunData = gunData.compute();
            if (computedGunData.recoilTime > 0) {
                if (computedGunData.recoilTime > (Integer)this.entityData.get(CANNON_RECOIL_TIME)) {
                    this.entityData.set(CANNON_RECOIL_TIME, (Object)computedGunData.recoilTime);
                }
                float angle = (float)Mth.wrapDegrees((double)(-VehicleVecUtils.getYRotFromVector(this.getViewVector(1.0f)) + VehicleVecUtils.getYRotFromVector(shootVec)));
                Vec3 vo = new Vec3(0.0, 0.0, 1.0);
                double f = 0.3 * (double)((Float)this.entityData.get(CANNON_RECOIL_FORCE)).floatValue() * (double)((Integer)this.entityData.get(CANNON_RECOIL_TIME) / computedGunData.recoilTime);
                Vec3 v1 = vo.yRot(((Float)this.entityData.get(YAW_WHILE_SHOOT)).floatValue() * ((float)Math.PI / 180)).scale(f);
                Vec3 v2 = vo.yRot(angle * ((float)Math.PI / 180)).scale((double)computedGunData.recoilForce);
                Vec3 v3 = v1.add(v2);
                this.entityData.set(YAW_WHILE_SHOOT, (Object)Float.valueOf((float)Mth.wrapDegrees((double)(-VehicleVecUtils.getYRotFromVector(vo) + VehicleVecUtils.getYRotFromVector(v3)))));
                this.entityData.set(CANNON_RECOIL_FORCE, (Object)Float.valueOf((float)v3.length()));
                gunData.shakePlayers(this);
            }
        }
    }

    public void playShootSound3p(LivingEntity living, String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return;
        }
        Vec3 pos = this.getShootPos(weaponName, 1.0f);
        this.playShootSound3p(living, gunData, pos);
    }

    public void playShootSound3p(LivingEntity living, int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return;
        }
        Vec3 pos = this.getShootPos((Entity)living, 1.0f);
        this.playShootSound3p(living, gunData, pos);
    }

    public void playShootSound3p(LivingEntity living, GunData gunData, Vec3 pos) {
        LivingEntity listener;
        Level level = living.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (gunData == null) {
            return;
        }
        DefaultGunData computedGunData = gunData.compute();
        SoundInfo soundInfo = computedGunData.soundInfo;
        float pitch = this.getWeaponHeat(living) <= 60 ? 1.0f : (float)(1.0 - 0.011 * (double)Math.abs(60 - this.getWeaponHeat(living)));
        Object object = listener = living.getVehicle() == this ? living : null;
        if (soundInfo.fire3P != null) {
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3P, pos, (float)(computedGunData.soundRadius * (double)0.4f), pitch, (Entity)listener);
        }
        if (soundInfo.fire3PFar != null) {
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3PFar, pos, (float)(computedGunData.soundRadius * (double)0.7f), pitch, (Entity)listener);
        }
        if (soundInfo.fire3PVeryFar != null) {
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3PVeryFar, pos, (float)computedGunData.soundRadius, pitch, (Entity)listener);
        }
    }

    public int getWeaponIndex(int seatIndex) {
        List selectedWeapons = (List)this.getEntityData().get(SELECTED_WEAPON);
        if (selectedWeapons.size() <= seatIndex) {
            return -1;
        }
        return (Integer)selectedWeapons.get(seatIndex);
    }

    public boolean hasWeapon() {
        return this.computed().seats().stream().filter(seat -> !seat.weapons().isEmpty()).flatMap(seat -> seat.weapons().stream()).filter(name -> name != null && !name.isEmpty()).anyMatch(name -> this.getGunData((String)name) != null);
    }

    public boolean hasWeapon(int seatIndex) {
        if (seatIndex < 0 || seatIndex >= this.getMaxPassengers()) {
            return false;
        }
        return this.getGunData(seatIndex) != null;
    }

    public void setWeaponIndex(int seatIndex, int selectedWeapon) {
        List selectedWeapons = (List)this.getEntityData().get(SELECTED_WEAPON);
        Integer oldIndex = (Integer)selectedWeapons.get(seatIndex);
        if (oldIndex == selectedWeapon) {
            return;
        }
        this.modifyGunData(seatIndex, oldIndex, gunData -> {
            if (gunData.compute().withdrawAmmoWhenChangeSlot) {
                gunData.withdrawAmmo(this.getAmmoSupplier());
            }
        });
        selectedWeapons.set(seatIndex, selectedWeapon);
        this.getEntityData().set(SELECTED_WEAPON, (Object)selectedWeapons, true);
    }

    public void changeWeapon(int seatIndex, int value, boolean isScroll) {
        if (seatIndex < 0 || seatIndex >= this.getMaxPassengers()) {
            return;
        }
        List<String> weapons = this.computed().seats().get(seatIndex).weapons();
        if (weapons.isEmpty()) {
            return;
        }
        int count = weapons.size();
        int currentIndex = this.getWeaponIndex(seatIndex);
        int typeIndex = Mth.clamp((int)(isScroll ? (value + currentIndex + count) % count : value), (int)0, (int)(count - 1));
        if (typeIndex == currentIndex) {
            return;
        }
        GunData weapon = this.getGunData(weapons.get(typeIndex));
        if (weapon == null) {
            return;
        }
        this.setWeaponIndex(seatIndex, typeIndex);
        SoundEvent sound = weapon.compute().soundInfo.change;
        if (sound != null) {
            this.level().playSound(null, (Entity)this, sound, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        Tag tag;
        int[] selected;
        this.entityData.set(OVERRIDE, (Object)compound.getString("Override"));
        CompoundTag state = compound.getCompound("WeaponState");
        HashMap gunDataMap = new HashMap();
        for (String key : state.getAllKeys()) {
            CompoundTag tag2 = state.getCompound(key);
            tag2 = tag2.copy();
            tag2.putString("id", "superbwarfare:vehicle_gun");
            tag2.putInt("count", 1);
            ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)tag2).ifPresent(is -> gunDataMap.put(key, GunData.from(is)));
        }
        this.entityData.set(GUN_DATA_MAP, gunDataMap, true);
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        } else {
            this.entityData.set(HEALTH, (Object)Float.valueOf(this.getMaxHealth()));
        }
        this.entityData.set(TURRET_HEALTH, (Object)Float.valueOf(compound.getFloat("TurretHealth")));
        this.entityData.set(L_WHEEL_HEALTH, (Object)Float.valueOf(compound.getFloat("LeftWheelHealth")));
        this.entityData.set(R_WHEEL_HEALTH, (Object)Float.valueOf(compound.getFloat("RightWheelHealth")));
        this.entityData.set(MAIN_ENGINE_HEALTH, (Object)Float.valueOf(compound.getFloat("MainEngineHealth")));
        this.entityData.set(SUB_ENGINE_HEALTH, (Object)Float.valueOf(compound.getFloat("SubEngineHealth")));
        this.entityData.set(TURRET_DAMAGED, (Object)compound.getBoolean("TurretDamaged"));
        this.entityData.set(L_WHEEL_DAMAGED, (Object)compound.getBoolean("LeftWheelDamaged"));
        this.entityData.set(R_WHEEL_DAMAGED, (Object)compound.getBoolean("RightWheelDamaged"));
        this.entityData.set(MAIN_ENGINE_DAMAGED, (Object)compound.getBoolean("MainEngineDamaged"));
        this.entityData.set(SUB_ENGINE_DAMAGED, (Object)compound.getBoolean("SubEngineDamaged"));
        this.entityData.set(POWER, (Object)Float.valueOf(compound.getFloat("Power")));
        this.entityData.set(DECOY_READY, (Object)compound.getBoolean("DecoyReady"));
        this.entityData.set(GEAR_ROT, (Object)Float.valueOf(compound.getFloat("GearRot")));
        this.entityData.set(GEAR_UP, (Object)compound.getBoolean("GearUp"));
        this.entityData.set(PROPELLER_ROT, (Object)Float.valueOf(compound.getFloat("PropellerRot")));
        this.entityData.set(CHARGE_PROGRESS, (Object)Float.valueOf(compound.getFloat("ChargeProgress")));
        this.entityData.set(LAST_ATTACKER_UUID, (Object)compound.getString("LastAttacker"));
        this.entityData.set(LAST_DRIVER_UUID, (Object)compound.getString("LastDriver"));
        this.entityData.set(SERVER_YAW, (Object)Float.valueOf(compound.getFloat("ServerYaw")));
        this.entityData.set(SERVER_PITCH, (Object)Float.valueOf(compound.getFloat("ServerPitch")));
        Tag selectedWeaponTag = compound.get("SelectedWeapon");
        if (selectedWeaponTag instanceof IntArrayTag) {
            IntArrayTag arrayTag = (IntArrayTag)selectedWeaponTag;
            selected = arrayTag.getAsIntArray();
        } else {
            selected = new int[this.getMaxPassengers()];
        }
        if (selected.length != this.getMaxPassengers()) {
            this.entityData.set(SELECTED_WEAPON, (Object)IntList.of((int[])new int[this.getMaxPassengers()]));
        } else {
            this.entityData.set(SELECTED_WEAPON, (Object)IntList.of((int[])selected));
        }
        if (this.hasEnergyStorage() && (tag = compound.get("Energy")) instanceof IntTag) {
            IntTag energyNBT = (IntTag)tag;
            ((SyncedEntityEnergyStorage)this.energyStorage).deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), (Tag)energyNBT);
        }
        this.resizeItems();
        ContainerHelper.loadAllItems((CompoundTag)compound, this.getItemStacks(), (HolderLookup.Provider)this.level().registryAccess());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        this.checkSeatsSize();
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        String overrideString = (String)this.entityData.get(OVERRIDE);
        if (!overrideString.isBlank()) {
            compound.putString("Override", overrideString);
        }
        compound.putString("LastAttacker", (String)this.entityData.get(LAST_ATTACKER_UUID));
        compound.putString("LastDriver", (String)this.entityData.get(LAST_DRIVER_UUID));
        Map gunDataMap = (Map)this.entityData.get(GUN_DATA_MAP);
        CompoundTag tag = new CompoundTag();
        for (Map.Entry kv : gunDataMap.entrySet()) {
            GunData data = GunData.from(((GunData)kv.getValue()).stack.copy());
            data.backupAmmoCount.reset();
            data.save();
            Tag stackTag = data.stack.save((HolderLookup.Provider)this.level().registryAccess());
            if (stackTag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)stackTag;
                compoundTag.remove("id");
                compoundTag.remove("count");
                if (compoundTag.isEmpty()) continue;
            }
            tag.put(String.valueOf(kv.getKey()), stackTag);
        }
        if (!tag.isEmpty()) {
            compound.put("WeaponState", (Tag)tag);
        }
        compound.putFloat("TurretHealth", ((Float)this.entityData.get(TURRET_HEALTH)).floatValue());
        compound.putFloat("LeftWheelHealth", ((Float)this.entityData.get(L_WHEEL_HEALTH)).floatValue());
        compound.putFloat("RightWheelHealth", ((Float)this.entityData.get(R_WHEEL_HEALTH)).floatValue());
        compound.putFloat("MainEngineHealth", ((Float)this.entityData.get(MAIN_ENGINE_HEALTH)).floatValue());
        compound.putFloat("SubEngineHealth", ((Float)this.entityData.get(SUB_ENGINE_HEALTH)).floatValue());
        compound.putBoolean("TurretDamaged", ((Boolean)this.entityData.get(TURRET_DAMAGED)).booleanValue());
        compound.putBoolean("LeftWheelDamaged", ((Boolean)this.entityData.get(L_WHEEL_DAMAGED)).booleanValue());
        compound.putBoolean("RightWheelDamaged", ((Boolean)this.entityData.get(R_WHEEL_DAMAGED)).booleanValue());
        compound.putBoolean("MainEngineDamaged", ((Boolean)this.entityData.get(MAIN_ENGINE_DAMAGED)).booleanValue());
        compound.putBoolean("SubEngineDamaged", ((Boolean)this.entityData.get(SUB_ENGINE_DAMAGED)).booleanValue());
        compound.putFloat("Power", ((Float)this.entityData.get(POWER)).floatValue());
        compound.putBoolean("DecoyReady", ((Boolean)this.entityData.get(DECOY_READY)).booleanValue());
        compound.putFloat("GearRot", ((Float)this.entityData.get(GEAR_ROT)).floatValue());
        compound.putBoolean("GearUp", ((Boolean)this.entityData.get(GEAR_UP)).booleanValue());
        compound.putFloat("PropellerRot", ((Float)this.entityData.get(PROPELLER_ROT)).floatValue());
        compound.putFloat("ChargeProgress", ((Float)this.entityData.get(CHARGE_PROGRESS)).floatValue());
        compound.putFloat("ServerYaw", ((Float)this.entityData.get(SERVER_YAW)).floatValue());
        compound.putFloat("ServerPitch", ((Float)this.entityData.get(SERVER_PITCH)).floatValue());
        if (this.getMaxPassengers() > 0) {
            compound.putIntArray("SelectedWeapon", (List)this.entityData.get(SELECTED_WEAPON));
        }
        if (this.hasEnergyStorage()) {
            compound.put("Energy", ((SyncedEntityEnergyStorage)this.energyStorage).serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
        }
        this.resizeItems();
        ContainerHelper.saveAllItems((CompoundTag)compound, this.getItemStacks(), (HolderLookup.Provider)this.level().registryAccess());
    }

    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.getVehicle() == this) {
            return InteractionResult.PASS;
        }
        if (this.hasMenu() && player.isShiftKeyDown() && !player.getMainHandItem().is(ModTags.Items.TOOLS_CROWBAR)) {
            player.openMenu((MenuProvider)this);
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        if (player.getVehicle() == this) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)ModItems.VEHICLE_DAMAGE_ANALYZER.get())) {
            if (!this.level().isClientSide) {
                if (this.damageDebugResultReceiver != null) {
                    this.damageDebugResultReceiver = null;
                    player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.vehicle_damage_analyzer.unbind", (Object[])new Object[]{this.getDisplayName()}), true);
                } else {
                    this.damageDebugResultReceiver = player;
                    player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.vehicle_damage_analyzer.bind", (Object[])new Object[]{this.getDisplayName()}), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && stack.is(ModTags.Items.TOOLS_CROWBAR) && this.getPassengers().isEmpty()) {
            for (ItemStack item : this.getRetrieveItems()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            this.discard();
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown() && this.getMaxPassengers() > 0) {
            List entities = this.getPassengers();
            for (Entity passenger : entities) {
                if (passenger.getTeam() == null || !TDMSavedData.enabledTDM(passenger) && passenger.getTeam() == player.getTeam()) continue;
                return InteractionResult.PASS;
            }
            if (this.getLastDriver() != null && !SeekTool.IN_SAME_TEAM.test((Entity)player, this.getLastDriver()) && this.getLastDriver().getTeam() != null) {
                return InteractionResult.PASS;
            }
            if (this.getFirstPassenger() == null) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                VehicleVecUtils.setDriverAngle(this, player);
                player.setSprinting(false);
                if (player.level() instanceof ServerLevel) {
                    return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
            } else if (!(this.getFirstPassenger() instanceof Player)) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                this.getFirstPassenger().stopRiding();
                VehicleVecUtils.setDriverAngle(this, player);
                player.setSprinting(false);
                if (player.level() instanceof ServerLevel) {
                    return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
            }
            if (this.canAddPassenger((Entity)player)) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                player.setSprinting(false);
                if (player.level() instanceof ServerLevel) {
                    return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public Entity getLastDriver() {
        return EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_DRIVER_UUID));
    }

    @Deprecated(forRemoval=true)
    public void setDriverAngle(Player player) {
        VehicleVecUtils.setDriverAngle(this, player);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Projectile projectile;
        OBBHitter accessor;
        OBB.Part part;
        Entity entity;
        if (source.is(ModTags.DamageTypes.VEHICLE_IMMUNE)) {
            return false;
        }
        if (DamageTypeTool.isGunDamage(source) && source.getEntity() != null && source.getEntity().getVehicle() == this) {
            return false;
        }
        if (source.getEntity() != null && this.getLastDriver() != null && SeekTool.IS_FRIENDLY.test(this.getLastDriver(), source.getEntity()) && this.getLastDriver().getTeam() != null && source.getEntity().getTeam() != null && source.getEntity().getTeam() == this.getLastDriver().getTeam() && !source.getEntity().getTeam().isAllowFriendlyFire() && source.getEntity() == this.getLastDriver() && !source.is(ModDamageTypes.VEHICLE_STRIKE)) {
            return false;
        }
        if (this.damageDebugResultReceiver != null) {
            this.damageDebugResultReceiver.sendSystemMessage((Component)DamageHandler.getDamageInfo(this, source, amount));
        }
        float computedAmount = amount;
        if (!source.is(ModTags.DamageTypes.BYPASSES_VEHICLE)) {
            computedAmount = this.getDamageModifier().compute(source, amount);
        }
        this.crash = source.is(ModDamageTypes.VEHICLE_STRIKE);
        if (source.getEntity() != null) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)source.getEntity().getStringUUID());
        }
        if ((entity = source.getDirectEntity()) instanceof Projectile && (part = (accessor = OBBHitter.getInstance((Entity)(projectile = (Projectile)entity))).sbw$getCurrentHitPart()) != null) {
            switch (part) {
                case TURRET: {
                    this.entityData.set(TURRET_HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(TURRET_HEALTH)).floatValue() - computedAmount));
                    break;
                }
                case WHEEL_LEFT: {
                    this.entityData.set(L_WHEEL_HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(L_WHEEL_HEALTH)).floatValue() - computedAmount));
                    break;
                }
                case WHEEL_RIGHT: {
                    this.entityData.set(R_WHEEL_HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(R_WHEEL_HEALTH)).floatValue() - computedAmount));
                    break;
                }
                case MAIN_ENGINE: {
                    this.entityData.set(MAIN_ENGINE_HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(MAIN_ENGINE_HEALTH)).floatValue() - computedAmount));
                    break;
                }
                case SUB_ENGINE: {
                    this.entityData.set(SUB_ENGINE_HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(SUB_ENGINE_HEALTH)).floatValue() - computedAmount));
                }
            }
        }
        this.onHurt(computedAmount, source.getEntity(), true);
        return super.hurt(source, computedAmount);
    }

    public DamageModifier getDamageModifier() {
        return this.data().damageModifier();
    }

    public float getSourceAngle(DamageSource source, float multiplier) {
        return VehicleVecUtils.getDamageSourceAngle(this, source, multiplier);
    }

    public void heal(float pHealAmount) {
        if (this.level() instanceof ServerLevel) {
            this.setHealth(this.getHealth() + pHealAmount);
        }
    }

    public void onHurt(float pHealAmount, Entity attacker, boolean send) {
        if (this.level() instanceof ServerLevel) {
            Holder holder = Holder.direct((Object)((SoundEvent)ModSounds.INDICATION_VEHICLE.get()));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                if (pHealAmount > 0.0f && this.getHealth() > 0.0f && send && !(this instanceof DroneEntity)) {
                    player.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getEyeY(), player.getZ(), 0.25f + 2.75f * pHealAmount / this.getMaxHealth(), this.random.nextFloat() * 0.1f + 0.9f, player.level().random.nextLong()));
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(3, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (pHealAmount > 0.0f && this.getHealth() > 0.0f && send) {
                this.repairCoolDown = this.maxRepairCoolDown();
                List passengers = this.getPassengers();
                for (Entity entity : passengers) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer player1 = (ServerPlayer)entity;
                    player1.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player1.getX(), player1.getEyeY(), player1.getZ(), 0.25f + 4.75f * pHealAmount / this.getMaxHealth(), this.random.nextFloat() * 0.1f + 0.6f, player1.level().random.nextLong()));
                }
            }
            this.setHealth(this.getHealth() - pHealAmount);
        }
    }

    public float getHealth() {
        return ((Float)this.entityData.get(HEALTH)).floatValue();
    }

    public void setHealth(float pHealth) {
        this.entityData.set(HEALTH, (Object)Float.valueOf(Mth.clamp((float)pHealth, (float)0.0f, (float)this.getMaxHealth())));
    }

    public float getMaxHealth() {
        return this.computed().maxHealth;
    }

    public float getTurretMaxHealth() {
        return 50.0f;
    }

    public float getWheelMaxHealth() {
        return 50.0f;
    }

    public float getEngineMaxHealth() {
        return 50.0f;
    }

    public void lavaHurt() {
        if (this.tickCount % 10 == 0) {
            this.hurt(this.damageSources().lava(), 4.0f);
        }
    }

    @ParametersAreNonnullByDefault
    protected void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound((SoundEvent)ModSounds.WHEEL_VEHICLE_STEP.get(), (float)(this.getDeltaMovement().length() * 0.1), this.random.nextFloat() * 0.15f + 1.05f);
    }

    public boolean canBeCollidedWith() {
        return this.enableAABB();
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean skipAttackInteraction(@NotNull Entity attacker) {
        return this.hasPassenger(attacker) || super.skipAttackInteraction(attacker);
    }

    protected boolean canAddPassenger(@NotNull Entity pPassenger) {
        return this.getPassengers().size() < this.getMaxPassengers();
    }

    public int getMaxPassengers() {
        return this.computed().seats().size();
    }

    public int maxRepairCoolDown() {
        return this.computed().repairCooldown;
    }

    public float repairAmount() {
        return this.computed().repairAmount;
    }

    public void baseTick() {
        List<Vec3> terrainCompat;
        Mob mob;
        Entity entity;
        DefaultVehicleData computed = this.computed();
        if (this.level().isClientSide) {
            if (!this.wasEngineRunning && this.engineRunning()) {
                playEngineSound.accept(this);
                playSwimSound.accept(this);
                if (computed.engineType == EngineType.TRACK) {
                    playTrackSound.accept(this);
                }
            }
            if (!this.wasHornWorking && this.hornWorking()) {
                playHornSound.accept(this);
            }
            if (playFireSound != null && !this.wasFiring && this.isFiring()) {
                playFireSound.accept(this);
            }
            this.wasFiring = this.isFiring();
        }
        if (!this.level().isClientSide) {
            HashMap<String, GunData> newMap = new HashMap<String, GunData>();
            for (Map.Entry kv : ((Map)this.entityData.get(GUN_DATA_MAP)).entrySet()) {
                GunData newData = ((GunData)kv.getValue()).copy();
                newData.tick(this, true);
                newMap.put((String)kv.getKey(), newData);
            }
            this.entityData.set(GUN_DATA_MAP, newMap, true);
        }
        this.wasEngineRunning = this.engineRunning();
        this.wasHornWorking = this.hornWorking();
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        this.gunYRotO = this.getGunYRot();
        this.gunXRotO = this.getGunXRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        this.leftTrackO = this.getLeftTrack();
        this.rightTrackO = this.getRightTrack();
        this.rudderRotO = this.getRudderRot();
        this.propellerRotO = this.getPropellerRot();
        this.recoilShakeO = this.getRecoilShake();
        this.velocityO = this.getVelocity();
        if (this.jumpCoolDown > 0 && this.onGround()) {
            --this.jumpCoolDown;
        }
        this.lastTickSpeed = new Vec3(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.06, this.getDeltaMovement().z).length();
        this.lastTickVerticalSpeed = this.getDeltaMovement().y + 0.06;
        if (this.collisionCoolDown > 0) {
            --this.collisionCoolDown;
        }
        this.entityData.set(LASER_SCALE_O, (Object)((Float)this.entityData.get(LASER_SCALE)));
        this.flap1LRotO = this.getFlap1LRot();
        this.flap1RRotO = this.getFlap1RRot();
        this.flap1L2RotO = this.getFlap1L2Rot();
        this.flap1R2RotO = this.getFlap1R2Rot();
        this.flap2LRotO = this.getFlap2LRot();
        this.flap2RRotO = this.getFlap2RRot();
        this.flap3RotO = this.getFlap3Rot();
        this.gearRotO = this.getGearRot();
        super.baseTick();
        if (((Float)this.entityData.get(LASER_SCALE)).floatValue() > 0.0f) {
            this.entityData.set(LASER_SCALE, (Object)Float.valueOf(org.joml.Math.max((float)(((Float)this.entityData.get(LASER_SCALE)).floatValue() - 0.1f), (float)0.0f)));
            this.entityData.set(LASER_SCALE, (Object)Float.valueOf(((Float)this.entityData.get(LASER_SCALE)).floatValue() * 0.9f));
        }
        if (((Float)this.entityData.get(LASER_SCALE)).floatValue() == 0.0f) {
            this.entityData.set(LASER_LENGTH, (Object)Float.valueOf(0.0f));
        }
        if (this.repairCoolDown > 0) {
            --this.repairCoolDown;
        }
        if (this.getHealth() >= this.getMaxHealth()) {
            this.repairCoolDown = this.maxRepairCoolDown();
        }
        this.prevRoll = this.getRoll();
        float delta = org.joml.Math.abs((float)(this.getYRot() - this.yRotO));
        while (this.getYRot() > 180.0f) {
            this.setYRot(this.getYRot() - 360.0f);
            this.yRotO = this.getYRot() - delta;
        }
        while (this.getYRot() <= -180.0f) {
            this.setYRot(this.getYRot() + 360.0f);
            this.yRotO = delta + this.getYRot();
        }
        float deltaX = org.joml.Math.abs((float)(this.getXRot() - this.xRotO));
        while (this.getXRot() > 180.0f) {
            this.setXRot(this.getXRot() - 360.0f);
            this.xRotO = this.getXRot() - deltaX;
        }
        while (this.getXRot() <= -180.0f) {
            this.setXRot(this.getXRot() + 360.0f);
            this.xRotO = deltaX + this.getXRot();
        }
        float deltaZ = org.joml.Math.abs((float)(this.getRoll() - this.prevRoll));
        while (this.getRoll() > 180.0f) {
            this.setZRot(this.getRoll() - 360.0f);
            this.prevRoll = this.getRoll() - deltaZ;
        }
        while (this.getRoll() <= -180.0f) {
            this.setZRot(this.getRoll() + 360.0f);
            this.prevRoll = deltaZ + this.getRoll();
        }
        this.handleClientSync();
        if (this.level() instanceof ServerLevel && this.getHealth() <= 0.0f) {
            this.destroy();
        }
        this.travel();
        if (this.getHealth() <= computed.selfHurtPercent * this.getMaxHealth()) {
            this.onHurt(computed.selfHurtAmount, this.getLastAttacker(), false);
        } else if (this.repairCoolDown == 0) {
            this.heal(this.repairAmount());
        }
        if (this.getMaxPassengers() > 0 && this.getFirstPassenger() != null) {
            this.entityData.set(LAST_DRIVER_UUID, (Object)this.getFirstPassenger().getStringUUID());
        }
        if (this.getPassengers().isEmpty()) {
            ++this.noPassengerTime;
            if (this.noPassengerTime > 200) {
                this.entityData.set(LAST_DRIVER_UUID, (Object)"undefined");
            }
        } else {
            this.noPassengerTime = 0;
        }
        this.clearArrow();
        this.entityData.set(MOUSE_SPEED_X, (Object)Float.valueOf(this.getMouseMoveSpeedX() * 0.95f));
        this.entityData.set(MOUSE_SPEED_Y, (Object)Float.valueOf(this.getMouseMoveSpeedY() * 0.95f));
        if (this.hasTurret()) {
            if (this.getNthEntity(this.getTurretControllerIndex()) instanceof Player) {
                this.adjustTurretAngle();
            } else {
                entity = this.getNthEntity(this.getTurretControllerIndex());
                if (entity instanceof Mob) {
                    mob = (Mob)entity;
                    this.turretAutoAimFromUuid((String)this.entityData.get(AI_TURRET_TARGET_UUID), (LivingEntity)mob);
                }
            }
        }
        if (this.hasPassengerWeaponStation()) {
            if (this.getNthEntity(this.getPassengerWeaponStationControllerIndex()) instanceof Player || this.getNthEntity(this.getPassengerWeaponStationControllerIndex()) == null) {
                this.adjustWeaponControllerAngle();
            } else {
                entity = this.getNthEntity(this.getPassengerWeaponStationControllerIndex());
                if (entity instanceof Mob) {
                    mob = (Mob)entity;
                    this.passengerWeaponAutoAimFormUuid((String)this.entityData.get(AI_PASSENGER_WEAPON_TARGET_UUID), (LivingEntity)mob);
                }
            }
        }
        for (int i = 0; i < this.data().getDefault().seats().size(); ++i) {
            ItemStack stack;
            GunData gunData;
            Entity rpm2;
            Mob mob2;
            Entity entity2 = this.getNthEntity(i);
            if (entity2 instanceof Mob && this.canShoot((LivingEntity)(mob2 = (Mob)entity2)) && mob2.getTarget() != null && this.getGunData((Entity)mob2) != null && mob2.level() instanceof ServerLevel) {
                mob2.lookAt((Entity)mob2.getTarget(), 30.0f, 30.0f);
                int rpm2 = (int)org.joml.Math.ceil((float)(20.0f / ((float)this.vehicleWeaponRpm((LivingEntity)mob2) / 60.0f)));
                if (this.tickCount % rpm2 == 0 && this.canShoot((LivingEntity)mob2) && VectorTool.calculateAngle(this.getShootDirectionForHud((Entity)mob2, 1.0f), this.getShootPos((Entity)mob2, 1.0f).vectorTo(VectorTool.lerpGetEntityBoundingBoxCenter((Entity)mob2.getTarget(), 1.0f))) < 4.0) {
                    this.vehicleShoot((LivingEntity)mob2, mob2.getTarget().getUUID(), null);
                }
            }
            if (!((rpm2 = this.getNthEntity(i)) instanceof Player)) continue;
            Player player = (Player)rpm2;
            if (!(this.level() instanceof ServerLevel) || (gunData = this.getGunData((Entity)player)) == null) continue;
            if (gunData.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.ENERGY) {
                if (this.canConsume(gunData.compute().ammoCostPerShoot)) continue;
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.not.enough.energy"), true);
                continue;
            }
            if (this.getAmmoCount((LivingEntity)player) >= gunData.compute().ammoCostPerShoot || (stack = gunData.selectedAmmoConsumer().stack()) == ItemStack.EMPTY || InventoryTool.hasCreativeAmmoBox(this) || gunData.reloading()) continue;
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.need.ammo").append((Component)Component.literal((String)"[").append(stack.getHoverName()).append("]").withStyle(ChatFormatting.YELLOW)), true);
        }
        Vec3 currentVelocity = this.getDeltaMovement();
        Vec3 accelerationVec = currentVelocity.subtract(this.previousVelocity).scale(20.0);
        this.acceleration = accelerationVec.length() * 20.0;
        this.previousVelocity = currentVelocity;
        double direct = (90.0 - VehicleVecUtils.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f))) / 90.0;
        this.setVelocity(Mth.lerp((double)0.4, (double)this.getVelocity(), (double)(this.getDeltaMovement().horizontalDistance() * direct * 20.0)));
        float deltaT = Math.abs(this.getTurretYRot() - this.turretYRotO);
        while (this.getTurretYRot() > 180.0f) {
            this.setTurretYRot(this.getTurretYRot() - 360.0f);
            this.turretYRotO = this.getTurretYRot() - deltaT;
        }
        while (this.getTurretYRot() <= -180.0f) {
            this.setTurretYRot(this.getTurretYRot() + 360.0f);
            this.turretYRotO = deltaT + this.getTurretYRot();
        }
        if (this.decoyReloadCoolDown > 0) {
            --this.decoyReloadCoolDown;
        }
        if ((Integer)this.entityData.get(CANNON_RECOIL_TIME) > 0) {
            this.entityData.set(CANNON_RECOIL_TIME, (Object)((Integer)this.entityData.get(CANNON_RECOIL_TIME) - 1));
        }
        this.setRecoilShake((double)Mth.abs((float)((Float)this.entityData.get(CANNON_RECOIL_FORCE)).floatValue()) * 7.0E-7 * Math.pow(((Integer)this.entityData.get(CANNON_RECOIL_TIME)).intValue(), 4.0) * Math.sin(0.6283185307179586 * ((double)((Integer)this.entityData.get(CANNON_RECOIL_TIME)).intValue() - 2.5)));
        this.entityData.set(CANNON_RECOIL_FORCE, (Object)Float.valueOf(((Float)this.entityData.get(CANNON_RECOIL_FORCE)).floatValue() * 0.93f));
        this.preventStacking();
        this.supportEntities();
        this.crushEntities();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -this.computed().gravity, 0.0));
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.collideBlocks();
        this.moveOnDragonTeeth();
        if (this.hasEnergyStorage() && this.tickCount % 20 == 0) {
            for (ItemStack stack : this.getItemStacks()) {
                int stored;
                int neededEnergy = this.getMaxEnergy() - this.getEnergy();
                if (neededEnergy <= 0) break;
                IEnergyStorage energyCap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyCap == null || (stored = energyCap.getEnergyStored()) <= 0) continue;
                int energyToExtract = org.joml.Math.min((int)stored, (int)neededEnergy);
                energyCap.extractEnergy(energyToExtract, false);
                this.setEnergy(this.getEnergy() + energyToExtract);
            }
        }
        if (this.level() instanceof ServerLevel) {
            this.updateBackupAmmoCount();
        }
        this.entityData.set(HORN_VOLUME, (Object)Float.valueOf(((Float)this.entityData.get(HORN_VOLUME)).floatValue() * 0.5f));
        if (this.hasDecoy()) {
            if (this.getVehicleType() == VehicleType.AIRPLANE || this.getVehicleType() == VehicleType.HELICOPTER) {
                this.releaseDecoy();
            } else {
                this.releaseSmokeDecoy(this.getTurretVector(1.0f));
            }
        }
        if ((terrainCompat = this.computed().terrainCompat) != null) {
            this.terrainCompact(terrainCompat);
        }
        this.inertiaRotate(this.computed().inertiaRotateRate);
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(this.getTrackAnimationLength());
        }
        if (this.getLeftTrack() > (float)this.getTrackAnimationLength()) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(this.getTrackAnimationLength());
        }
        if (this.getRightTrack() > (float)this.getTrackAnimationLength()) {
            this.setRightTrack(0.0f);
        }
        this.lowHealthWarning();
        this.refreshDimensions();
        if (!this.enableAABB()) {
            this.handlePartDamaged(this);
            this.handlePartHealth();
            this.updateOBB();
        }
    }

    public void updateOBB() {
        this.getOBB().forEach(obbInfo -> {
            Matrix4d transform = this.getTransformFromString(obbInfo.transform);
            OBB obb = obbInfo.getOBB();
            Vector4d worldPos = this.transformPosition(transform, obbInfo.position.x, obbInfo.position.y, obbInfo.position.z);
            obb.center().set((Vector3dc)OBB.vec3ToVector3d(new Vec3(worldPos.x, worldPos.y, worldPos.z)));
            obb.setRotation(this.getRotationFromString(obbInfo.rotation));
        });
    }

    public SoundEvent getShootSoundInstance() {
        GunData gunData = this.getGunData(0);
        if (gunData != null) {
            SoundEvent instance = gunData.compute().soundInfo.fireSoundInstances;
            if (instance != null) {
                return instance;
            }
        } else {
            return this.getShootSoundInstance("Main");
        }
        return SoundEvents.EMPTY;
    }

    public SoundEvent getShootSoundInstance(String weaponName) {
        SoundEvent instance;
        GunData gunData = this.getGunData(weaponName);
        if (gunData != null && (instance = gunData.compute().soundInfo.fireSoundInstances) != null) {
            return instance;
        }
        return SoundEvents.EMPTY;
    }

    public boolean isFiring() {
        GunData gunData = this.getGunData(0);
        if (gunData != null) {
            SoundEvent instance = gunData.compute().soundInfo.fireSoundInstances;
            if (instance != null) {
                return gunData.shootTimer.get() > 0;
            }
            return false;
        }
        return false;
    }

    public float shootingVolume() {
        GunData gunData = this.getGunData(0);
        if (gunData != null) {
            return (float)gunData.shootTimer.get() * 0.25f;
        }
        return 0.0f;
    }

    public float shootingPitch() {
        GunData gunData = this.getGunData(0);
        if (gunData != null) {
            return (float)((double)(0.98f + (float)gunData.shootTimer.get() * 0.01f) - (gunData.heat.get() > 80.0 ? (gunData.heat.get() - 80.0) * 0.01 : 0.0));
        }
        return 1.0f;
    }

    protected void updateBackupAmmoCount() {
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            this.modifyGunData(i, (GunData data) -> {
                if (data.useBackpackAmmo()) {
                    data.backupAmmoCount.set(data.countBackupAmmo(this.getAmmoSupplier()));
                } else {
                    data.backupAmmoCount.reset();
                }
            });
        }
    }

    public Entity getAmmoSupplier() {
        return this;
    }

    public void handlePartDamaged(OBBEntity obbEntity) {
        List<OBB> obbList = obbEntity.getOBBs();
        for (OBB obb : obbList) {
            Vec3 pos = OBB.vector3dToVec3(obb.center());
            switch (obb.part()) {
                case TURRET: {
                    if (!((Boolean)this.entityData.get(TURRET_DAMAGED)).booleanValue()) break;
                    this.onTurretDamaged(pos);
                    break;
                }
                case WHEEL_LEFT: {
                    if (!((Boolean)this.entityData.get(L_WHEEL_DAMAGED)).booleanValue()) break;
                    this.onLeftWheelDamaged(pos);
                    break;
                }
                case WHEEL_RIGHT: {
                    if (!((Boolean)this.entityData.get(R_WHEEL_DAMAGED)).booleanValue()) break;
                    this.onRightWheelDamaged(pos);
                    break;
                }
                case MAIN_ENGINE: {
                    if (!((Boolean)this.entityData.get(MAIN_ENGINE_DAMAGED)).booleanValue()) break;
                    this.onEngine1Damaged(pos);
                    break;
                }
                case SUB_ENGINE: {
                    if (!((Boolean)this.entityData.get(SUB_ENGINE_DAMAGED)).booleanValue()) break;
                    this.onEngine2Damaged(pos);
                }
            }
        }
    }

    public void handlePartHealth() {
        if (((Float)this.entityData.get(TURRET_HEALTH)).floatValue() < 0.0f) {
            this.entityData.set(TURRET_DAMAGED, (Object)true);
        } else if ((double)((Float)this.entityData.get(TURRET_HEALTH)).floatValue() > 0.95 * (double)this.getTurretMaxHealth()) {
            this.entityData.set(TURRET_DAMAGED, (Object)false);
        }
        if (((Float)this.entityData.get(L_WHEEL_HEALTH)).floatValue() < 0.0f) {
            this.entityData.set(L_WHEEL_DAMAGED, (Object)true);
        } else if ((double)((Float)this.entityData.get(L_WHEEL_HEALTH)).floatValue() > 0.95 * (double)this.getWheelMaxHealth()) {
            this.entityData.set(L_WHEEL_DAMAGED, (Object)false);
        }
        if (((Float)this.entityData.get(R_WHEEL_HEALTH)).floatValue() < 0.0f) {
            this.entityData.set(R_WHEEL_DAMAGED, (Object)true);
        } else if ((double)((Float)this.entityData.get(R_WHEEL_HEALTH)).floatValue() > 0.95 * (double)this.getWheelMaxHealth()) {
            this.entityData.set(R_WHEEL_DAMAGED, (Object)false);
        }
        if (((Float)this.entityData.get(MAIN_ENGINE_HEALTH)).floatValue() < 0.0f) {
            this.entityData.set(MAIN_ENGINE_DAMAGED, (Object)true);
        } else if ((double)((Float)this.entityData.get(MAIN_ENGINE_HEALTH)).floatValue() > 0.95 * (double)this.getEngineMaxHealth()) {
            this.entityData.set(MAIN_ENGINE_DAMAGED, (Object)false);
        }
        if (((Float)this.entityData.get(SUB_ENGINE_HEALTH)).floatValue() < 0.0f) {
            this.entityData.set(SUB_ENGINE_DAMAGED, (Object)true);
        } else if ((double)((Float)this.entityData.get(SUB_ENGINE_HEALTH)).floatValue() > 0.95 * (double)this.getEngineMaxHealth()) {
            this.entityData.set(SUB_ENGINE_DAMAGED, (Object)false);
        }
        this.entityData.set(TURRET_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.entityData.get(TURRET_HEALTH)).floatValue() + 0.0025f * this.getTurretMaxHealth()), (float)this.getTurretMaxHealth())));
        this.entityData.set(L_WHEEL_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.entityData.get(L_WHEEL_HEALTH)).floatValue() + 0.0025f * this.getWheelMaxHealth()), (float)this.getWheelMaxHealth())));
        this.entityData.set(R_WHEEL_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.entityData.get(R_WHEEL_HEALTH)).floatValue() + 0.0025f * this.getWheelMaxHealth()), (float)this.getWheelMaxHealth())));
        this.entityData.set(MAIN_ENGINE_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.entityData.get(MAIN_ENGINE_HEALTH)).floatValue() + 0.0025f * this.getEngineMaxHealth()), (float)this.getEngineMaxHealth())));
        this.entityData.set(SUB_ENGINE_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.entityData.get(SUB_ENGINE_HEALTH)).floatValue() + 0.0025f * this.getEngineMaxHealth()), (float)this.getEngineMaxHealth())));
    }

    public void addRandomParticle(ParticleOptions particleOptions, Vec3 pos, float randomPos, Level level, float speed, int count) {
        float randomX = 2.0f * (this.random.nextFloat() - 0.5f);
        float randomY = 2.0f * (this.random.nextFloat() - 0.5f);
        float randomZ = 2.0f * (this.random.nextFloat() - 0.5f);
        for (double i = 0.0; i < (double)count; i += 1.0) {
            level.addAlwaysVisibleParticle(particleOptions, true, pos.x + (double)(randomPos * randomX), pos.y + (double)(randomPos * randomY), pos.z + (double)(randomPos * randomZ), (double)(randomX * speed), (double)(randomY * speed), (double)(randomZ * speed));
        }
    }

    public void defaultPartDamageEffect(Vec3 pos) {
        if (this.level().isClientSide) {
            this.addRandomParticle((ParticleOptions)ModParticleTypes.FIRE_STAR.get(), pos, 0.0f, this.level(), 0.25f, 5);
            this.addRandomParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos, 0.5f, this.level(), 0.001f, 1);
        }
    }

    public void onTurretDamaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void onLeftWheelDamaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void onRightWheelDamaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void onEngine1Damaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void onEngine2Damaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void clearArrow() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.0, 0.5, 0.0), e -> e instanceof AbstractArrow);
        list.forEach(Entity::discard);
    }

    public void lowHealthWarning() {
        if (!this.data().compute().hasLowHealthWarning) {
            return;
        }
        if ((double)this.getHealth() <= 0.4 * (double)this.getMaxHealth()) {
            this.addRandomParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, new Vec3(this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ()), 0.35f * this.getBbWidth(), this.level(), 0.01f, 1);
        }
        if ((double)this.getHealth() <= 0.25 * (double)this.getMaxHealth()) {
            this.playLowHealthParticle();
        }
        if ((double)this.getHealth() <= 0.15 * (double)this.getMaxHealth()) {
            this.playLowHealthParticle();
        }
        if ((double)this.getHealth() <= 0.1 * (double)this.getMaxHealth()) {
            if (this.level().isClientSide) {
                float random = 2.0f * (this.random.nextFloat() - 0.5f);
                this.addRandomParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, new Vec3(this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ()), 0.35f * this.getBbWidth(), this.level(), 0.01f, 2);
                this.addRandomParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, new Vec3(this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ()), 0.35f * this.getBbWidth(), this.level(), 0.01f, 2);
                this.addRandomParticle(new CustomCloudOption(1.0f, 0.1f, 0.0f, (int)(240.0f + 40.0f * random), 2.5f + 0.5f * random, -0.07f, true, true), new Vec3(this.getX(), this.getY() + (double)(0.85f * this.getBbHeight()), this.getZ()), 0.35f * this.getBbWidth(), this.level(), 0.01f, 1);
                this.addRandomParticle(new CustomCloudOption(1.0f, 0.35f, 0.0f, (int)(80.0f + 40.0f * random), 1.5f + 0.5f * random, -0.07f, false, true), new Vec3(this.getX(), this.getY() + (double)(0.85f * this.getBbHeight()), this.getZ()), 0.3f * this.getBbWidth(), this.level(), 0.01f, 1);
            }
            if (this.tickCount % 15 == 0) {
                this.level().playSound(null, this.getOnPos(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (this.getHealth() < 0.1f * this.getMaxHealth() && this.tickCount % 13 == 0) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.NO_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (this.getHealth() >= 0.1f && this.getHealth() < 0.4f * this.getMaxHealth() && this.tickCount % 10 == 0) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.LOW_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void playLowHealthParticle() {
        if (this.level().isClientSide) {
            this.addRandomParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, new Vec3(this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ()), 0.35f * this.getBbWidth(), this.level(), 0.01f, 1);
            this.addRandomParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, new Vec3(this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ()), 0.35f * this.getBbWidth(), this.level(), 0.01f, 1);
        }
    }

    public void adjustTurretAngle() {
        VehicleWeaponUtils.adjustTurretAngle(this);
    }

    public int getSelectedWeapon(int seatIndex) {
        List selectedWeapon = (List)this.entityData.get(SELECTED_WEAPON);
        if (seatIndex < 0 || seatIndex >= selectedWeapon.size()) {
            return -1;
        }
        return (Integer)selectedWeapon.get(seatIndex);
    }

    public void turretAutoAimFromVector(Vec3 shootVec) {
        VehicleWeaponUtils.turretAutoAimFromVector(this, shootVec);
    }

    public void turretAutoAimFromUuid(String uuid, LivingEntity pLiving) {
        VehicleWeaponUtils.turretAutoAimFromUuid(this, uuid, pLiving);
    }

    public void passengerPitch(Entity entity, float minPitch, float maxPitch, float passengerRot) {
        VehicleVecUtils.setPassengerPitch(this, entity, minPitch, maxPitch, passengerRot);
    }

    public void passengerYaw(Entity entity, float minYaw, float maxYaw, float passengerRot) {
        VehicleVecUtils.setPassengerYaw(this, entity, minYaw, maxYaw, passengerRot);
    }

    public void passengerPitchOnTurret(Entity entity, float turretMinPitch, float turretMaxPitch) {
        VehicleVecUtils.setPassengerPitchOnTurret(this, entity, turretMinPitch, turretMaxPitch);
    }

    public void passengerYawOnTurret(Entity entity, float minYaw, float maxYaw, float passengerRot, boolean rotateWithTurret) {
        VehicleVecUtils.setPassengerYawOnTurret(this, entity, minYaw, maxYaw, passengerRot, rotateWithTurret);
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    protected void clampRotation(Entity entity) {
        int index = this.getSeatIndex(entity);
        List<SeatInfo> seats = this.computed().seats();
        if (index < 0 || index >= seats.size()) {
            return;
        }
        SeatInfo seat = seats.get(index);
        if (seat.transform.equals("Vehicle") || seat.transform.equals("VehicleFlat") || seat.transform.equals("Turret") && seat.canRotateBody.booleanValue()) {
            if (!seat.canRotateBody.booleanValue()) {
                this.passengerYaw(entity, seat.minYaw, seat.maxYaw, seat.orientation);
            }
            if (this.hasTurret() && index == this.getTurretControllerIndex()) {
                if (seat.transform.equals("Vehicle") || seat.transform.equals("VehicleFlat")) {
                    float diffY = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
                    this.passengerPitch(entity, seat.minPitch, seat.maxPitch, diffY);
                } else {
                    this.passengerPitchOnTurret(entity, seat.minPitch, seat.maxPitch);
                    this.passengerYawOnTurret(entity, seat.minYaw, seat.maxYaw, seat.orientation, true);
                }
            } else {
                float diffY = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
                this.passengerPitch(entity, seat.minPitch, seat.maxPitch, diffY);
            }
        }
        if (seat.transform.equals("Turret") && !seat.canRotateBody.booleanValue()) {
            this.passengerPitchOnTurret(entity, seat.minPitch, seat.maxPitch);
            this.passengerYawOnTurret(entity, seat.minYaw, seat.maxYaw, seat.orientation, false);
        }
    }

    public void copyEntityData(Entity entity) {
        entity.setYRot(entity.getYRot() + this.destroyRot);
        int index = this.getSeatIndex(entity);
        SeatInfo seat = this.computed().seats().get(index);
        if (seat.transform.equals("Vehicle") || seat.transform.equals("VehicleFlat")) {
            if (!seat.canRotateBody.booleanValue()) {
                entity.setYBodyRot(this.getYRot() + seat.orientation);
            }
            if (!seat.canRotateHead.booleanValue()) {
                entity.setYRot(this.getYRot() + seat.orientation);
            }
        }
        if (seat.transform.equals("Turret") && !seat.canRotateBody.booleanValue()) {
            entity.setYBodyRot(this.getBarrelYRot(1.0f) + seat.orientation);
        }
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        int index = this.getSeatIndex(passenger);
        List<SeatInfo> seats = this.computed().seats();
        if (index < 0 || index >= seats.size()) {
            return;
        }
        SeatInfo seat = seats.get(index);
        this.passengerPos(passenger, callback, seat.position, seat.transform);
    }

    public void passengerPos(Entity passenger, @NotNull Entity.MoveFunction callback, Vec3 vec3, String string) {
        Vector4d worldPosition = this.transformPosition(this.getTransformFromString(string), vec3.x, vec3.y, vec3.z);
        passenger.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
        callback.accept(passenger, worldPosition.x, worldPosition.y, worldPosition.z);
        this.copyEntityData(passenger);
    }

    protected void registerTransforms() {
        this.positionTransform.put("VehicleFlat", this::getVehicleFlatTransform);
        this.positionTransform.put("Turret", this::getTurretTransform);
        this.positionTransform.put("Barrel", this::getBarrelTransform);
        this.positionTransform.put("WeaponStation", this::getGunTransform);
        this.positionTransform.put("WeaponStationBarrel", this::getPassengerWeaponStationBarrelTransform);
        this.positionTransform.put("Default", this::getVehicleTransform);
        this.vectorTransform.put("Turret", this::getTurretVector);
        this.vectorTransform.put("Barrel", this::getBarrelVector);
        this.vectorTransform.put("WeaponStationBarrel", this::getPassengerWeaponStationVector);
        this.vectorTransform.put("DeltaMovement", tick -> this.getDeltaMovement().normalize());
        this.vectorTransform.put("Up", this::getUpVec);
        this.vectorTransform.put("Default", arg_0 -> ((VehicleEntity)this).getViewVector(arg_0));
        this.rotationTransform.put("Turret", tick -> VectorTool.combineRotationsTurret(tick.floatValue(), this));
        this.rotationTransform.put("Barrel", tick -> VectorTool.combineRotationsBarrel(tick.floatValue(), this));
        this.rotationTransform.put("RotationsYaw", tick -> VectorTool.combineRotationsYaw(tick.floatValue(), this));
        this.rotationTransform.put("Default", tick -> VectorTool.combineRotations(tick.floatValue(), this));
    }

    @NotNull
    public Matrix4d getTransformFromString(String string) {
        return this.getTransformFromString(string, 1.0f);
    }

    @NotNull
    public Matrix4d getTransformFromString(String string, float ticks) {
        return this.positionTransform.getOrDefault(string, this.positionTransform.get("Default")).apply(Float.valueOf(ticks));
    }

    @NotNull
    public Vec3 getVectorFromString(String string) {
        return this.getVectorFromString(string, 0.0f);
    }

    @NotNull
    public Vec3 getVectorFromString(String string, float ticks) {
        return this.vectorTransform.getOrDefault(string, this.vectorTransform.get("Default")).apply(Float.valueOf(ticks));
    }

    @NotNull
    public Vec3 getVectorFromString(String string, float ticks, int seatIndex) {
        Entity entity = this.getNthEntity(seatIndex);
        return switch (string) {
            case "Bomb" -> this.bombHitPos(this.getNthEntity(seatIndex)).subtract(this.getShootPosForHud(this.getNthEntity(seatIndex), 1.0f));
            case "Passenger" -> {
                if (entity != null) {
                    yield entity.getViewVector(ticks);
                }
                yield this.getViewVector(ticks);
            }
            default -> this.getVectorFromString(string, ticks);
        };
    }

    @NotNull
    public Quaterniond getRotationFromString(String string) {
        return this.getRotationFromString(string, 0.0f);
    }

    @NotNull
    public Quaterniond getRotationFromString(String string, float ticks) {
        return this.rotationTransform.getOrDefault(string, this.rotationTransform.get("Default")).apply(Float.valueOf(ticks));
    }

    public Vec3 getShootPos(int seatIndex, float ticks) {
        return this.getShootPos(this.getNthEntity(seatIndex), ticks);
    }

    public Vec3 bombHitPos(Entity entity) {
        GunData gunData = this.getGunData(entity);
        if (gunData != null) {
            return ProjectileCalculator.calculatePreciseImpactPoint(this.level(), this.getShootPosForHud(entity, 1.0f), this.getShootVec(entity, 1.0f), this.getDeltaMovement().length() * gunData.compute().velocity, -this.getProjectileGravity(entity));
        }
        return Vec3.ZERO;
    }

    public Vec3 getShootPos(Entity entity, float ticks) {
        GunData data = this.getGunData(this.getSeatIndex(entity));
        if (data != null) {
            Vec3 vec3 = data.firePosition();
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, ticks), vec3.x, vec3.y, vec3.z);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return this.getEyePosition(ticks);
    }

    public Vec3 getShootPos(String weaponName, float ticks) {
        GunData data = this.getGunData(weaponName);
        if (data != null) {
            Vec3 vec3 = data.firePosition();
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, ticks), vec3.x, vec3.y, vec3.z);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return this.getEyePosition(ticks);
    }

    public Vec3 getShootPosForHud(Entity entity, float ticks) {
        GunData data = this.getGunData(this.getSeatIndex(entity));
        if (data != null) {
            Vec3 vec3 = data.firePositionForHud();
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, ticks), vec3.x, vec3.y, vec3.z);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return this.getEyePosition(ticks);
    }

    public Vec3 getShootDirectionForHud(Entity entity, float partialTicks) {
        GunData data = this.getGunData(this.getSeatIndex(entity));
        if (data == null) {
            return this.getViewVector(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.fireDirectionForHud();
        if (stringOrVec3 == null) {
            return this.getViewVec(entity, partialTicks);
        }
        if (stringOrVec3.isString()) {
            return this.getVectorFromString(stringOrVec3.string, partialTicks, this.getSeatIndex(entity));
        }
        Vec3 vec3 = stringOrVec3.vec3;
        Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x + stringOrVec3.vec3.x, vec3.y + stringOrVec3.vec3.y, vec3.z + stringOrVec3.vec3.z);
        Vector4d worldPositionO = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x, vec3.y, vec3.z);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.vectorTo(endPos).normalize();
    }

    public Vec3 getShootVec(int seatIndex, float ticks) {
        return this.getShootVec(this.getNthEntity(seatIndex), ticks);
    }

    public Vec3 getShootVec(Entity entity, float partialTicks) {
        return VehicleVecUtils.getShootVec(this, entity, partialTicks);
    }

    public Vec3 getShootVec(String weaponName, float partialTicks) {
        return VehicleVecUtils.getShootVec(this, weaponName, partialTicks);
    }

    public Vec3 getViewVec(Entity entity, float partialTicks) {
        return VehicleVecUtils.getViewVec(this, entity, partialTicks);
    }

    public Vec3 getViewPos(Entity entity, float partialTicks) {
        return VehicleVecUtils.getViewPos(this, entity, partialTicks);
    }

    public Vec3 getSeekVec(Entity entity, float partialTicks) {
        return VehicleVecUtils.getSeekVec(this, entity, partialTicks);
    }

    public Vec3 getSeekVec(int seatIndex, float partialTicks) {
        return VehicleVecUtils.getSeekVec(this, this.getNthEntity(seatIndex), partialTicks);
    }

    public Entity getPlayerLookAtEntityOnVehicle(Entity shooter, double entityReach, float partialTick) {
        AABB aabb;
        Vec3 eye = this.getShootPosForHud(shooter, partialTick);
        double distance = entityReach * entityReach;
        HitResult hitResult = TraceTool.pickNew(eye, 512.0, this);
        Vec3 viewVec = this.getViewVec(shooter, partialTick);
        Vec3 toVec = eye.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)this, (Vec3)eye, (Vec3)toVec, (AABB)(aabb = this.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0)), p -> !p.isSpectator() && p.isAlive() && SeekTool.BASIC_FILTER.test((Entity)p) && !p.getType().is(ModTags.EntityTypes.DECOY) && SeekTool.NOT_IN_SMOKE.test((Entity)p) && p != shooter && !(p instanceof Projectile), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY && entityhitresult != null) {
            return entityhitresult.getEntity();
        }
        return null;
    }

    public float getProjectileVelocity(Entity entity) {
        GunData gunData = this.getGunData(this.getSeatIndex(entity));
        if (gunData == null) {
            return 25.0f;
        }
        if (gunData.compute().addShooterDeltaMovement) {
            return (float)(this.getDeltaMovement().length() * gunData.compute().velocity);
        }
        return (float)gunData.compute().velocity;
    }

    public float getProjectileVelocity(int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return 25.0f;
        }
        if (gunData.compute().addShooterDeltaMovement) {
            return (float)(this.getDeltaMovement().length() * gunData.compute().velocity);
        }
        return (float)gunData.compute().velocity;
    }

    public float getProjectileVelocity(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 25.0f;
        }
        if (gunData.compute().addShooterDeltaMovement) {
            return (float)(this.getDeltaMovement().length() * gunData.compute().velocity);
        }
        return (float)gunData.compute().velocity;
    }

    public float getProjectileVelocity(GunData gunData) {
        if (gunData == null) {
            return 25.0f;
        }
        if (gunData.compute().addShooterDeltaMovement) {
            return (float)(this.getDeltaMovement().length() * gunData.compute().velocity);
        }
        return (float)gunData.compute().velocity;
    }

    public float getProjectileGravity(Entity entity) {
        GunData gunData = this.getGunData(this.getSeatIndex(entity));
        if (gunData == null) {
            return 0.0f;
        }
        return (float)gunData.compute().gravity;
    }

    public float getProjectileGravity(int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return 0.0f;
        }
        return (float)gunData.compute().gravity;
    }

    public float getProjectileGravity(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 0.0f;
        }
        return (float)gunData.compute().gravity;
    }

    public float getProjectileGravity(GunData gunData) {
        if (gunData == null) {
            return 0.0f;
        }
        return (float)gunData.compute().gravity;
    }

    public float getProjectileSpread(Entity entity) {
        GunData gunData = this.getGunData(this.getSeatIndex(entity));
        if (gunData == null) {
            return 0.5f;
        }
        return (float)gunData.compute().spread;
    }

    public float getProjectileSpread(int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return 0.5f;
        }
        return (float)gunData.compute().spread;
    }

    public float getProjectileSpread(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 0.5f;
        }
        return (float)gunData.compute().spread;
    }

    public float getProjectileSpread(GunData gunData) {
        if (gunData == null) {
            return 0.5f;
        }
        return (float)gunData.compute().spread;
    }

    public void passengerWeaponAutoAimFormUuid(String uuid, LivingEntity pLiving) {
        Entity target = EntityFindUtil.findEntity(this.level(), uuid);
        if (target != null) {
            if (target.getVehicle() != null) {
                target = target.getVehicle();
            }
            Vec3 targetPos = target.getBoundingBox().getCenter();
            Vec3 targetVel = target.getDeltaMovement();
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                double gravity = living.getAttributeValue(Attributes.GRAVITY);
                targetVel = targetVel.add(0.0, gravity, 0.0);
            }
            if (target instanceof Player) {
                targetVel = targetVel.multiply(2.0, 1.0, 2.0);
            }
            Vec3 targetVec = RangeTool.calculateFiringSolution(this.getShootPos((Entity)pLiving, 1.0f).subtract(this.getShootVec((Entity)pLiving, 1.0f).scale(this.getShootPos((Entity)pLiving, 1.0f).distanceTo(pLiving.position()))), targetPos, targetVel, this.getProjectileVelocity((Entity)pLiving), this.getProjectileGravity((Entity)pLiving));
            this.passengerWeaponAutoAimFormVector(targetVec);
        }
    }

    public void passengerWeaponAutoAimFormVector(Vec3 shootVec) {
        float ySpeed = this.getPassengerWeaponYSpeed();
        float xSpeed = this.getPassengerWeaponXSpeed();
        float diffY = (float)Mth.wrapDegrees((double)(-VehicleVecUtils.getYRotFromVector(shootVec) + VehicleVecUtils.getYRotFromVector(this.getPassengerWeaponStationVector(1.0f))));
        float diffX = (float)Mth.wrapDegrees((double)(-VehicleVecUtils.getXRotFromVector(shootVec) + VehicleVecUtils.getXRotFromVector(this.getPassengerWeaponStationVector(1.0f))));
        this.turretTurnSound(diffX, diffY, 0.95f);
        this.setGunXRot(Mth.clamp((float)(this.getGunXRot() + Mth.clamp((float)(0.5f * diffX), (float)(-xSpeed), (float)xSpeed)), (float)(-this.getPassengerWeaponMaxPitch()), (float)(-this.getPassengerWeaponMinPitch())));
        this.setGunYRot(Mth.clamp((float)(this.getGunYRot() - Mth.clamp((float)(0.5f * diffY), (float)(-ySpeed), (float)ySpeed)), (float)(-this.getPassengerWeaponMaxYaw()), (float)(-this.getPassengerWeaponMinYaw())));
    }

    public void adjustWeaponControllerAngle() {
        float ySpeed = this.getPassengerWeaponYSpeed();
        float xSpeed = this.getPassengerWeaponXSpeed();
        Entity entity = this.getNthEntity(this.getPassengerWeaponStationControllerIndex());
        float diffY = 0.0f;
        float diffX = 0.0f;
        float speed = 1.0f;
        if (entity instanceof Player) {
            float gunAngle = -Mth.wrapDegrees((float)(entity.getYHeadRot() - this.getYRot()));
            diffY = Mth.wrapDegrees((float)(gunAngle - this.getGunYRot()));
            diffX = Mth.wrapDegrees((float)(entity.getXRot() - this.getGunXRot()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            speed = 0.0f;
        }
        this.setGunXRot(this.getGunXRot() + Mth.clamp((float)(0.95f * diffX), (float)(-xSpeed), (float)xSpeed));
        this.setGunYRot(this.getGunYRot() + Mth.clamp((float)(0.9f * diffY), (float)(-ySpeed), (float)ySpeed) + speed * this.turretYRotLock);
    }

    public void destroy() {
        float radius;
        DestroyInfo destroyInfo = this.computed().destroyInfo;
        if (destroyInfo.explodePassengers) {
            if (this.crash && destroyInfo.crashPassengers) {
                this.crashPassengers();
            } else {
                this.explodePassengers();
            }
        }
        if ((radius = destroyInfo.explosionRadius) > 0.0f) {
            float damage = destroyInfo.explosionDamage;
            ParticleTool.ParticleType particleType = destroyInfo.particleType;
            CustomExplosion.Builder explosion = this.createCustomExplosion().radius(radius).damage(damage).withParticleType(particleType);
            if (!destroyInfo.explodeBlocks) {
                explosion.keepBlock();
            }
            explosion.explode();
        }
        this.discard();
    }

    public CustomExplosion.Builder createCustomExplosion() {
        return new CustomExplosion.Builder(this).attacker(this.getLastAttacker());
    }

    protected void crashPassengers() {
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            for (int i = 0; i < (Integer)VehicleConfig.AIR_CRASH_EXPLOSION_COUNT.get(); ++i) {
                Entity tempAttacker = living == this.getLastAttacker() ? null : this.getLastAttacker();
                living.invulnerableTime = 0;
                living.hurt(ModDamageTypes.causeAirCrashDamage(this.level().registryAccess(), null, tempAttacker), (float)((Integer)VehicleConfig.AIR_CRASH_EXPLOSION_DAMAGE.get()).intValue());
            }
        }
    }

    protected void explodePassengers() {
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            for (int i = 0; i < (Integer)VehicleConfig.SELF_EXPLOSION_COUNT.get(); ++i) {
                Entity tempAttacker = living == this.getLastAttacker() ? null : this.getLastAttacker();
                living.invulnerableTime = 0;
                living.hurt(ModDamageTypes.causeVehicleExplosionDamage(this.level().registryAccess(), null, tempAttacker), (float)((Integer)VehicleConfig.SELF_EXPLOSION_DAMAGE.get()).intValue());
            }
        }
    }

    public void travel() {
        DefaultVehicleData computed = this.computed();
        EngineType engineType = computed.engineType;
        if (engineType == EngineType.EMPTY) {
            return;
        }
        if (engineType == EngineType.FIXED) {
            this.fixedEngine();
            return;
        }
        if (this.engineCache == null) {
            JsonObject engineInfo = computed.engineInfo;
            try {
                this.engineCache = switch (engineType) {
                    case EngineType.WHEEL -> (EngineInfo.Wheel)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Wheel.class);
                    case EngineType.TRACK -> (EngineInfo.Track)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Track.class);
                    case EngineType.HELICOPTER -> (EngineInfo.Helicopter)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Helicopter.class);
                    case EngineType.SHIP -> (EngineInfo.Ship)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Ship.class);
                    case EngineType.AIRCRAFT -> (EngineInfo.Aircraft)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Aircraft.class);
                    case EngineType.WHEELCHAIR -> (EngineInfo.WheelChair)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.WheelChair.class);
                    case EngineType.TOM6 -> (EngineInfo.Tom6)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Tom6.class);
                    default -> null;
                };
            }
            catch (Exception e) {
                Mod.LOGGER.error("Failed to parse engine info for vehicle {}, {}", (Object)this, (Object)e);
            }
        } else {
            this.engineCache.work(this);
        }
    }

    @Nullable
    public EngineInfo getEngineInfo() {
        return this.engineCache;
    }

    public float getEngineSoundVolume() {
        DefaultVehicleData computed = this.computed();
        EngineType engineType = computed.engineType;
        if (engineType == EngineType.EMPTY || engineType == EngineType.FIXED) {
            return 0.0f;
        }
        EngineInfo engineInfo = this.getEngineInfo();
        if (engineInfo == null) {
            return 0.0f;
        }
        return switch (engineType) {
            case EngineType.TRACK -> org.joml.Math.max((float)Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()), (float)Mth.abs((float)(1.4f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()))) * engineInfo.engineSoundVolume;
            case EngineType.HELICOPTER -> ((Float)this.entityData.get(PROPELLER_ROT)).floatValue() * engineInfo.engineSoundVolume;
            default -> Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()) * engineInfo.engineSoundVolume;
        };
    }

    public Matrix4d getVehicleTransform(float ticks) {
        Matrix4d transformV = this.getVehicleYOffsetTransform(ticks);
        Matrix4d transform = new Matrix4d();
        Vector4d worldPosition = this.transformPosition(transform, 0.0, -this.getRotateOffsetHeight(), 0.0);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        return transformV;
    }

    public Matrix4d getVehicleYOffsetTransform(float partialTicks) {
        return VehicleVecUtils.getVehicleYOffsetTransform(this, partialTicks);
    }

    public double getRotateOffsetHeight() {
        return this.computed().rotateOffsetHeight;
    }

    public Matrix4d getVehicleFlatTransform(float partialTicks) {
        return VehicleVecUtils.getVehicleFlatTransform(this, partialTicks);
    }

    public Matrix4d getClientVehicleTransform(float partialTicks) {
        return VehicleVecUtils.getClientVehicleTransform(this, partialTicks);
    }

    public boolean hasTurret() {
        return this.getTurretPos() != null;
    }

    public Vec3 getTurretPos() {
        return this.computed().turretPos;
    }

    public int getTurretControllerIndex() {
        return this.computed().turretControllerIndex;
    }

    public float getTurretTurnXSpeed() {
        return this.computed().turretTurnSpeed.x;
    }

    public float getTurretTurnYSpeed() {
        return this.computed().turretTurnSpeed.y;
    }

    public float getTurretMinYaw() {
        return this.computed().turretYawRange.x;
    }

    public float getTurretMaxYaw() {
        return this.computed().turretYawRange.y;
    }

    public float getTurretMinPitch() {
        return this.computed().turretPitchRange.x;
    }

    public float getTurretMaxPitch() {
        return this.computed().turretPitchRange.y;
    }

    public Vec3 getBarrelPosition() {
        return this.computed().barrelPos;
    }

    public boolean hasPassengerWeaponStation() {
        return this.getPassengerWeaponStationPosition() != null;
    }

    public Vec3 getPassengerWeaponStationPosition() {
        return this.computed().passengerWeaponStationPos;
    }

    public Vec3 getPassengerWeaponStationBarrelPosition() {
        return this.computed().passengerWeaponStationBarrelPos;
    }

    public int getPassengerWeaponStationControllerIndex() {
        return this.computed().passengerWeaponStationControllerIndex;
    }

    public float getPassengerWeaponYSpeed() {
        return this.computed().passengerWeaponStationTurnSpeed.y;
    }

    public float getPassengerWeaponXSpeed() {
        return this.computed().passengerWeaponStationTurnSpeed.x;
    }

    public float getPassengerWeaponMinPitch() {
        return this.computed().passengerWeaponStationPitchRange.x;
    }

    public float getPassengerWeaponMaxPitch() {
        return this.computed().passengerWeaponStationPitchRange.y;
    }

    public float getPassengerWeaponMinYaw() {
        return this.computed().passengerWeaponStationYawRange.x;
    }

    public float getPassengerWeaponMaxYaw() {
        return this.computed().passengerWeaponStationYawRange.y;
    }

    public Matrix4d getTurretTransform(float partialTicks) {
        return VehicleVecUtils.getTurretTransform(this, partialTicks);
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        return VehicleVecUtils.getTurretVector(this, pPartialTicks);
    }

    public Matrix4d getBarrelTransform(float partialTicks) {
        return VehicleVecUtils.getBarrelTransform(this, partialTicks);
    }

    public Matrix4d getGunTransform(float partialTicks) {
        return VehicleVecUtils.getGunTransform(this, partialTicks);
    }

    public Matrix4d getPassengerWeaponStationBarrelTransform(float partialTicks) {
        return VehicleVecUtils.getPassengerWeaponStationBarrelTransform(this, partialTicks);
    }

    public Vec3 getPassengerWeaponStationVector(float partialTicks) {
        return VehicleVecUtils.getPassengerWeaponStationVector(this, partialTicks);
    }

    public Vector4d transformPosition(Matrix4d transform, double x, double y, double z) {
        return transform.transform(new Vector4d(x, y, z, 1.0));
    }

    public void handleClientSync() {
        if (this.level() instanceof ServerLevel && this.tickCount % 2 == 0) {
            this.entityData.set(SERVER_YAW, (Object)Float.valueOf(this.getYRot()));
            this.entityData.set(SERVER_PITCH, (Object)Float.valueOf(this.getXRot()));
        }
        if (this.isControlledByLocalInstance()) {
            this.interpolationSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.getX() + (this.xO - this.getX()) / (double)this.interpolationSteps;
        double interpolatedY = this.getY() + (this.yO - this.getY()) / (double)this.interpolationSteps;
        double interpolatedZ = this.getZ() + (this.zO - this.getZ()) / (double)this.interpolationSteps;
        float diffY = Mth.wrapDegrees((float)(((Float)this.entityData.get(SERVER_YAW)).floatValue() - this.getYRot()));
        float diffX = Mth.wrapDegrees((float)(((Float)this.entityData.get(SERVER_PITCH)).floatValue() - this.getXRot()));
        this.setYRot(this.getYRot() + 0.1f * diffY);
        this.setXRot(this.getXRot() + 0.1f * diffX);
        this.setPos(interpolatedX, interpolatedY, interpolatedZ);
        --this.interpolationSteps;
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.xO = x;
        this.yO = y;
        this.zO = z;
        this.interpolationSteps = 10;
    }

    @Deprecated(forRemoval=true, since="0.8.9")
    protected Vec3 getDismountOffset(double vehicleWidth, double passengerWidth) {
        return VehicleMiscUtils.getDismountOffset(this, vehicleWidth, passengerWidth);
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity passenger) {
        int index = this.getTagSeatIndex((Entity)passenger);
        if (index < 0) {
            return super.getDismountLocationForPassenger(passenger);
        }
        return this.getDismountLocationForIndex(passenger, index);
    }

    @NotNull
    public Vec3 getDismountLocationForIndex(LivingEntity passenger, int index) {
        DismountInfo dismountInfo = this.computed().seats().get((int)index).dismountInfo;
        if (dismountInfo != null) {
            Vec3 vec3 = dismountInfo.position;
            if (vec3 != null) {
                Vector4d worldPosition = this.transformPosition(this.getTransformFromString(dismountInfo.transform), vec3.x, vec3.y, vec3.z);
                return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
            }
            return this.dismount(passenger);
        }
        return this.dismount(passenger);
    }

    @NotNull
    public Vec3 dismount(LivingEntity passenger) {
        Vec3 vec3d = VehicleMiscUtils.getDismountOffset(this, this.getBbWidth() * Mth.SQRT_OF_TWO, passenger.getBbWidth() * Mth.SQRT_OF_TWO);
        double ox = this.getX() - vec3d.x;
        double oz = this.getZ() + vec3d.z;
        BlockPos exitPos = new BlockPos((int)ox, (int)this.getY(), (int)oz);
        BlockPos floorPos = exitPos.below();
        if (!this.level().isWaterAt(floorPos)) {
            double floorHeight;
            ArrayList list = Lists.newArrayList();
            double exitHeight = this.level().getBlockFloorHeight(exitPos);
            if (DismountHelper.isBlockFloorValid((double)exitHeight)) {
                list.add(new Vec3(ox, (double)exitPos.getY() + exitHeight, oz));
            }
            if (DismountHelper.isBlockFloorValid((double)(floorHeight = this.level().getBlockFloorHeight(floorPos)))) {
                list.add(new Vec3(ox, (double)floorPos.getY() + floorHeight, oz));
            }
            for (Pose entityPose : passenger.getDismountPoses()) {
                for (Vec3 vec3d2 : list) {
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                    passenger.setPose(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    @NotNull
    public Vec3 getEjectionPosition(LivingEntity passenger, int index) {
        DismountInfo dismountInfo = this.computed().seats().get((int)index).dismountInfo;
        if (dismountInfo != null) {
            Vec3 vec3 = dismountInfo.ejectPosition;
            if (vec3 == null) {
                return passenger.position();
            }
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(dismountInfo.transform), vec3.x, vec3.y, vec3.z);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return passenger.position();
    }

    public boolean allowEjection(int seatIndex) {
        DismountInfo dismountInfo = this.computed().seats().get((int)seatIndex).dismountInfo;
        if (dismountInfo != null) {
            return this.computed().seats().get((int)seatIndex).dismountInfo.canEject;
        }
        return false;
    }

    public void removeSeatIndexTag(Entity entity) {
        entity.getPersistentData().remove(TAG_SEAT_INDEX);
    }

    @NotNull
    public Vec3 getEjectionMovement(LivingEntity entity, int index) {
        DismountInfo dismountInfo = this.computed().seats().get((int)index).dismountInfo;
        if (dismountInfo == null) {
            return this.getDeltaMovement();
        }
        double force = dismountInfo.ejectForce;
        StringOrVec3 stringOrVec3 = dismountInfo.ejectDirection;
        if (stringOrVec3 == null) {
            return this.getDeltaMovement().add(this.getUpVec(1.0f).scale(force));
        }
        if (stringOrVec3.isString()) {
            return this.getDeltaMovement().add(this.getVectorFromString(stringOrVec3.string, 1.0f, this.getSeatIndex((Entity)entity)).scale(force));
        }
        Vec3 vec3 = stringOrVec3.vec3;
        Vector4d worldPosition = this.transformPosition(this.getTransformFromString(dismountInfo.transform), vec3.x + stringOrVec3.vec3.x, vec3.y + stringOrVec3.vec3.y, vec3.z + stringOrVec3.vec3.z);
        Vector4d worldPositionO = this.transformPosition(this.getTransformFromString(dismountInfo.transform), vec3.x, vec3.y, vec3.z);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return this.getDeltaMovement().add(startPos.vectorTo(endPos).normalize().scale(force));
    }

    public ResourceLocation getVehicleIcon() {
        return this.computed().vehicleIcon;
    }

    public boolean allowFreeCam() {
        return this.computed().allowFreeCam;
    }

    public Vec3 getUpVec(float ticks) {
        Matrix4d transform = this.getVehicleTransform(ticks);
        Vector4d force0 = this.transformPosition(transform, 0.0, 0.0, 0.0);
        Vector4d force1 = this.transformPosition(transform, 0.0, 1.0, 0.0);
        return new Vec3(force0.x, force0.y, force0.z).vectorTo(new Vec3(force1.x, force1.y, force1.z));
    }

    public void push(double pX, double pY, double pZ) {
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4d transform = this.getBarrelTransform(pPartialTicks);
        Vector4d rootPosition = this.transformPosition(transform, 0.0, 0.0, 0.0);
        Vector4d targetPosition = this.transformPosition(transform, 0.0, 0.0, 1.0);
        return new Vec3(rootPosition.x, rootPosition.y, rootPosition.z).vectorTo(new Vec3(targetPosition.x, targetPosition.y, targetPosition.z));
    }

    public float getBarrelXRot(float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)(this.turretXRotO - this.xRotO), (float)(this.getTurretXRot() - this.getXRot()));
    }

    public float getBarrelYRot(float pPartialTick) {
        return -Mth.lerp((float)pPartialTick, (float)(this.turretYRotO - this.yRotO), (float)(this.getTurretYRot() - this.getYRot()));
    }

    public float getGunXRot(float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)(this.gunXRotO - this.xRotO), (float)(this.getGunXRot() - this.getXRot()));
    }

    public float getGunYRot(float pPartialTick) {
        return -Mth.lerp((float)pPartialTick, (float)(this.gunYRotO - this.yRotO), (float)(this.getGunYRot() - this.getYRot()));
    }

    public float getTurretYRot() {
        return this.turretYRot;
    }

    public float getTurretYaw(float pPartialTick) {
        return Mth.lerp((float)pPartialTick, (float)this.turretYRotO, (float)this.getTurretYRot());
    }

    public void setTurretYRot(float pTurretYRot) {
        this.turretYRot = pTurretYRot;
    }

    public float getTurretXRot() {
        return this.turretXRot;
    }

    public void setTurretXRot(float pTurretXRot) {
        this.turretXRot = pTurretXRot;
    }

    public float getTurretPitch(float pPartialTick) {
        return Mth.lerp((float)pPartialTick, (float)this.turretXRotO, (float)this.getTurretXRot());
    }

    public float getGunYRot() {
        return this.gunYRot;
    }

    public void setGunYRot(float pGunYRot) {
        this.gunYRot = pGunYRot;
    }

    public float getGunXRot() {
        return this.gunXRot;
    }

    public void setGunXRot(float pGunXRot) {
        this.gunXRot = pGunXRot;
    }

    public Vec3 getCameraPos(Entity entity, float partialTicks) {
        return VehicleVecUtils.getCameraPos(this, entity, partialTicks);
    }

    public Vec3 cameraDirection(Entity entity, float partialTicks) {
        return VehicleVecUtils.getCameraDirection(this, entity, partialTicks);
    }

    public Vec3 getZoomPos(Entity entity, float partialTicks) {
        return VehicleVecUtils.getZoomPos(this, entity, partialTicks);
    }

    public Vec3 getZoomDirection(Entity entity, float partialTicks) {
        return VehicleVecUtils.getZoomDirection(this, entity, partialTicks);
    }

    public double getMouseSensitivity() {
        return 0.1;
    }

    public Vec2 getMouseSpeed() {
        return VehicleResource.compute((VehicleEntity)this).mouseSpeed;
    }

    public float gearRot(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.gearRotO, (float)this.getGearRot());
    }

    public float getMass() {
        return this.computed().mass;
    }

    public void setDeltaMovement(Vec3 pDeltaMovement) {
        Vec3 acceleration;
        Vec3 currentMomentum = this.getDeltaMovement();
        double currentSpeedSq = currentMomentum.lengthSqr();
        double newSpeedSq = pDeltaMovement.lengthSqr();
        if (newSpeedSq > currentSpeedSq && (acceleration = pDeltaMovement.subtract(currentMomentum)).lengthSqr() > 8.0) {
            Vec3 limitedAcceleration = acceleration.normalize().scale(0.125);
            Vec3 finalMomentum = currentMomentum.add(limitedAcceleration);
            super.setDeltaMovement(finalMomentum);
            return;
        }
        super.setDeltaMovement(pDeltaMovement);
    }

    public void addDeltaMovement(Vec3 pAddend) {
        double length = pAddend.length();
        if (length > 0.1) {
            pAddend = pAddend.scale(0.1 / length);
        }
        super.addDeltaMovement(pAddend);
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        SeatInfo seat = this.computed().seats().get(seatIndex);
        Vec3 sensitivity = seat.sensitivity;
        return zoom ? sensitivity.x * original : (Minecraft.getInstance().options.getCameraType().isFirstPerson() ? sensitivity.y * original : sensitivity.z * original);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return this.computed().containerIcon;
    }

    public boolean isEnclosed(int index) {
        List<SeatInfo> seats = this.computed().seats();
        if (index < 0 || index >= seats.size()) {
            return false;
        }
        SeatInfo seat = seats.get(index);
        if (seat.isEnclosed == null) {
            return seat.hidePassenger;
        }
        return seat.isEnclosed;
    }

    public boolean isEnclosed(Entity passenger) {
        return this.isEnclosed(this.getSeatIndex(passenger));
    }

    public boolean banHand(LivingEntity entity) {
        int index = this.getSeatIndex((Entity)entity);
        if (index == -1) {
            return false;
        }
        GunData gunData = this.getGunData(index);
        List<SeatInfo> seats = this.computed().seats();
        if (index >= seats.size()) {
            return false;
        }
        SeatInfo seat = seats.get(index);
        return gunData != null || seat.banHand != false;
    }

    public boolean hidePassenger(int index) {
        List<SeatInfo> seats = this.computed().seats();
        if (index < 0 || index >= seats.size()) {
            return false;
        }
        SeatInfo seat = seats.get(index);
        return seat.hidePassenger;
    }

    public boolean hidePassenger(Entity passenger) {
        return this.hidePassenger(this.getSeatIndex(passenger));
    }

    public int getAmmoCount(LivingEntity living) {
        GunData data = this.getGunData(this.getSeatIndex((Entity)living));
        if (data == null) {
            return 0;
        }
        return this.getAmmo(data);
    }

    public int getAmmoCount(int seatIndex) {
        GunData data = this.getGunData(seatIndex);
        if (data == null) {
            return 0;
        }
        return this.getAmmo(data);
    }

    public int getAmmoCount(String weaponName) {
        GunData data = this.getGunData(weaponName);
        if (data == null) {
            return 0;
        }
        return this.getAmmo(data);
    }

    public int getAmmo(GunData data) {
        return data.useBackpackAmmo() ? data.backupAmmoCount.get() : data.ammo.get();
    }

    @Nullable
    public ItemStack getPickResult() {
        if (!this.getRetrieveItems().isEmpty()) {
            return this.getRetrieveItems().getFirst();
        }
        return ContainerBlockItem.createInstance(this.getType());
    }

    public boolean useAircraftCamera(int seatIndex) {
        SeatInfo seat = this.computed().seats().get(seatIndex);
        if (seat != null) {
            CameraPos data = seat.cameraPos;
            return data.aircraftCamera;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        int index = this.getSeatIndex((Entity)player);
        SeatInfo seat = this.computed().seats().get(index);
        GunData gunData = this.getGunData((Entity)player);
        if (seat != null) {
            CameraPos data = seat.cameraPos;
            if (data != null) {
                if (zoom && gunData != null && gunData.compute().shootPos.viewDirection != null) {
                    return new Vec2((float)(-VehicleVecUtils.getYRotFromVector(this.getViewVec((Entity)player, partialTicks))), (float)(-VehicleVecUtils.getXRotFromVector(this.getViewVec((Entity)player, partialTicks))));
                }
                if (this.useAircraftCamera(index)) {
                    return new Vec2((float)((double)this.getYaw(partialTicks) - ClientMouseHandler.freeCameraYaw), (float)((double)this.getPitch(partialTicks) + ClientMouseHandler.freeCameraPitch));
                }
                if (zoom || isFirstPerson) {
                    return new Vec2((float)(-VehicleVecUtils.getYRotFromVector(this.cameraDirection((Entity)player, partialTicks))), (float)(-VehicleVecUtils.getXRotFromVector(this.cameraDirection((Entity)player, partialTicks))));
                }
            } else {
                return null;
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        int index = this.getSeatIndex((Entity)player);
        SeatInfo seat = this.computed().seats().get(index);
        if (seat != null) {
            CameraPos data = seat.cameraPos;
            GunData gunData = this.getGunData((Entity)player);
            if (data != null) {
                if (zoom || isFirstPerson) {
                    if (zoom) {
                        if (gunData != null && gunData.compute().shootPos.viewPosition != null) {
                            return this.getViewPos((Entity)player, partialTicks);
                        }
                        return this.getZoomPos((Entity)player, partialTicks);
                    }
                    return this.getCameraPos((Entity)player, partialTicks);
                }
                if (this.useAircraftCamera(index)) {
                    Matrix4d transform = this.getClientVehicleTransform(partialTicks);
                    Vector4d maxCameraPosition = this.transformPosition(transform, data.aircraftCameraPos.x, data.aircraftCameraPos.y + 0.1 * ClientMouseHandler.custom3pDistanceLerp, data.aircraftCameraPos.z - ClientMouseHandler.custom3pDistanceLerp);
                    return CameraTool.getMaxZoom(transform, maxCameraPosition);
                }
            }
            return null;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        CameraPos data;
        int index = this.getSeatIndex(entity);
        SeatInfo seat = this.computed().seats().get(index);
        if (seat != null && (data = seat.cameraPos) != null) {
            return data.useFixedCameraPos;
        }
        return false;
    }

    public double getDefaultZoom(Entity entity) {
        GunData gunData = this.getGunData(this.getSeatIndex(entity));
        if (gunData != null) {
            return gunData.compute().defaultZoom;
        }
        return 1.0;
    }

    public boolean canCrushEntities() {
        return true;
    }

    public void fixedEngine() {
        this.move(MoverType.SELF, new Vec3(0.0, this.getDeltaMovement().y, 0.0));
        if (this.onGround()) {
            this.setDeltaMovement(Vec3.ZERO);
        } else {
            this.setDeltaMovement(new Vec3(0.0, this.getDeltaMovement().y, 0.0));
        }
    }

    public void releaseSmokeDecoy(Vec3 vec3) {
        VehicleWeaponUtils.releaseSmokeDecoy(this, vec3);
    }

    public void releaseDecoy() {
        VehicleWeaponUtils.releaseDecoy(this);
    }

    public void inertiaRotate(float multiplier) {
        this.setXRot(this.getXRot() - 0.5f * (float)(this.getAcceleration() * (double)multiplier));
    }

    public void terrainCompact(List<Vec3> positions) {
        VehicleMotionUtils.terrainCompact(this, positions);
    }

    public Matrix4d getWheelsTransform(float partialTicks) {
        return VehicleMotionUtils.getWheelsTransform(this, partialTicks);
    }

    public void moveOnDragonTeeth() {
        VehicleMotionUtils.handleVehicleMoveOnDragonTeeth(this);
    }

    public void collideBlocks() {
        VehicleMotionUtils.collideBlocks(this);
    }

    public Entity getLastAttacker() {
        return EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_ATTACKER_UUID));
    }

    public void move(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        if (!this.level().isClientSide()) {
            ignoreEntityGroundCheckStepping = true;
        }
        super.move(movementType, movement);
        if (this.lastTickSpeed < 0.3 || this.collisionCoolDown > 0 || this instanceof DroneEntity) {
            return;
        }
        Entity driver = this.getLastDriver();
        if (this.verticalCollision) {
            if (this.getVehicleType() == VehicleType.AIRPLANE && ((double)((Float)this.entityData.get(GEAR_ROT)).floatValue() > 0.15 && !(this instanceof Tom6Entity) || Mth.abs((float)this.getRoll()) > 20.0f || Mth.abs((float)this.getXRot()) > 30.0f)) {
                this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)((double)(8.0f + Mth.abs((float)(this.getRoll() * 0.2f))) * (this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3)));
                if (!this.level().isClientSide) {
                    this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
                }
                this.bounceVertical(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
            } else if (this.getVehicleType() == VehicleType.HELICOPTER) {
                this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)(60.0 * ((this.lastTickSpeed - 0.5) * (this.lastTickSpeed - 0.5))));
                this.bounceVertical(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
            } else if ((double)Mth.abs((float)((float)this.lastTickVerticalSpeed)) > 0.4) {
                this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)(96.0 * (((double)Mth.abs((float)((float)this.lastTickVerticalSpeed)) - 0.4) * (this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3))));
                if (!this.level().isClientSide) {
                    this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
                }
                this.bounceVertical(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
            }
        }
        if (this.horizontalCollision) {
            this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)(126.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
            this.bounceHorizontal(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
            if (!this.level().isClientSide) {
                this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
            }
            this.collisionCoolDown = 4;
            this.crash = true;
            this.entityData.set(POWER, (Object)Float.valueOf(0.8f * ((Float)this.entityData.get(POWER)).floatValue()));
        }
    }

    public void bounceHorizontal(Direction direction) {
        VehicleMotionUtils.bounceHorizontal(this, direction);
    }

    public void bounceVertical(Direction direction) {
        VehicleMotionUtils.bounceVertical(this, direction);
    }

    public void preventStacking() {
        VehicleMotionUtils.preventStacking(this);
    }

    public void pushNew(double pX, double pY, double pZ) {
        this.setDeltaMovement(this.getDeltaMovement().add(pX, pY, pZ));
    }

    public void supportEntities() {
        VehicleMotionUtils.supportEntities(this);
    }

    @NotNull
    public RandomSource getRandom() {
        return this.random;
    }

    public void crushEntities() {
        VehicleMotionUtils.crushEntities(this);
    }

    public Vector3f getForwardDirection() {
        return new Vector3f(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))), 0.0f, Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))).normalize();
    }

    public Vector3f getRightDirection() {
        return new Vector3f(Mth.cos((float)(-this.getYRot() * ((float)Math.PI / 180))), 0.0f, Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)))).normalize();
    }

    public SoundEvent getEngineSound() {
        return this.computed().engineSound;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double pV) {
        this.velocity = pV;
    }

    public double getAcceleration() {
        return this.getVelocity() - this.velocityO;
    }

    public float getRudderRot() {
        return this.rudderRot;
    }

    public void setRudderRot(float pRudderRot) {
        this.rudderRot = pRudderRot;
    }

    public float getLeftWheelRot() {
        return this.leftWheelRot;
    }

    public void setLeftWheelRot(float pLeftWheelRot) {
        this.leftWheelRot = pLeftWheelRot;
    }

    public float getRightWheelRot() {
        return this.rightWheelRot;
    }

    public void setRightWheelRot(float pRightWheelRot) {
        this.rightWheelRot = pRightWheelRot;
    }

    public int getTrackAnimationLength() {
        return 100;
    }

    public float getLeftTrack() {
        return this.leftTrack;
    }

    public void setLeftTrack(float pLeftTrack) {
        this.leftTrack = pLeftTrack;
    }

    public float getRightTrack() {
        return this.rightTrack;
    }

    public void setRightTrack(float pRightTrack) {
        this.rightTrack = pRightTrack;
    }

    public float getPropellerRot() {
        return this.propellerRot;
    }

    public void setPropellerRot(float pPropellerRot) {
        this.propellerRot = pPropellerRot;
    }

    public double getRecoilShake() {
        return this.recoilShake;
    }

    public void setRecoilShake(double pRecoilShake) {
        this.recoilShake = pRecoilShake;
    }

    public float getFlap1LRot() {
        return this.flap1LRot;
    }

    public void setFlap1L2Rot(float pFlap1L2Rot) {
        this.flap1L2Rot = pFlap1L2Rot;
    }

    public float getFlap1R2Rot() {
        return this.flap1R2Rot;
    }

    public void setFlap1R2Rot(float pFlap1R2Rot) {
        this.flap1R2Rot = pFlap1R2Rot;
    }

    public float getFlap1L2Rot() {
        return this.flap1L2Rot;
    }

    public void setFlap1LRot(float pFlap1LRot) {
        this.flap1LRot = pFlap1LRot;
    }

    public float getFlap1RRot() {
        return this.flap1RRot;
    }

    public void setFlap1RRot(float pFlap1RRot) {
        this.flap1RRot = pFlap1RRot;
    }

    public float getFlap2LRot() {
        return this.flap2LRot;
    }

    public void setFlap2LRot(float pFlap2LRot) {
        this.flap2LRot = pFlap2LRot;
    }

    public float getFlap2RRot() {
        return this.flap2RRot;
    }

    public void setFlap2RRot(float pFlap2RRot) {
        this.flap2RRot = pFlap2RRot;
    }

    public float getFlap3Rot() {
        return this.flap3Rot;
    }

    public void setFlap3Rot(float pFlap3Rot) {
        this.flap3Rot = pFlap3Rot;
    }

    public float getGearRot() {
        return this.gearRot;
    }

    public void setGearRot(float pGearRot) {
        this.gearRot = pGearRot;
    }

    public boolean hasDecoy() {
        return this.computed().hasDecoy;
    }

    public boolean engineRunning() {
        return org.joml.Math.abs((float)((Float)this.entityData.get(POWER)).floatValue()) > 0.0f;
    }

    @NotNull
    public List<ItemStack> getRetrieveItems() {
        return List.of(ContainerBlockItem.createInstance(this));
    }

    public int getHudColor() {
        return this.computed().hudColor.get();
    }

    public float getPower() {
        return ((Float)this.entityData.get(POWER)).floatValue();
    }

    public String getDecoyState() {
        return (Boolean)this.entityData.get(DECOY_READY) != false ? "READY" : "RELOADING";
    }

    @NotNull
    public SoundEvent getHornSound() {
        return this.computed().hornSound;
    }

    public void horn() {
        this.entityData.set(HORN_VOLUME, (Object)Float.valueOf(((Float)this.entityData.get(HORN_VOLUME)).floatValue() + 0.7f));
    }

    public boolean hornWorking() {
        return (double)org.joml.Math.abs((float)((Float)this.entityData.get(HORN_VOLUME)).floatValue()) > 0.05;
    }

    public VehicleType getVehicleType() {
        return this.computed().type;
    }

    public void support(Entity entity) {
        VehicleMotionUtils.support(this, entity);
    }

    public boolean isAmphibious() {
        return VehicleMiscUtils.isAmphibious(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component firstPersonAmmoComponent(GunData data, Player player) {
        String name = data.compute().name;
        if (name == null || name.isBlank()) {
            return Component.empty();
        }
        int ammoCount = this.getAmmoCount((LivingEntity)player);
        return Component.translatable((String)name, (Object[])new Object[]{ammoCount == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(ammoCount)});
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component thirdPersonAmmoComponent(GunData data, Player player) {
        return this.firstPersonAmmoComponent(data, player);
    }

    @Override
    public List<OBB> getOBBs() {
        if (this.obbCache == null) {
            this.obbCache = this.getOBB().stream().filter(Objects::nonNull).map(OBBInfo::getOBB).toList();
        }
        return this.obbCache;
    }
}

