/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.client.MouseMovementHandler;
import com.atsuishio.superbwarfare.config.client.ControlConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleType;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.Tom6Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.send.MouseMoveMessage;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientMouseHandler {
    public static Vec2 posO = new Vec2(0.0f, 0.0f);
    public static Vec2 posN = new Vec2(0.0f, 0.0f);
    public static double lerpSpeedX = 0.0;
    public static double lerpSpeedY = 0.0;
    public static double speedX = 0.0;
    public static double speedY = 0.0;
    public static double freeCameraPitch = 0.0;
    public static double freeCameraYaw = 0.0;
    public static double custom3pDistance = 0.0;
    public static double custom3pDistanceLerp = 0.0;

    private static boolean notInGame() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return true;
        }
        if (mc.getOverlay() != null) {
            return true;
        }
        if (mc.screen != null) {
            return true;
        }
        if (!mc.mouseHandler.isMouseGrabbed()) {
            return true;
        }
        return !mc.isWindowActive();
    }

    @SubscribeEvent
    public static void handleClientTick(ClientTickEvent.Post event) {
        VehicleEntity vehicle;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (ClientMouseHandler.notInGame()) {
            speedX = 0.0;
            speedY = 0.0;
            lerpSpeedX = 0.0;
            lerpSpeedY = 0.0;
        }
        posO = posN;
        posN = MouseMovementHandler.getMousePos();
        ItemStack stack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            DroneEntity drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
            if (drone != null) {
                if (ClientMouseHandler.notInGame()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MouseMoveMessage(0.0, 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return;
                }
                speedX = drone.getMouseSensitivity() / ClientEventHandler.droneFovLerp * (double)(ClientMouseHandler.posN.x - ClientMouseHandler.posO.x);
                speedY = drone.getMouseSensitivity() / ClientEventHandler.droneFovLerp * (double)(ClientMouseHandler.posN.y - ClientMouseHandler.posO.y);
                Vec2 mouseSpeed = drone.getMouseSpeed();
                lerpSpeedX = Mth.lerp((double)mouseSpeed.x, (double)lerpSpeedX, (double)speedX);
                lerpSpeedY = Mth.lerp((double)mouseSpeed.y, (double)lerpSpeedY, (double)speedY);
                PacketDistributor.sendToServer((CustomPacketPayload)new MouseMoveMessage(lerpSpeedX, lerpSpeedY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return;
        }
        Entity mouseSpeed = player.getVehicle();
        if (mouseSpeed instanceof VehicleEntity && player == (vehicle = (VehicleEntity)mouseSpeed).getFirstPassenger() && (vehicle.getVehicleType() == VehicleType.AIRPLANE || vehicle.getVehicleType() == VehicleType.HELICOPTER)) {
            if (ClientMouseHandler.notInGame()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MouseMoveMessage(0.0, 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            int y = 1;
            if (((Boolean)ControlConfig.INVERT_AIRCRAFT_CONTROL.get()).booleanValue()) {
                y = -1;
            }
            speedX = vehicle.getMouseSensitivity() * (double)(ClientMouseHandler.posN.x - ClientMouseHandler.posO.x);
            speedY = (double)y * vehicle.getMouseSensitivity() * (double)(ClientMouseHandler.posN.y - ClientMouseHandler.posO.y);
            Vec2 mouseSpeed2 = vehicle.getMouseSpeed();
            lerpSpeedX = Mth.lerp((double)mouseSpeed2.x, (double)lerpSpeedX, (double)speedX);
            lerpSpeedY = Mth.lerp((double)mouseSpeed2.y, (double)lerpSpeedY, (double)speedY);
            double i = 0.0;
            if (vehicle.getRoll() < 0.0f) {
                i = 1.0;
            } else if (vehicle.getRoll() > 0.0f) {
                i = -1.0;
            }
            if (Mth.abs((float)vehicle.getRoll()) > 90.0f) {
                i *= (double)(1.0f - (Mth.abs((float)vehicle.getRoll()) - 90.0f) / 90.0f);
            }
            if (!ClientEventHandler.isFreeCam((Player)player)) {
                if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
                    if (!(vehicle instanceof Tom6Entity)) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new MouseMoveMessage((double)(1.0f - Mth.abs((float)vehicle.getRoll()) / 90.0f) * lerpSpeedX + (double)(Mth.abs((float)vehicle.getRoll()) / 90.0f) * lerpSpeedY * i, (double)(1.0f - Mth.abs((float)vehicle.getRoll()) / 90.0f) * lerpSpeedY + (double)(Mth.abs((float)vehicle.getRoll()) / 90.0f) * lerpSpeedX * (double)(vehicle.getRoll() < 0.0f ? -1 : 1)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MouseMoveMessage(lerpSpeedX, lerpSpeedY), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new MouseMoveMessage(0.0, 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void handleClientTick(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (ClientMouseHandler.notInGame()) {
            freeCameraYaw = 0.0;
            freeCameraPitch = 0.0;
            return;
        }
        float times = 0.6f * (float)Math.min((double)Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true), 0.8);
        freeCameraYaw -= (double)(0.4f * times) * lerpSpeedX;
        freeCameraPitch += (double)(0.3f * times) * lerpSpeedY;
        if (!ClientEventHandler.isFreeCam((Player)player)) {
            freeCameraYaw = Mth.lerp((double)(0.6 * (double)times), (double)freeCameraYaw, (double)0.0);
            freeCameraPitch = Mth.lerp((double)(0.6 * (double)times), (double)freeCameraPitch, (double)0.0);
        }
        while (freeCameraYaw > 180.0) {
            freeCameraYaw -= 360.0;
        }
        while (freeCameraYaw <= -180.0) {
            freeCameraYaw += 360.0;
        }
        while (freeCameraPitch > 180.0) {
            freeCameraPitch -= 360.0;
        }
        while (freeCameraPitch <= -180.0) {
            freeCameraPitch += 360.0;
        }
        custom3pDistanceLerp = Mth.lerp((double)times, (double)custom3pDistanceLerp, (double)custom3pDistance);
    }

    @SubscribeEvent
    public static void calculatePlayerTurn(CalculatePlayerTurnEvent event) {
        double raw = event.getMouseSensitivity() * 0.6 + 0.2;
        double newSensitivity = ClientMouseHandler.changeSensitivity(raw) * (double)ClientMouseHandler.invertY();
        event.setMouseSensitivity((newSensitivity - 0.2) / 0.6);
    }

    public static int invertY() {
        VehicleEntity vehicle;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return 1;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity && ((vehicle = (VehicleEntity)entity).getVehicleType() == VehicleType.AIRPLANE || vehicle.getVehicleType() == VehicleType.HELICOPTER) && vehicle.getFirstPassenger() == player) {
            return (Boolean)ControlConfig.INVERT_AIRCRAFT_CONTROL.get() != false ? -1 : 1;
        }
        return 1;
    }

    private static double changeSensitivity(double original) {
        GunData data;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return original;
        }
        if (player.hasEffect(ModMobEffects.SHOCK) && !player.isSpectator()) {
            return 0.0;
        }
        ItemStack stack = mc.player.getMainHandItem();
        if (stack.getItem() instanceof GunItem) {
            data = GunData.from(stack);
            float customSens = data.sensitivity.get();
            if (!player.getMainHandItem().isEmpty() && mc.options.getCameraType() == CameraType.FIRST_PERSON) {
                return original / Math.max(1.0 + 0.2 * (data.zoom() - 0.3 * (double)customSens) * ClientEventHandler.zoomTime, 0.1) * (double)((float)((Integer)ControlConfig.MOUSE_SENSITIVITY.get()).intValue() / 100.0f);
            }
        }
        if (stack.is((Item)ModItems.MONITOR.get()) && NBTTool.getTag(stack).getBoolean("Using") && NBTTool.getTag(stack).getBoolean("Linked")) {
            return 0.0;
        }
        if (ClientEventHandler.isFreeCam((Player)player)) {
            return 0.0;
        }
        if (player.isUsingItem() && player.getUseItem().is((Item)ModItems.ARTILLERY_INDICATOR.get()) && mc.options.getCameraType() == CameraType.FIRST_PERSON) {
            return original / Math.max(1.0 + 0.2 * ClientEventHandler.artilleryIndicatorZoom, 0.1);
        }
        Entity customSens = player.getVehicle();
        if (customSens instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)customSens;
            return vehicle.getSensitivity(original, ClientEventHandler.zoomVehicle, vehicle.getSeatIndex((Entity)player), vehicle.onGround());
        }
        if (stack.getItem() instanceof GunItem) {
            data = GunData.from(stack);
            float customSens2 = data.sensitivity.get();
            if (!player.getMainHandItem().isEmpty() && mc.options.getCameraType() == CameraType.FIRST_PERSON) {
                return original / Math.max(1.0 + 0.2 * (data.zoom() - 0.3 * (double)customSens2) * ClientEventHandler.zoomTime, 0.1);
            }
        }
        return original;
    }
}

