/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.api.event.PreKillEvent;
import com.atsuishio.superbwarfare.capability.laser.LaserCapability;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.config.common.GameplayConfig;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.SoundInfo;
import com.atsuishio.superbwarfare.data.gun.value.ReloadState;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.mixin.ICustomKnockback;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimableEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModAttributes;
import com.atsuishio.superbwarfare.init.ModCapabilities;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.ammo.box.AmmoBoxInfo;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.DrawClientMessage;
import com.atsuishio.superbwarfare.network.message.receive.LivingGunKillMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class LivingEventHandler {
    @SubscribeEvent
    public static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        Mob mob;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (livingEntity = (mob = (Mob)livingEntity).getVehicle()) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)livingEntity;
            if (mob == vehicle.getNthEntity(vehicle.getTurretControllerIndex())) {
                if (event.getNewAboutToBeSetTarget() != null) {
                    vehicle.getEntityData().set(VehicleEntity.AI_TURRET_TARGET_UUID, (Object)event.getNewAboutToBeSetTarget().getStringUUID());
                } else {
                    vehicle.getEntityData().set(VehicleEntity.AI_TURRET_TARGET_UUID, (Object)"undefined");
                }
            }
            if (mob == vehicle.getNthEntity(vehicle.getPassengerWeaponStationControllerIndex())) {
                if (event.getNewAboutToBeSetTarget() != null) {
                    vehicle.getEntityData().set(VehicleEntity.AI_PASSENGER_WEAPON_TARGET_UUID, (Object)event.getNewAboutToBeSetTarget().getStringUUID());
                } else {
                    vehicle.getEntityData().set(VehicleEntity.AI_PASSENGER_WEAPON_TARGET_UUID, (Object)"undefined");
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingIncomingDamageEvent event) {
        VehicleEntity vehicle;
        Entity entity;
        if (!event.getSource().is(ModDamageTypes.VEHICLE_EXPLOSION) && (entity = event.getEntity().getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).isEnclosed((Entity)event.getEntity())) {
            if (!event.getSource().is(ModTags.DamageTypes.VEHICLE_NOT_ABSORB)) {
                vehicle.hurt(event.getSource(), event.getAmount());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingIncomingDamageEvent event) {
        if (event == null) {
            return;
        }
        LivingEventHandler.handleVehicleHurt(event);
        LivingEventHandler.handleGunPerksWhenHurt(event);
        LivingEventHandler.renderDamageIndicator(event);
        LivingEventHandler.reduceDamage(event);
        LivingEventHandler.giveExpToWeapon(event);
        LivingEventHandler.handleGunLevels(event);
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event == null) {
            return;
        }
        LivingEventHandler.killIndication(event);
        LivingEventHandler.handleGunPerksWhenDeath(event);
        LivingEventHandler.handlePlayerKillEntity(event);
        LivingEventHandler.giveKillExpToWeapon(event);
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            LivingEventHandler.handlePlayerBeamReset(player);
        }
    }

    private static void handleVehicleHurt(LivingIncomingDamageEvent event) {
        Entity entity = event.getEntity().getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            DamageSource source = event.getSource();
            if (source.is(ModTags.DamageTypes.VEHICLE_IGNORE)) {
                return;
            }
            if (vehicle.isEnclosed((Entity)event.getEntity())) {
                if (!source.is(ModDamageTypes.VEHICLE_EXPLOSION)) {
                    event.setCanceled(true);
                }
            } else {
                if (!source.is(ModTags.DamageTypes.VEHICLE_NOT_ABSORB)) {
                    entity.hurt(event.getSource(), 0.7f * event.getAmount());
                }
                event.setAmount(0.3f * event.getAmount());
            }
        }
    }

    private static void reduceDamage(LivingIncomingDamageEvent event) {
        ItemStack stack;
        double amount;
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        Entity sourceEntity = source.getEntity();
        if (sourceEntity == null) {
            return;
        }
        if (sourceEntity.level().isClientSide) {
            return;
        }
        double damage = amount = (double)event.getAmount();
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)sourceEntity;
            v0 = living.getMainHandItem();
        } else {
            v0 = stack = ItemStack.EMPTY;
        }
        if (DamageTypeTool.isGunDamage(source) && stack.getItem() instanceof GunItem) {
            GunData data = GunData.from(stack);
            double distance = entity.position().distanceTo(sourceEntity.position());
            damage = LivingEventHandler.reduceDamageByDistance(amount, distance, data.getDamageReduceRate(), data.getDamageReduceMinDistance());
        }
        ItemStack armor = entity.getItemBySlot(EquipmentSlot.CHEST);
        CompoundTag tag = NBTTool.getTag(armor);
        if (armor != ItemStack.EMPTY && tag.contains("ArmorPlate")) {
            double armorValue = tag.getDouble("ArmorPlate");
            tag.putDouble("ArmorPlate", Math.max(armorValue - damage, 0.0));
            NBTTool.saveTag(armor, tag);
            damage = Math.max(damage - armorValue, 0.0);
        }
        if (source.is(ModTags.DamageTypes.PROJECTILE) || source.is(DamageTypes.MOB_PROJECTILE)) {
            damage *= 1.0 - 0.8 * Mth.clamp((double)entity.getAttributeValue(ModAttributes.BULLET_RESISTANCE), (double)0.0, (double)1.0);
        }
        if (source.is(ModTags.DamageTypes.PROJECTILE_ABSOLUTE)) {
            damage *= 1.0 - 0.2 * Mth.clamp((double)entity.getAttributeValue(ModAttributes.BULLET_RESISTANCE), (double)0.0, (double)1.0);
        }
        if (source.is(ModDamageTypes.PROJECTILE_EXPLOSION) || source.is(ModDamageTypes.MINE) || source.is(ModDamageTypes.PROJECTILE_HIT) || source.is(ModDamageTypes.CUSTOM_EXPLOSION) || source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.PLAYER_EXPLOSION)) {
            damage *= 1.0 - 0.3 * Mth.clamp((double)entity.getAttributeValue(ModAttributes.BULLET_RESISTANCE), (double)0.0, (double)1.0);
        }
        event.setAmount((float)damage);
        if (entity instanceof TargetEntity && sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            if (event.getSource().is(ModDamageTypes.BEAST)) {
                damage = Double.POSITIVE_INFINITY;
            }
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.target.damage", (Object[])new Object[]{FormatTool.format2D(damage), FormatTool.format1D(entity.position().distanceTo(sourceEntity.position()), "m")}), false);
        }
    }

    private static double reduceDamageByDistance(double amount, double distance, double rate, double minDistance) {
        return amount / (1.0 + rate * Math.max(0.0, distance - minDistance));
    }

    private static void giveExpToWeapon(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        Entity sourceEntity = source.getEntity();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceEntity;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (event.getEntity().getType().is(ModTags.EntityTypes.NO_EXPERIENCE)) {
            return;
        }
        GunData data = GunData.from(stack);
        double amount = Math.min(0.125 * (double)event.getAmount(), (double)event.getEntity().getMaxHealth());
        if (source.is(ModDamageTypes.PROJECTILE_EXPLOSION) && (data.compute().explosionDamage > 0.0 || GunData.from((ItemStack)stack).perk.getLevel(ModPerks.HE_BULLET) > 0)) {
            data.exp.set(data.exp.get() + amount);
        }
        if (!DamageTypeTool.isGunDamage(source)) {
            return;
        }
        data.exp.set(data.exp.get() + amount);
        data.save();
    }

    private static void giveKillExpToWeapon(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        Entity sourceEntity = source.getEntity();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceEntity;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (event.getEntity().getType().is(ModTags.EntityTypes.NO_EXPERIENCE)) {
            return;
        }
        GunData data = GunData.from(stack);
        double amount = 20.0f + 2.0f * event.getEntity().getMaxHealth();
        if (source.is(ModDamageTypes.PROJECTILE_EXPLOSION) && (data.compute().explosionDamage > 0.0 || GunData.from((ItemStack)stack).perk.getLevel(ModPerks.HE_BULLET) > 0)) {
            data.exp.add(amount);
        }
        if (DamageTypeTool.isGunDamage(source)) {
            data.exp.add(amount);
        }
        int level = data.level.get();
        double exp = data.exp.get();
        double upgradeExpNeeded = 20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0;
        while (exp >= upgradeExpNeeded) {
            level = data.level.get() + 1;
            upgradeExpNeeded = 20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0;
            data.exp.set(exp -= upgradeExpNeeded);
            data.level.set(level);
        }
        data.save();
    }

    private static void handleGunLevels(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        Entity sourceEntity = source.getEntity();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceEntity;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (event.getEntity().getType().is(ModTags.EntityTypes.NO_EXPERIENCE)) {
            return;
        }
        GunData data = GunData.from(stack);
        int level = data.level.get();
        double exp = data.exp.get();
        double upgradeExpNeeded = 20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0;
        while (exp >= upgradeExpNeeded) {
            level = data.level.get() + 1;
            upgradeExpNeeded = 20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0;
            data.exp.set(exp -= upgradeExpNeeded);
            data.level.set(level);
        }
        data.save();
    }

    private static void killIndication(LivingDeathEvent event) {
        if (!((Boolean)MiscConfig.SEND_KILL_FEEDBACK.get()).booleanValue()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity sourceEntity = source.getEntity();
        if (sourceEntity == null) {
            return;
        }
        if (!((Boolean)GameplayConfig.GLOBAL_INDICATION.get()).booleanValue() && !DamageTypeTool.isModDamage(source)) {
            return;
        }
        if (!sourceEntity.level().isClientSide() && sourceEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceEntity;
            if (((PreKillEvent.Indicator)NeoForge.EVENT_BUS.post((Event)new PreKillEvent.Indicator((LivingEntity)player, source, event.getEntity()))).isCanceled()) {
                return;
            }
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.TARGET_DOWN.get(), 3.0f, 1.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(2, 8), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void renderDamageIndicator(LivingIncomingDamageEvent event) {
        if (event == null) {
            return;
        }
        DamageSource damagesource = event.getSource();
        Entity sourceEntity = damagesource.getEntity();
        if (sourceEntity == null) {
            return;
        }
        if (sourceEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceEntity;
            if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION) || damagesource.is(ModDamageTypes.MINE) || damagesource.is(ModDamageTypes.PROJECTILE_EXPLOSION)) {
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.INDICATION.get(), 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void handleChangeSlot(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.MAINHAND) {
                if (player.level().isClientSide) {
                    return;
                }
                ItemStack oldStack = event.getFrom();
                ItemStack newStack = event.getTo();
                LaserCapability laserCap = (LaserCapability)player.getCapability(ModCapabilities.LASER_CAPABILITY);
                if (laserCap != null) {
                    laserCap.stop();
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (newStack.getItem() instanceof GunItem) {
                        LivingEventHandler.checkCopyGuns(newStack, player);
                    }
                    if (newStack.getItem() != oldStack.getItem() || newStack.getItem() instanceof GunItem && !GunData.from(newStack).initialized() || oldStack.getItem() instanceof GunItem && !GunData.from(oldStack).initialized() || newStack.getItem() instanceof GunItem && oldStack.getItem() instanceof GunItem && !Objects.equals(GunsTool.getGunUUID(NBTTool.getTag(newStack)), GunsTool.getGunUUID(NBTTool.getTag(oldStack)))) {
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)DrawClientMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                        Perk.Type[] typeArray = oldStack.getItem();
                        if (typeArray instanceof GunItem) {
                            GunItem oldGun = (GunItem)typeArray;
                            GunData oldData = GunData.from(oldStack);
                            LivingEventHandler.stopGunReloadSound(serverPlayer, oldData);
                            if (oldData.compute().boltActionTime > 0) {
                                oldData.bolt.actionTimer.reset();
                            }
                            oldData.reload.setTime(0);
                            oldData.reload.setState(ReloadState.NOT_RELOADING);
                            if (oldData.compute().iterativeTime != 0) {
                                oldData.stopped.set(false);
                                oldData.forceStop.set(false);
                                oldData.reload.setStage(0);
                                oldData.reload.prepareTimer.reset();
                                oldData.reload.prepareLoadTimer.reset();
                                oldData.reload.iterativeLoadTimer.reset();
                                oldData.reload.finishTimer.reset();
                            }
                            if (oldStack.is((Item)ModItems.SENTINEL.get())) {
                                oldData.charge.timer.reset();
                            }
                            oldGun.onChangeSlot(oldData, (Entity)player);
                            oldData.save();
                        }
                        if (newStack.getItem() instanceof GunItem) {
                            GunData newData = GunData.from(newStack);
                            if (newData.compute().boltActionTime > 0) {
                                newData.bolt.actionTimer.reset();
                            }
                            newData.reload.setState(ReloadState.NOT_RELOADING);
                            newData.reload.reloadTimer.reset();
                            if (newData.compute().iterativeTime != 0) {
                                newData.forceStop.set(false);
                                newData.stopped.set(false);
                                newData.reload.setStage(0);
                                newData.reload.prepareTimer.reset();
                                newData.reload.prepareLoadTimer.reset();
                                newData.reload.iterativeLoadTimer.reset();
                                newData.reload.finishTimer.reset();
                            }
                            if (newStack.is((Item)ModItems.SENTINEL.get())) {
                                newData.charge.timer.reset();
                            }
                            for (Perk.Type type : Perk.Type.values()) {
                                PerkInstance instance = newData.perk.getInstance(type);
                                if (instance == null) continue;
                                instance.perk().onChangeSlot(newData, instance, (Entity)player);
                            }
                            newData.save();
                        }
                    }
                }
            }
        }
    }

    private static void checkCopyGuns(ItemStack stack, Player player) {
        GunData data = GunData.from(stack);
        if (!data.initialized()) {
            return;
        }
        if (data.gunDataTag == null) {
            return;
        }
        UUID uuid = data.gunDataTag.getUUID("UUID");
        for (ItemStack item : player.getInventory().items) {
            if (item.equals(stack) || !(item.getItem() instanceof GunItem)) continue;
            GunData itemData = GunData.from(item);
            CompoundTag dataTag = itemData.gunDataTag;
            if (dataTag == null || !dataTag.hasUUID("UUID") || !dataTag.getUUID("UUID").equals(uuid)) continue;
            data.gunDataTag.putUUID("UUID", UUID.randomUUID());
            return;
        }
    }

    public static void stopGunReloadSound(ServerPlayer player, GunData data) {
        SoundInfo soundInfo = data.compute().soundInfo;
        soundInfo.cancellableSounds.list.forEach(str -> {
            ResourceLocation location = ResourceLocation.tryParse((String)str);
            if (location != null) {
                player.connection.send((Packet)new ClientboundStopSoundPacket(location, SoundSource.PLAYERS));
            }
        });
    }

    private static void handlePlayerKillEntity(LivingDeathEvent event) {
        Projectile projectile;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        DamageSource source = event.getSource();
        ResourceKey damageTypeResourceKey = source.typeHolder().unwrapKey().isPresent() ? (ResourceKey)source.typeHolder().unwrapKey().get() : DamageTypes.GENERIC;
        LivingEntity attacker = null;
        Entity entity3 = source.getEntity();
        if (entity3 instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity3;
            if (living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                attacker = player;
            } else {
                attacker = living;
            }
        }
        if ((entity = source.getDirectEntity()) instanceof Projectile && (entity = (projectile = (Projectile)entity).getOwner()) instanceof LivingEntity) {
            OwnableEntity ownableEntity;
            LivingEntity living = (LivingEntity)entity;
            if (living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                attacker = player;
            } else if (living instanceof OwnableEntity && (ownableEntity = (OwnableEntity)living).getOwner() instanceof ServerPlayer) {
                attacker = living;
            }
        }
        if (((PreKillEvent.SendKillMessage)NeoForge.EVENT_BUS.post((Event)new PreKillEvent.SendKillMessage(attacker, source, entity2))).isCanceled()) {
            return;
        }
        if (attacker != null && ((Boolean)MiscConfig.SEND_KILL_FEEDBACK.get()).booleanValue()) {
            if (DamageTypeTool.isHeadshotDamage(source)) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new LivingGunKillMessage(attacker.getId(), entity2.getId(), true, (ResourceKey<DamageType>)damageTypeResourceKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new LivingGunKillMessage(attacker.getId(), entity2.getId(), false, (ResourceKey<DamageType>)damageTypeResourceKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static void handleGunPerksWhenHurt(LivingIncomingDamageEvent event) {
        Projectile projectile;
        Entity entity;
        DamageSource source = event.getSource();
        if (!DamageTypeTool.isGunDamage(source) && !source.is(DamageTypes.PLAYER_ATTACK)) {
            return;
        }
        LivingEntity attacker = null;
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)entity2;
        }
        if ((entity = source.getDirectEntity()) instanceof Projectile && (entity = (projectile = (Projectile)entity).getOwner()) instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)entity;
        }
        if (attacker == null) {
            return;
        }
        ItemStack stack = attacker.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        float damage = event.getAmount();
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            if (DamageTypeTool.isGunDamage(source)) {
                damage = instance.perk().getModifiedDamage(damage, data, instance, (Entity)event.getEntity(), source);
                instance.perk().onHurtEntity(damage, data, instance, (Entity)event.getEntity(), source);
                continue;
            }
            if (!source.is(DamageTypes.PLAYER_ATTACK)) continue;
            instance.perk().onMeleeAttack(data, instance, (Entity)event.getEntity());
        }
        event.setAmount(damage);
    }

    private static void handleGunPerksWhenDeath(LivingDeathEvent event) {
        Projectile projectile;
        Perk.Type[] typeArray;
        DamageSource source = event.getSource();
        if (!DamageTypeTool.isGunDamage(source)) {
            return;
        }
        LivingEntity attacker = null;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)entity;
        }
        if ((typeArray = source.getDirectEntity()) instanceof Projectile && (typeArray = (projectile = (Projectile)typeArray).getOwner()) instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)typeArray;
        }
        if (attacker == null) {
            return;
        }
        ItemStack stack = attacker.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().onKill(data, instance, (Entity)event.getEntity(), source);
        }
    }

    @SubscribeEvent
    public static void onPickup(ItemEntityPickupEvent.Pre event) {
        if (!((Boolean)VehicleConfig.VEHICLE_ITEM_PICKUP.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getPlayer().getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicleEntity = (VehicleEntity)entity;
            ItemEntity pickUp = event.getItemEntity();
            if (!vehicleEntity.level().isClientSide) {
                HopperBlockEntity.addItem((Container)vehicleEntity, (ItemEntity)pickUp);
            }
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEventHandler.playerDropAmmoBox(event);
        LivingEventHandler.vehicleCollectDrops(event);
    }

    private static void playerDropAmmoBox(LivingDropsEvent event) {
        boolean drop;
        if (!((Boolean)MiscConfig.DROP_AMMO_BOX.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.level().getLevelData().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            return;
        }
        PlayerVariable cap = ((PlayerVariable)player.getData(ModAttachments.PLAYER_VARIABLE)).watch();
        boolean bl = drop = Stream.of(Ammo.values()).mapToInt(type -> type.get(cap)).sum() > 0;
        if (!drop) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.AMMO_BOX.get());
        for (Ammo type2 : Ammo.values()) {
            type2.set(stack, type2.get(cap));
            type2.set(cap, 0);
        }
        AmmoBoxInfo info = new AmmoBoxInfo("All", true);
        stack.set(ModDataComponents.AMMO_BOX_INFO, (Object)info);
        player.setData(ModAttachments.PLAYER_VARIABLE, (Object)cap);
        cap.sync((Entity)player);
        event.getDrops().add(new ItemEntity(player.level(), player.getX(), player.getY() + 1.0, player.getZ(), stack));
    }

    private static void vehicleCollectDrops(LivingDropsEvent event) {
        if (!((Boolean)VehicleConfig.COLLECT_DROPS_BY_CRASHING.get()).booleanValue()) {
            return;
        }
        DamageSource source = event.getSource();
        if (!source.is(ModDamageTypes.VEHICLE_STRIKE)) {
            return;
        }
        Entity sourceEntity = source.getEntity();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceEntity;
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            Collection drops = event.getDrops();
            ArrayList removed = new ArrayList();
            drops.forEach(itemEntity -> {
                ItemStack stack = itemEntity.getItem();
                InventoryTool.insertItem(vehicle.getItemStacks(), stack);
                if (stack.getCount() <= 0) {
                    player.drop(stack, false);
                    removed.add(itemEntity);
                }
            });
            drops.removeAll(removed);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player == null) {
            return;
        }
        if (player.getVehicle() instanceof VehicleEntity) {
            player.giveExperiencePoints(event.getDroppedExperience());
            event.setCanceled(true);
        }
    }

    public static void handlePlayerBeamReset(Player player) {
        LaserCapability cap = (LaserCapability)player.getCapability(ModCapabilities.LASER_CAPABILITY);
        if (cap != null) {
            cap.end();
        }
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        ICustomKnockback knockback = ICustomKnockback.getInstance(event.getEntity());
        if (knockback.superbWarfare$getKnockbackStrength() >= 0.0) {
            event.setStrength((float)knockback.superbWarfare$getKnockbackStrength());
        }
    }

    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        if (living.getVehicle() instanceof VehicleEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPreSendKillMessage(PreKillEvent.SendKillMessage event) {
        if (event.getSource().getDirectEntity() instanceof AutoAimableEntity && !(event.getTarget() instanceof Player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPreIndicator(PreKillEvent.Indicator event) {
        if (event.getSource().getDirectEntity() instanceof AutoAimableEntity && !(event.getTarget() instanceof Player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEffectApply(MobEffectEvent.Applicable event) {
        VehicleEntity vehicle;
        Entity entity;
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (((MobEffect)effectInstance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL && (entity = event.getEntity().getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).isEnclosed(vehicle.getSeatIndex((Entity)event.getEntity()))) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }
}

