/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.config.common.GameplayConfig;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class PlayerEventHandler {
    public static final ResourceLocation TACTICAL_SPRINT = Mod.loc("tactical_sprint");

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        ItemStack mainStack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(mainStack);
        if (mainStack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using")) {
            tag.putBoolean("Using", false);
            NBTTool.saveTag(mainStack, tag);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawned(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        PlayerEventHandler.handleRespawnReload(player);
        PlayerEventHandler.handleRespawnAutoArmor(player);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof GunItem) {
            PlayerEventHandler.handleSpecialWeaponAmmo(player);
        }
        if (!player.level().isClientSide) {
            PlayerEventHandler.handleTacticalAttribute(player);
        }
    }

    private static void handleSpecialWeaponAmmo(Player player) {
        ItemStack stack = player.getMainHandItem();
        GunData data = GunData.from(stack);
        if ((stack.is((Item)ModItems.RPG.get()) || stack.is((Item)ModItems.BOCEK.get())) && data.hasEnoughAmmoToShoot((Entity)player)) {
            data.isEmpty.set(false);
        }
    }

    private static void handleRespawnReload(Player player) {
        if (!((Boolean)GameplayConfig.RESPAWN_RELOAD.get()).booleanValue()) {
            return;
        }
        for (ItemStack stack : player.getInventory().items) {
            if (!(stack.getItem() instanceof GunItem)) continue;
            GunData data = GunData.from(stack);
            if (!InventoryTool.hasCreativeAmmoBox((Entity)player)) {
                data.reloadAmmo((Entity)player);
            } else {
                data.ammo.set(data.compute().magazine);
            }
            data.holdOpen.set(false);
            data.save();
        }
    }

    private static void handleRespawnAutoArmor(Player player) {
        if (!((Boolean)GameplayConfig.RESPAWN_AUTO_ARMOR.get()).booleanValue()) {
            return;
        }
        ItemStack armor = player.getItemBySlot(EquipmentSlot.CHEST);
        if (armor == ItemStack.EMPTY) {
            return;
        }
        CompoundTag tag = NBTTool.getTag(armor);
        double armorPlate = tag.getDouble("ArmorPlate");
        int armorLevel = (Integer)MiscConfig.DEFAULT_ARMOR_LEVEL.get();
        if (armor.is(ModTags.Items.MILITARY_ARMOR)) {
            armorLevel = (Integer)MiscConfig.MILITARY_ARMOR_LEVEL.get();
        } else if (armor.is(ModTags.Items.MILITARY_ARMOR_HEAVY)) {
            armorLevel = (Integer)MiscConfig.HEAVY_MILITARY_ARMOR_LEVEL.get();
        }
        if (armorPlate >= (double)(armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get())) {
            return;
        }
        for (ItemStack stack : player.getInventory().items) {
            if (!stack.is((Item)ModItems.ARMOR_PLATE.get())) continue;
            CompoundTag stackTag = NBTTool.getTag(stack);
            if (stackTag.getBoolean("Infinite")) {
                tag.putDouble("ArmorPlate", (double)(armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get()));
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
                continue;
            }
            int index0 = 0;
            while ((double)index0 < Math.ceil(((double)(armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get()) - armorPlate) / (double)((Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get()).intValue())) {
                stack.finishUsingItem(player.level(), (LivingEntity)player);
                ++index0;
            }
        }
        NBTTool.saveTag(armor, tag);
    }

    public static void handleTacticalAttribute(Player player) {
        if (player == null) {
            return;
        }
        AttributeInstance attr = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attr == null) {
            return;
        }
        if (attr.getModifier(TACTICAL_SPRINT) != null) {
            attr.removeModifier(TACTICAL_SPRINT);
        }
        if (((Boolean)MiscConfig.ALLOW_TACTICAL_SPRINT.get()).booleanValue() && ((PlayerVariable)player.getData(ModAttachments.PLAYER_VARIABLE)).tacticalSprint) {
            player.setSprinting(true);
            attr.addTransientModifier(new AttributeModifier(TACTICAL_SPRINT, 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.getItem() instanceof GunItem && right.getItem() == ModItems.SHORTCUT_PACK.get()) {
            ItemStack output = left.copy();
            GunData data = GunData.from(output);
            data.level.add(1);
            data.save();
            event.setOutput(output);
            event.setCost(10L);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Entity target = event.getTarget();
        if (target instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)target;
            Vec3 position = TraceTool.playerFindLookingPos((Entity)event.getEntity(), vehicle, event.getEntity().entityInteractionRange());
            if (position != null) {
                Level level;
                if (vehicle.shouldSendHitSounds()) {
                    vehicle.level().playSound(null, BlockPos.containing((Position)position), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (vehicle.shouldSendHitParticles() && (level = vehicle.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), position.x, position.y, position.z, 2, 0.0, 0.0, 0.0, 0.2, false);
                }
            }
        }
    }
}

