/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.init;

import com.atsuishio.superbwarfare.data.gun.GunData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModSerializers {
    public static final DeferredRegister<EntityDataSerializer<?>> REGISTRY = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"superbwarfare");
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<List<Integer>>> INT_LIST_SERIALIZER = REGISTRY.register("int_list_serializer", () -> EntityDataSerializer.forValueType((StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list())));
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<List<Float>>> FLOAT_LIST_SERIALIZER = REGISTRY.register("float_list_serializer", () -> EntityDataSerializer.forValueType((StreamCodec)ByteBufCodecs.FLOAT.apply(ByteBufCodecs.list())));
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<Map<String, GunData>>> VEHICLE_GUN_DATA_MAP_SERIALIZER = REGISTRY.register("vehicle_gun_data_map_serializer", () -> new EntityDataSerializer<Map<String, GunData>>(){

        @NotNull
        public StreamCodec<? super RegistryFriendlyByteBuf, Map<String, GunData>> codec() {
            return ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, GunData.VEHICLE_GUN_STREAM_CODEC);
        }

        @NotNull
        public Map<String, GunData> copy(@NotNull Map<String, GunData> map) {
            HashMap<String, GunData> newMap = new HashMap<String, GunData>();
            map.forEach((key, value) -> newMap.put((String)key, value.copy()));
            return newMap;
        }
    });
}

