/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.Blu43Entity;
import com.atsuishio.superbwarfare.init.ModEntities;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class Blu43MineItem
extends Item {
    public Blu43MineItem() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            float randomRot = (float)Mth.clamp((double)((2.0 * Math.random() - 1.0) * 180.0), (double)-180.0, (double)180.0);
            Blu43Entity entity = new Blu43Entity((LivingEntity)player, level);
            entity.moveTo(player.getX(), player.getY() + 1.1, player.getZ(), randomRot, 0.0f);
            entity.setYBodyRot(randomRot);
            entity.setYHeadRot(randomRot);
            entity.setDeltaMovement(0.5 * player.getLookAngle().x, 0.5 * player.getLookAngle().y, 0.5 * player.getLookAngle().z);
            level.addFreshEntity((Entity)entity);
        }
        player.getCooldowns().addCooldown((Item)this, 4);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public static class Blu43MineDispenseBehavior
    extends DefaultDispenseItemBehavior {
        @ParametersAreNonnullByDefault
        @NotNull
        protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
            ServerLevel level = blockSource.level();
            Position position = DispenserBlock.getDispensePosition((BlockSource)blockSource);
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            Blu43Entity blu43 = new Blu43Entity((EntityType<Blu43Entity>)((EntityType)ModEntities.BLU_43.get()), (Level)level);
            blu43.setPos(position.x(), position.y(), position.z());
            float randomRot = (float)Mth.clamp((double)((2.0 * Math.random() - 1.0) * 180.0), (double)-180.0, (double)180.0);
            int pX = direction.getStepX();
            int pY = direction.getStepY();
            int pZ = direction.getStepZ();
            blu43.shoot(pX, pY, pZ, 0.4f, 10.0f);
            blu43.setYRot(randomRot);
            blu43.yRotO = blu43.getYRot();
            level.addFreshEntity((Entity)blu43);
            stack.shrink(1);
            return stack;
        }
    }
}

