/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.client.tooltip.component.ChargingStationImageComponent;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.init.ModBlocks;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ChargingStationBlockItem
extends BlockItem {
    public static final int MAX_ENERGY = 4000000;

    public ChargingStationBlockItem() {
        super((Block)ModBlocks.CHARGING_STATION.get(), new Item.Properties().stacksTo(1));
    }

    public boolean isBarVisible(ItemStack stack) {
        int energy = (Integer)stack.getOrDefault((DataComponentType)ModDataComponents.ENERGY.get(), (Object)0);
        return energy != 4000000 && energy != 0;
    }

    public int getBarWidth(ItemStack stack) {
        int energy = (Integer)stack.getOrDefault((DataComponentType)ModDataComponents.ENERGY.get(), (Object)0);
        return Math.round((float)energy * 13.0f / 4000000.0f);
    }

    public int getBarColor(@NotNull ItemStack pStack) {
        return 0xFFFF00;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new ChargingStationImageComponent(pStack));
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.charging_station").withStyle(ChatFormatting.GRAY));
    }
}

