/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModItems;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class Crowbar
extends SwordItem {
    public static final Tier TIER = new Tier(){

        public int getUses() {
            return 400;
        }

        public float getSpeed() {
            return 4.0f;
        }

        public float getAttackDamageBonus() {
            return 3.5f;
        }

        @NotNull
        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getLevel() {
            return 1;
        }

        public int getEnchantmentValue() {
            return 9;
        }

        @NotNull
        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.IRON_INGOT)});
        }
    };

    public Crowbar() {
        super(TIER, new Item.Properties().stacksTo(1).attributes(SwordItem.createAttributes((Tier)TIER, (int)2, (float)-2.0f).withModifierAdded(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Mod.ATTRIBUTE_MODIFIER, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)));
    }

    public boolean isRepairable(@NotNull ItemStack itemstack) {
        return true;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        super.useOn(context);
        if (context.getLevel().getBlockState(BlockPos.containing((double)context.getClickedPos().getX(), (double)context.getClickedPos().getY(), (double)context.getClickedPos().getZ())).getBlock() == ModBlocks.JUMP_PAD.get()) {
            context.getLevel().setBlock(BlockPos.containing((double)context.getClickedPos().getX(), (double)context.getClickedPos().getY(), (double)context.getClickedPos().getZ()), Blocks.AIR.defaultBlockState(), 3);
            if (context.getPlayer() != null) {
                ItemHandlerHelper.giveItemToPlayer((Player)context.getPlayer(), (ItemStack)new ItemStack((ItemLike)ModItems.JUMP_PAD.get()));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.crowbar").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.crowbar_2").withStyle(ChatFormatting.GRAY));
    }
}

