/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.projectile.M18SmokeGrenadeEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.NBTTool;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class M18SmokeGrenade
extends Item
implements ProjectileItem {
    public static final String TAG_COLOR = "Color";

    public M18SmokeGrenade() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void setColor(ItemStack stack, int color) {
        CompoundTag tag = NBTTool.getTag(stack);
        tag.putInt(TAG_COLOR, color);
        NBTTool.saveTag(stack, tag);
    }

    public int getColor(ItemStack stack) {
        CompoundTag tag = NBTTool.getTag(stack);
        return tag.contains(TAG_COLOR) ? tag.getInt(TAG_COLOR) : 0xFFFFFF;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.m18_smoke_grenade").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)("#" + Integer.toHexString(this.getColor(stack)))).withStyle(Style.EMPTY.withColor(this.getColor(stack)))));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.GRENADE_PULL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.SPEAR;
    }

    @ParametersAreNonnullByDefault
    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        Player player;
        int usingTime;
        if (!worldIn.isClientSide && entityLiving instanceof Player && (usingTime = this.getUseDuration(stack, (LivingEntity)(player = (Player)entityLiving)) - timeLeft) > 3) {
            player.getCooldowns().addCooldown(stack.getItem(), 20);
            float power = Math.min((float)usingTime / 8.0f, 1.8f);
            int color = this.getColor(stack);
            M18SmokeGrenadeEntity grenade = new M18SmokeGrenadeEntity((LivingEntity)player, worldIn, 80 - usingTime).setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            grenade.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power, 0.0f);
            worldIn.addFreshEntity((Entity)grenade);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.isClientSide) {
            Player player;
            int color = this.getColor(pStack);
            M18SmokeGrenadeEntity grenade = new M18SmokeGrenadeEntity(pLivingEntity, pLevel, 2).setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            pLevel.addFreshEntity((Entity)grenade);
            if (pLivingEntity instanceof Player) {
                player = (Player)pLivingEntity;
                player.getCooldowns().addCooldown(pStack.getItem(), 20);
            }
            if (pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).isCreative()) {
                pStack.shrink(1);
            }
        }
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    @ParametersAreNonnullByDefault
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 80;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        int color = this.getColor(stack);
        return new M18SmokeGrenadeEntity((EntityType<? extends M18SmokeGrenadeEntity>)((EntityType)ModEntities.M18_SMOKE_GRENADE.get()), pos.x(), pos.y(), pos.z(), level).setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public static class SmokeGrenadeDispenserBehavior
    extends ProjectileDispenseBehavior {
        public SmokeGrenadeDispenserBehavior() {
            super((Item)ModItems.M18_SMOKE_GRENADE.get());
        }

        protected void playSound(BlockSource blockSource) {
            blockSource.level().playSound(null, blockSource.pos(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

