/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class TargetDeployer
extends Item {
    private static final Predicate<Entity> IS_TARGET = e -> e instanceof TargetEntity;

    public TargetDeployer() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = pContext.getItemInHand();
        BlockPos blockpos = pContext.getClickedPos();
        Direction direction = pContext.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos pos = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        if (!level.getEntities((Entity)null, ((EntityType)ModEntities.TARGET.get()).getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), IS_TARGET).isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (((EntityType)ModEntities.TARGET.get()).spawn((ServerLevel)level, itemstack, pContext.getPlayer(), pos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, pos) && direction == Direction.UP) != null) {
            itemstack.shrink(1);
            level.gameEvent((Entity)pContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult blockhitresult = TargetDeployer.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (!(pLevel instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        if (!(pLevel.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (pLevel.mayInteract(pPlayer, blockpos) && pPlayer.mayUseItemAt(blockpos, blockhitresult.getDirection(), itemstack)) {
            if (!pLevel.getEntities((Entity)null, ((EntityType)ModEntities.TARGET.get()).getSpawnAABB((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5), IS_TARGET).isEmpty()) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            TargetEntity entity = (TargetEntity)((EntityType)ModEntities.TARGET.get()).spawn((ServerLevel)pLevel, itemstack, pPlayer, blockpos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!pPlayer.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.ENTITY_PLACE, entity.position());
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

