/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.client.renderer.item.Tm62ItemRenderer;
import com.atsuishio.superbwarfare.entity.Tm62Entity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class Tm62Item
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Tm62Item() {
        super(new Item.Properties().stacksTo(8));
    }

    @SubscribeEvent
    private static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new Tm62ItemRenderer();

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        }, new Holder[]{ModItems.TM_62});
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            float randomRot = (float)Mth.clamp((double)((2.0 * Math.random() - 1.0) * 180.0), (double)-180.0, (double)180.0);
            Tm62Entity entity = new Tm62Entity((LivingEntity)player, level, player.isShiftKeyDown());
            entity.moveTo(player.getX(), player.getY() + 1.1, player.getZ(), randomRot, 0.0f);
            entity.setYBodyRot(randomRot);
            entity.setYHeadRot(randomRot);
            entity.setDeltaMovement(0.5 * player.getLookAngle().x, 0.5 * player.getLookAngle().y, 0.5 * player.getLookAngle().z);
            level.addFreshEntity((Entity)entity);
        }
        player.getCooldowns().addCooldown((Item)this, 20);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public static class Tm62DispenseBehavior
    extends DefaultDispenseItemBehavior {
        @ParametersAreNonnullByDefault
        @NotNull
        protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
            ServerLevel level = blockSource.level();
            Position position = DispenserBlock.getDispensePosition((BlockSource)blockSource);
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            Tm62Entity tm62 = new Tm62Entity((EntityType<Tm62Entity>)((EntityType)ModEntities.TM_62.get()), (Level)level);
            tm62.setPos(position.x(), position.y(), position.z());
            float randomRot = (float)Mth.clamp((double)((2.0 * Math.random() - 1.0) * 180.0), (double)-180.0, (double)180.0);
            int pX = direction.getStepX();
            int pY = direction.getStepY();
            int pZ = direction.getStepZ();
            tm62.shoot(pX, pY, pZ, 0.2f, 25.0f);
            tm62.setYRot(randomRot);
            tm62.yRotO = tm62.getYRot();
            level.addFreshEntity((Entity)tm62);
            stack.shrink(1);
            return stack;
        }
    }
}

