/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common;

import com.atsuishio.superbwarfare.entity.MedicalKitEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class MedicalKitItem
extends Item {
    public MedicalKitItem() {
        super(new Item.Properties().stacksTo(16));
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.medical_kit").withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand handIn) {
        ItemStack stack = player.getItemInHand(handIn);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                float randomRot = (float)Mth.clamp((double)((2.0 * Math.random() - 1.0) * 180.0), (double)-180.0, (double)180.0);
                MedicalKitEntity entity = new MedicalKitEntity((EntityType<MedicalKitEntity>)((EntityType)ModEntities.MEDICAL_KIT.get()), level);
                entity.moveTo(player.getX(), player.getEyeY() - 0.25, player.getZ(), randomRot, 0.0f);
                entity.setYBodyRot(randomRot);
                entity.setYHeadRot(randomRot);
                entity.setDeltaMovement(0.8 * player.getLookAngle().x, 0.8 * player.getLookAngle().y, 0.8 * player.getLookAngle().z);
                level.addFreshEntity((Entity)entity);
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            player.getCooldowns().addCooldown((Item)this, 25);
            return InteractionResultHolder.success((Object)stack);
        }
        if (player.getHealth() < player.getMaxHealth()) {
            player.startUsingItem(handIn);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack pStack, Level pLevel, @NotNull LivingEntity pLivingEntity) {
        if (!pLevel.isClientSide) {
            Player player;
            MedicalKitItem.treat(pLivingEntity);
            if (pLivingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pLivingEntity;
                serverPlayer.level().playSound((Entity)null, serverPlayer.getOnPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (pLivingEntity instanceof Player) {
                player = (Player)pLivingEntity;
                player.getCooldowns().addCooldown(pStack.getItem(), 25);
            }
            if (!(pLivingEntity instanceof Player) || !(player = (Player)pLivingEntity).isCreative()) {
                pStack.shrink(1);
            }
        }
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    @ParametersAreNonnullByDefault
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 40;
    }

    public static void treat(LivingEntity living) {
        living.heal(5.0f + 0.25f * living.getMaxHealth());
        living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1, false, false), (Entity)living);
    }
}

