/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common.ammo;

import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.common.ammo.box.AmmoBoxInfo;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AmmoBoxItem
extends Item {
    private static final List<String> AMMO_TYPE_LIST = AmmoBoxItem.generateAmmoTypeList();

    public AmmoBoxItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.getCooldowns().addCooldown((Item)this, 10);
        AmmoBoxInfo info = (AmmoBoxInfo)stack.get(ModDataComponents.AMMO_BOX_INFO);
        if (info == null) {
            info = new AmmoBoxInfo("All", false);
        }
        String selectedType = info.type();
        PlayerVariable cap = ((PlayerVariable)player.getData(ModAttachments.PLAYER_VARIABLE)).watch();
        if (!level.isClientSide()) {
            Ammo[] types;
            Ammo[] ammoArray;
            if (selectedType.equals("All") || info.isDrop()) {
                ammoArray = Ammo.values();
            } else {
                Ammo[] ammoArray2 = new Ammo[1];
                ammoArray = ammoArray2;
                ammoArray2[0] = Ammo.getType(selectedType);
            }
            for (Ammo type : types = ammoArray) {
                if (type == null) continue;
                if (player.isCrouching() && !info.isDrop()) {
                    type.add(stack, type.get(cap));
                    type.set(cap, 0);
                    continue;
                }
                type.add(cap, type.get(stack));
                type.set(stack, 0);
            }
            player.setData(ModAttachments.PLAYER_VARIABLE, (Object)cap);
            cap.sync((Entity)player);
            level.playSound(null, player.blockPosition(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (info.isDrop()) {
                stack.shrink(1);
            }
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    private static List<String> generateAmmoTypeList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("All");
        for (Ammo ammoType : Ammo.values()) {
            list.add(ammoType.serializationName);
        }
        return list;
    }

    @ParametersAreNonnullByDefault
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isCrouching() && player instanceof ServerPlayer) {
            AmmoBoxInfo info;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AmmoBoxInfo ammoBoxInfo = info = stack.get(ModDataComponents.AMMO_BOX_INFO) == null ? new AmmoBoxInfo("All", false) : (AmmoBoxInfo)stack.get(ModDataComponents.AMMO_BOX_INFO);
            assert (info != null);
            if (info.isDrop()) {
                return false;
            }
            int index = Math.max(0, AMMO_TYPE_LIST.indexOf(info.type()));
            String typeString = AMMO_TYPE_LIST.get((index + 1) % AMMO_TYPE_LIST.size());
            stack.set(ModDataComponents.AMMO_BOX_INFO, (Object)new AmmoBoxInfo(typeString, false));
            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.FIRE_RATE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            Ammo type = Ammo.getType(typeString);
            if (type == null) {
                player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.ammo_box.type.all").withStyle(ChatFormatting.WHITE), true);
                return true;
            }
            player.displayClientMessage((Component)Component.translatable((String)("des.superbwarfare.ammo_box.type." + type.name)).withStyle(type.color), true);
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        AmmoBoxInfo info = (AmmoBoxInfo)stack.get(ModDataComponents.AMMO_BOX_INFO);
        if (info == null) {
            info = new AmmoBoxInfo("All", false);
        }
        Ammo type = Ammo.getType(info.type());
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.ammo_box").withStyle(ChatFormatting.GRAY));
        for (Ammo ammo : Ammo.values()) {
            tooltipComponents.add((Component)Component.translatable((String)("des.superbwarfare.ammo_box." + ammo.name)).withStyle(ammo.color).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(FormatTool.format0D(ammo.get(stack)) + (type != ammo ? " " : " \u2190-"))).withStyle(ChatFormatting.BOLD)));
        }
    }
}

