/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common.ammo;

import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AmmoSupplierItem
extends Item {
    public final Ammo type;
    public final int ammoToAdd;

    public AmmoSupplierItem(Ammo type, int ammoToAdd, Item.Properties properties) {
        super(properties);
        this.type = type;
        this.ammoToAdd = ammoToAdd;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.ammo_supplier").withStyle(ChatFormatting.AQUA));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack offhandItem;
        ItemStack stack = player.getItemInHand(hand);
        int count = stack.getCount();
        player.getCooldowns().addCooldown((Item)this, 10);
        if (!player.isCreative()) {
            stack.shrink(count);
        }
        if ((offhandItem = player.getOffhandItem()).is((Item)ModItems.AMMO_BOX.get())) {
            this.type.add(offhandItem, this.ammoToAdd * count);
        } else {
            PlayerVariable capability = ((PlayerVariable)player.getData(ModAttachments.PLAYER_VARIABLE)).watch();
            this.type.add(capability, this.ammoToAdd * count);
            player.setData(ModAttachments.PLAYER_VARIABLE, (Object)capability);
            capability.sync((Entity)player);
        }
        if (!level.isClientSide()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.superbwarfare.ammo_supplier.supply", (Object[])new Object[]{Component.translatable((String)this.type.translationKey), this.ammoToAdd * count}), true);
            level.playSound(null, player.blockPosition(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

