/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common.container;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.item.SmallContainerBlockItemRenderer;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModItems;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class SmallContainerBlockItem
extends BlockItem
implements GeoItem {
    public static final List<Supplier<ItemStack>> SMALL_CONTAINERS = List.of(() -> SmallContainerBlockItem.createInstance(Mod.loc("containers/blueprints")), () -> SmallContainerBlockItem.createInstance(Mod.loc("containers/common")));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SmallContainerBlockItem() {
        super((Block)ModBlocks.SMALL_CONTAINER.get(), new Item.Properties().stacksTo(1).fireResistant());
    }

    @ParametersAreNonnullByDefault
    public boolean canBeHurtBy(ItemStack stack, DamageSource source) {
        return super.canBeHurtBy(stack, source) && !source.is(DamageTypeTags.IS_EXPLOSION) && !source.is(DamageTypes.CACTUS);
    }

    private PlayState predicate(AnimationState<SmallContainerBlockItem> event) {
        return PlayState.CONTINUE;
    }

    @SubscribeEvent
    private static void registerArmorExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new SmallContainerBlockItemRenderer();

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        }, new Holder[]{ModItems.SMALL_CONTAINER});
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static ItemStack createInstance(ResourceLocation lootTable) {
        return SmallContainerBlockItem.createInstance((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable), 0L);
    }

    public static ItemStack createInstance(ResourceKey<LootTable> lootTable, long lootTableSeed) {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.SMALL_CONTAINER.get());
        stack.set(DataComponents.CONTAINER_LOOT, (Object)new SeededContainerLoot(lootTable, lootTableSeed));
        return stack;
    }
}

