/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.launcher;

import com.atsuishio.superbwarfare.client.renderer.gun.JavelinItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.entity.projectile.JavelinMissileEntity;
import com.atsuishio.superbwarfare.init.ModEnumExtensions;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.network.message.receive.ShootClientMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class JavelinItem
extends GunGeoItem {
    public JavelinItem() {
        super(new Item.Properties().rarity(ModEnumExtensions.getLegendary()));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return JavelinItemRenderer::new;
    }

    @Override
    public boolean useSpecialFireProcedure(GunData data) {
        return true;
    }

    @Override
    public void shoot(@NotNull ShootParameters parameters) {
        GunData data = parameters.data();
        Entity shooter = parameters.shooter();
        UUID targetUUID = parameters.targetEntityUUID();
        Vec3 targetPos = parameters.targetPos();
        boolean zoom = parameters.zoom();
        if (shooter == null) {
            return;
        }
        if (!zoom || !data.hasEnoughAmmoToShoot(shooter)) {
            return;
        }
        Level level = shooter.level();
        float yRot = shooter.getYRot() + 360.0f;
        yRot = (yRot + 90.0f) % 360.0f;
        Vector3d firePos = new Vector3d(0.0, -0.2, 0.15);
        firePos.rotateZ((double)(-shooter.getXRot() * ((float)Math.PI / 180)));
        firePos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Level level2 = shooter.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            Entity targetEntity = EntityFindUtil.findEntity((Level)serverLevel, String.valueOf(targetUUID));
            int guideType = targetEntity == null ? 1 : 0;
            JavelinMissileEntity missileEntity = new JavelinMissileEntity(shooter, level, (float)data.compute().damage, (float)data.compute().explosionDamage, (float)data.compute().explosionRadius, guideType, targetPos);
            for (Perk.Type type : Perk.Type.values()) {
                PerkInstance instance = data.perk.getInstance(type);
                if (instance == null) continue;
                instance.perk().modifyProjectile(data, instance, (Entity)missileEntity);
            }
            missileEntity.setPos(shooter.getX() + firePos.x, shooter.getEyeY() + firePos.y, shooter.getZ() + firePos.z);
            missileEntity.shoot(shooter.getLookAngle().x, shooter.getLookAngle().y + 0.3, shooter.getLookAngle().z, 3.0f, 1.0f);
            if (targetEntity != null) {
                missileEntity.setTargetUuid(targetEntity.getStringUUID());
            }
            missileEntity.setAttackMode(data.selectedFireModeInfo().name.equals("Top"));
            level.addFreshEntity((Entity)missileEntity);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, shooter.getX() + 1.8 * shooter.getLookAngle().x, shooter.getY() + (double)shooter.getBbHeight() - 0.1 + 1.8 * shooter.getLookAngle().y, shooter.getZ() + 1.8 * shooter.getLookAngle().z, 30, 0.4, 0.4, 0.4, 0.005, true);
            if (shooter instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)shooter;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.JAVELIN_FIRE_1P.get(), 2.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShootClientMessage(10.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            SoundTool.playDistantSound(serverLevel, (SoundEvent)ModSounds.JAVELIN_FIRE_3P.get(), shooter.position(), 4.0f, 1.0f, shooter);
            SoundTool.playDistantSound(serverLevel, (SoundEvent)ModSounds.JAVELIN_FAR.get(), shooter.position(), 10.0f, 1.0f, shooter);
        }
        data.ammo.set(data.ammo.get() - data.compute().ammoCostPerShoot);
        data.save();
    }
}

