/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.special;

import com.atsuishio.superbwarfare.client.renderer.gun.BocekItemRenderer;
import com.atsuishio.superbwarfare.client.tooltip.component.BocekImageComponent;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.receive.ShootClientMessage;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class BocekItem
extends GunGeoItem {
    public BocekItem() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return BocekItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        if (ClientEventHandler.bowPull) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bocek.pull"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.noSprintTicks == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    private PlayState firePredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        GunData data = GunData.from(stack);
        if (data.reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.bocek.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    private PlayState reloadPredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        GunData data = GunData.from(stack);
        if (data.reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.bocek.reload"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(idleController);
        AnimationController fireController = new AnimationController((GeoAnimatable)this, "fireController", 0, this::firePredicate);
        data.add(fireController);
        AnimationController reloadController = new AnimationController((GeoAnimatable)this, "reloadController", 0, this::reloadPredicate);
        data.add(reloadController);
    }

    @Override
    public boolean useSpecialFireProcedure(GunData data) {
        return true;
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new BocekImageComponent(pStack));
    }

    @Override
    public void shoot(@NotNull ShootParameters parameters) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onFireKeyRelease(GunData data, Player player, double power, boolean zoom) {
        block7: {
            block9: {
                block8: {
                    super.onFireKeyRelease(data, player, power, zoom);
                    if (!data.hasEnoughAmmoToShoot((Entity)player)) {
                        return;
                    }
                    perk = data.perk.get(Perk.Type.AMMO);
                    if (player instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)player;
                        SoundTool.stopSound(serverPlayer, ModSounds.BOCEK_PULL_1P.getId(), SoundSource.PLAYERS);
                        SoundTool.stopSound(serverPlayer, ModSounds.BOCEK_PULL_3P.getId(), SoundSource.PLAYERS);
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShootClientMessage(10.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    if (!(power * 12.0 >= 6.0)) break block7;
                    if (!zoom) break block8;
                    this.spawnBullet(data, player, power, true);
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.BOCEK_ZOOM_FIRE_1P.get(), 10.0f, 1.0f);
                    player.playSound((SoundEvent)ModSounds.BOCEK_ZOOM_FIRE_3P.get(), 2.0f, 1.0f);
                    break block9;
                }
                i = 0;
                while (true) {
                    if (!(perk instanceof AmmoPerk)) ** GOTO lbl-1000
                    ammoPerk = (AmmoPerk)perk;
                    if (ammoPerk.slug) {
                        v0 = 1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = 10;
                    }
                    if (i >= v0) break;
                    this.spawnBullet(data, player, power, false);
                    ++i;
                }
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.BOCEK_SHATTER_CAP_FIRE_1P.get(), 10.0f, 1.0f);
                player.playSound((SoundEvent)ModSounds.BOCEK_SHATTER_CAP_FIRE_3P.get(), 2.0f, 1.0f);
            }
            if (perk == ModPerks.BEAST_BULLET.get()) {
                player.playSound((SoundEvent)ModSounds.HENG.get(), 4.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.HENG.get(), 4.0f, 1.0f);
                }
            }
            data.ammo.set(data.ammo.get() - data.compute().ammoCostPerShoot);
            data.save();
        }
    }

    public void spawnBullet(GunData data, Player player, double power, boolean zoom) {
        ItemStack stack = data.stack;
        DefaultGunData computed = data.compute();
        float headshot = (float)computed.headshot;
        float velocity = (float)(computed.velocity * power);
        float bypassArmorRate = (float)computed.bypassesArmor;
        float explosionRadius = (float)computed.explosionRadius;
        float explosionDamage = (float)computed.explosionDamage;
        int projectileAmount = computed.projectileAmount;
        double damage = computed.damage * power;
        float spread = 0.01f;
        if (!zoom) {
            spread = projectileAmount <= 1 ? 0.5f : 2.5f;
            damage /= (double)Math.max(1, projectileAmount);
        }
        ProjectileEntity projectile = new ProjectileEntity(player.level()).shooter((Entity)player).headShot(headshot).zoom(zoom).bypassArmorRate(bypassArmorRate).velocity(velocity).setGunItemId(stack);
        projectile.setExplosionDamage(explosionDamage);
        projectile.setExplosionRadius(explosionRadius);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().modifyProjectile(data, instance, (Entity)projectile);
        }
        projectile.setPos(player.getX() - 0.1 * player.getLookAngle().x, player.getEyeY() - 0.1 - 0.1 * player.getLookAngle().y, player.getZ() + -0.1 * player.getLookAngle().z);
        projectile.shoot((LivingEntity)player, player.getLookAngle().x, player.getLookAngle().y, player.getLookAngle().z, velocity, spread);
        projectile.damage((float)damage);
        player.level().addFreshEntity((Entity)projectile);
    }
}

