/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.entity.vehicle.VehicleAssemblingTableVehicleEntity;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.network.message.receive.FinishAssemblingVehicleMessage;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingIngredient;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipe;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleAssemblingMenu
extends AbstractContainerMenu {
    private final boolean isVehicleMenu;
    protected final ContainerLevelAccess access;

    public VehicleAssemblingMenu(int pContainerId, Inventory inventory) {
        this(pContainerId, inventory, ContainerLevelAccess.NULL);
    }

    public VehicleAssemblingMenu(int pContainerId, Inventory inventory, ContainerLevelAccess access) {
        this(pContainerId, inventory, access, false);
    }

    public VehicleAssemblingMenu(int pContainerId, Inventory inventory, ContainerLevelAccess access, boolean isVehicleMenu) {
        super(ModMenuTypes.VEHICLE_ASSEMBLING_MENU.get(), pContainerId);
        this.isVehicleMenu = isVehicleMenu;
        this.access = access;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int pIndex) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player pPlayer) {
        return pPlayer.isAlive() && !this.isVehicleMenu && (Boolean)this.access.evaluate((level, pos) -> level.getBlockState(pos).is((Block)ModBlocks.VEHICLE_ASSEMBLING_TABLE.get()) && pPlayer.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true) != false || this.isVehicleMenu && pPlayer.getVehicle() instanceof VehicleAssemblingTableVehicleEntity;
    }

    public void assembleVehicle(ResourceLocation id, ServerPlayer player) {
        VehicleAssemblingRecipe recipe = this.getRecipeById(id, player.level().getRecipeManager());
        if (recipe == null) {
            return;
        }
        IItemHandler handler = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
        if (handler != null) {
            if (!player.isCreative()) {
                Int2IntArrayMap recordCount = new Int2IntArrayMap();
                List<VehicleAssemblingIngredient> ingredients = recipe.getInputs();
                for (VehicleAssemblingIngredient ingredient : ingredients) {
                    int count = 0;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        int stackCount = stack.getCount();
                        if (stack.isEmpty() || !ingredient.getIngredient().test(stack)) continue;
                        if ((count += stackCount) > ingredient.getCount()) {
                            int remaining = count - ingredient.getCount();
                            recordCount.put(i, stackCount - remaining);
                            break;
                        }
                        recordCount.put(i, stackCount);
                    }
                    if (count >= ingredient.getCount()) continue;
                    return;
                }
                IntIterator intIterator = recordCount.keySet().iterator();
                while (intIterator.hasNext()) {
                    int slotIndex = (Integer)intIterator.next();
                    handler.extractItem(slotIndex, recordCount.get(slotIndex), false);
                }
            }
            Level level = player.level();
            if (!level.isClientSide) {
                ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY() + 0.5, player.getZ(), recipe.getResultItem((HolderLookup.Provider)player.level().registryAccess()).copy());
                itemEntity.setPickUpDelay(0);
                level.addFreshEntity((Entity)itemEntity);
            }
            player.inventoryMenu.broadcastFullState();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new FinishAssemblingVehicleMessage(this.containerId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Nullable
    public VehicleAssemblingRecipe getRecipeById(ResourceLocation id, RecipeManager recipeManager) {
        RecipeHolder recipe = recipeManager.byKey(id).orElse(null);
        if (recipe == null) {
            return null;
        }
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof VehicleAssemblingRecipe) {
            VehicleAssemblingRecipe assemblingRecipe = (VehicleAssemblingRecipe)recipe2;
            return assemblingRecipe;
        }
        return null;
    }
}

