/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeatInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Shadow
    @Final
    private Camera mainCamera;

    @Inject(method={"bobView(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void bobView(PoseStack p_109139_, float p_109140_, CallbackInfo ci) {
        ItemStack stack;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && (stack = player.getMainHandItem()).getItem() instanceof GunItem && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
            ci.cancel();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V")})
    public void superbWarfare$renderWorld(DeltaTracker deltaTracker, CallbackInfo ci, @Local(name={"posestack"}) PoseStack matrices, @Local(name={"f"}) float tickDelta) {
        Entity shakeStrength2;
        Player player;
        Entity entity = this.mainCamera.getEntity();
        matrices.mulPose(Axis.ZP.rotationDegrees(ClientEventHandler.cameraRoll));
        if (entity instanceof Player && !(player = (Player)entity).isSpectator() && player.hasEffect(ModMobEffects.SHOCK)) {
            float shakeStrength2 = (float)((Integer)DisplayConfig.SHOCK_SCREEN_SHAKE.get()).intValue() / 100.0f;
            if (shakeStrength2 <= 0.0f) {
                return;
            }
            matrices.mulPose(Axis.ZP.rotationDegrees((float)Mth.nextDouble((RandomSource)RandomSource.create(), (double)8.0, (double)12.0) * shakeStrength2));
        }
        if (entity != null && (shakeStrength2 = entity.getRootVehicle()) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)shakeStrength2;
            if (!this.mainCamera.isDetached() || ClientEventHandler.zoomVehicle) {
                float a = Mth.wrapDegrees((float)(this.mainCamera.getYRot() - Mth.lerp((float)tickDelta, (float)vehicle.yRotO, (float)vehicle.getYRot())));
                List<SeatInfo> seats = VehicleData.compute(vehicle).seats();
                int index = vehicle.getSeatIndex(entity);
                if (index < 0 || index >= seats.size()) {
                    return;
                }
                SeatInfo seat = seats.get(index);
                if (seat.transform.equals("VehicleFlat")) {
                    a = 0.0f;
                }
                float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
                float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
                matrices.mulPose(Axis.ZP.rotationDegrees(-r * vehicle.getRoll(tickDelta) - r2 * vehicle.getViewXRot(tickDelta)));
                if (!vehicle.useFixedCameraPos(entity)) {
                    float eye = entity.getEyeHeight();
                    Vector3f offset = new Vector3f(0.0f, -eye, 0.0f);
                    Quaternionf quaternion = Axis.XP.rotationDegrees(0.0f);
                    quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(-vehicle.getViewYRot(tickDelta)));
                    quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(vehicle.getViewXRot(tickDelta)));
                    quaternion.mul((Quaternionfc)Axis.ZP.rotationDegrees(vehicle.getRoll(tickDelta)));
                    offset.rotate((Quaternionfc)quaternion);
                    matrices.mulPose(Axis.XP.rotationDegrees(this.mainCamera.getXRot()));
                    matrices.mulPose(Axis.YP.rotationDegrees(this.mainCamera.getYRot() + 180.0f));
                    matrices.translate(offset.x(), offset.y() + eye, offset.z());
                    matrices.mulPose(Axis.YP.rotationDegrees(-this.mainCamera.getYRot() - 180.0f));
                    matrices.mulPose(Axis.XP.rotationDegrees(-this.mainCamera.getXRot()));
                }
            }
        }
    }
}

