/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class MultiPlayerGameModeMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"isServerControlledInventory"}, at={@At(value="HEAD")}, cancellable=true)
    public void isServerControlledInventory(CallbackInfoReturnable<Boolean> cir) {
        Entity entity;
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        if (player.isPassenger() && (entity = player.getVehicle()) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            cir.setReturnValue((Object)vehicle.hasMenu());
        }
    }
}

