/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record AdjustZoomFovMessage(double scroll) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AdjustZoomFovMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("adjust_zoom_fov"));
    public static final StreamCodec<ByteBuf, AdjustZoomFovMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, AdjustZoomFovMessage::scroll, AdjustZoomFovMessage::new);

    public static void handler(AdjustZoomFovMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData gun = GunData.from(stack);
        CompoundTag data = gun.data();
        if (stack.is((Item)ModItems.MINIGUN.get())) {
            double minRpm = -900.0;
            double maxRpm = 1200.0;
            int customRPM = data.getInt("CustomRPM");
            int targetCustomRPM = (int)Mth.clamp((double)((double)customRPM + 50.0 * message.scroll), (double)minRpm, (double)maxRpm);
            targetCustomRPM = targetCustomRPM == -50 ? -55 : Math.toIntExact(Math.round((double)targetCustomRPM / 50.0) * 50L);
            data.putInt("CustomRPM", targetCustomRPM);
            player.displayClientMessage((Component)Component.literal((String)("RPM: " + FormatTool.format0D(customRPM + 1200))), true);
            if ((double)customRPM > minRpm && (double)customRPM < maxRpm) {
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.ADJUST_FOV.get(), 1.0f, 0.7f);
            }
        } else {
            double minZoom = gun.minZoom() - 1.25;
            double maxZoom = gun.maxZoom() - 1.25;
            double customZoom = data.getDouble("CustomZoom");
            data.putDouble("CustomZoom", Mth.clamp((double)(customZoom + 0.5 * message.scroll), (double)minZoom, (double)maxZoom));
            if (customZoom > minZoom && customZoom < maxZoom) {
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.ADJUST_FOV.get(), 1.0f, 0.7f);
            }
        }
        gun.save();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

