/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.menu.VehicleAssemblingMenu;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record AssembleVehicleMessage(ResourceLocation id, int containerId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AssembleVehicleMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("assemble_vehicle"));
    public static final StreamCodec<ByteBuf, AssembleVehicleMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, AssembleVehicleMessage::id, (StreamCodec)ByteBufCodecs.INT, AssembleVehicleMessage::containerId, AssembleVehicleMessage::new);

    public static void handler(AssembleVehicleMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        if (player.containerMenu.containerId != message.containerId) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof VehicleAssemblingMenu) {
            VehicleAssemblingMenu menu = (VehicleAssemblingMenu)abstractContainerMenu;
            menu.assembleVehicle(message.id, player);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

