/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.item.FiringParameters;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record FiringParametersEditMessage(int x, int y, int z, int radius, boolean isDepressed, boolean mainHand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FiringParametersEditMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("firing_parameters_edit"));
    public static final StreamCodec<ByteBuf, FiringParametersEditMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, FiringParametersEditMessage::x, (StreamCodec)ByteBufCodecs.INT, FiringParametersEditMessage::y, (StreamCodec)ByteBufCodecs.INT, FiringParametersEditMessage::z, (StreamCodec)ByteBufCodecs.INT, FiringParametersEditMessage::radius, (StreamCodec)ByteBufCodecs.BOOL, FiringParametersEditMessage::isDepressed, (StreamCodec)ByteBufCodecs.BOOL, FiringParametersEditMessage::mainHand, FiringParametersEditMessage::new);

    public static void handler(FiringParametersEditMessage message, IPayloadContext context) {
        ItemStack stack;
        Player player = context.player();
        ItemStack itemStack = stack = message.mainHand ? player.getMainHandItem() : player.getOffhandItem();
        if (!stack.is((Item)ModItems.FIRING_PARAMETERS.get()) && !stack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
            return;
        }
        FiringParameters.Parameters parameters = new FiringParameters.Parameters(new BlockPos(message.x, message.y, message.z), message.radius, message.isDepressed);
        stack.set(ModDataComponents.FIRING_PARAMETERS, (Object)parameters);
        Item item = stack.getItem();
        if (item instanceof ArtilleryIndicator) {
            ArtilleryIndicator indicator = (ArtilleryIndicator)item;
            indicator.setTarget(stack, player);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

