/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public record MeleeAttackMessage(UUID uuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MeleeAttackMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("melee_attack"));
    public static final StreamCodec<ByteBuf, MeleeAttackMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, MeleeAttackMessage::uuid, MeleeAttackMessage::new);

    public static void handler(MeleeAttackMessage message, IPayloadContext context) {
        Player player = context.player();
        Entity lookingEntity = EntityFindUtil.findEntity(player.level(), String.valueOf(message.uuid));
        if (lookingEntity != null) {
            player.level().playSound(null, lookingEntity.getOnPos(), (SoundEvent)ModSounds.MELEE_HIT.get(), SoundSource.PLAYERS, 1.0f, (float)((2.0 * Math.random() - 1.0) * (double)0.1f + 1.0));
            player.attack(lookingEntity);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

