/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MouseMoveMessage(double speedX, double speedY) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MouseMoveMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("mouse_move"));
    public static final StreamCodec<ByteBuf, MouseMoveMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, MouseMoveMessage::speedX, (StreamCodec)ByteBufCodecs.DOUBLE, MouseMoveMessage::speedY, MouseMoveMessage::new);

    public static void handler(MouseMoveMessage message, IPayloadContext context) {
        DroneEntity drone;
        Player player = context.player();
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            vehicle.mouseInput(message.speedX, message.speedY);
        }
        ItemStack stack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked") && (drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"))) != null) {
            drone.mouseInput(message.speedX, message.speedY);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

