/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.NBTTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public enum ParachuteMessage implements CustomPacketPayload
{
    INSTANCE;

    public static final CustomPacketPayload.Type<ParachuteMessage> TYPE;
    public static final StreamCodec<ByteBuf, ParachuteMessage> STREAM_CODEC;

    public static void handler(IPayloadContext context) {
        Player player = context.player();
        CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(c -> c.findFirstCurio((Item)ModItems.PARACHUTE.get())).ifPresent(s -> {
            ItemStack stack = s.stack();
            if (!player.getCooldowns().isOnCooldown(stack.getItem())) {
                CompoundTag tag = NBTTool.getTag(stack);
                if (!tag.getBoolean("Open") && player.getDeltaMovement().y < -0.6 && player.fallDistance > 4.0f) {
                    tag.putBoolean("Open", true);
                    NBTTool.saveTag(stack, tag);
                    player.getCooldowns().addCooldown(stack.getItem(), 10);
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.PARACHUTE_OPEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else if (tag.getBoolean("Open")) {
                    tag.putBoolean("Open", false);
                    NBTTool.saveTag(stack, tag);
                    player.getCooldowns().addCooldown(stack.getItem(), 10);
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.PARACHUTE_CLOSE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        TYPE = new CustomPacketPayload.Type(Mod.loc("parachute"));
        STREAM_CODEC = StreamCodec.unit((Object)((Object)INSTANCE));
    }
}

