/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientSetMotionMessage;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PlayerStopRidingMessage(boolean ejection) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerStopRidingMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("player_stop_riding"));
    public static final StreamCodec<ByteBuf, PlayerStopRidingMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PlayerStopRidingMessage::ejection, PlayerStopRidingMessage::new);

    public static void handler(PlayerStopRidingMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            if (message.ejection) {
                Vec3 vec = vehicle.getEjectionMovement((LivingEntity)player, vehicle.getTagSeatIndex((Entity)player));
                Vec3 pos = vehicle.getEjectionPosition((LivingEntity)player, vehicle.getTagSeatIndex((Entity)player));
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.MEDIUM_ROCKET_FIRE.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
                Level level = player.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int p = 0; p < 8; ++p) {
                        Vec3 pPos = player.position().add(vec.scale((double)p * 0.5));
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, pPos.x, pPos.y, pPos.z, 10, 0.5, 0.5, 0.5, 0.05, true);
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.FLAME, pPos.x, pPos.y, pPos.z, 20, 0.5, 0.5, 0.5, 0.05, true);
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, pPos.x, pPos.y, pPos.z, 15, 0.5, 0.5, 0.5, 0.05, true);
                    }
                }
                Mod.queueServerWork(1, () -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientSetMotionMessage(vec.toVector3f(), pos.toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]));
            }
            player.stopRiding();
            player.setJumping(false);
            player.addEffect(new MobEffectInstance(ModMobEffects.STRIKE_PROTECTION, 10, 0, false, false), (Entity)player);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

