/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimableEntity;
import com.atsuishio.superbwarfare.menu.FuMO25Menu;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RadarSetTargetMessage(UUID target) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RadarSetTargetMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("radar_set_target"));
    public static final StreamCodec<ByteBuf, RadarSetTargetMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, RadarSetTargetMessage::target, RadarSetTargetMessage::new);

    public static void handler(RadarSetTargetMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        AbstractContainerMenu menu = player.containerMenu;
        if (menu instanceof FuMO25Menu) {
            FuMO25Menu fuMO25Menu = (FuMO25Menu)menu;
            if (!player.containerMenu.stillValid((Player)player)) {
                return;
            }
            fuMO25Menu.getSelfPos().ifPresent(pos -> {
                List<Entity> entities = StreamSupport.stream(EntityFindUtil.getEntities(player.level()).getAll().spliterator(), false).filter(e -> {
                    AutoAimableEntity autoAimableEntity;
                    return e instanceof AutoAimableEntity && (autoAimableEntity = (AutoAimableEntity)e).getOwner() == player && autoAimableEntity.distanceTo((Entity)player) <= 24.0f;
                }).toList();
                entities.forEach(e -> e.getEntityData().set(AutoAimableEntity.TARGET_UUID, (Object)message.target.toString()));
            });
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

