/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SeekingWeaponWarningMessage(boolean lockOn, UUID uuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SeekingWeaponWarningMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("seeking_weapon_warning"));
    public static final StreamCodec<ByteBuf, SeekingWeaponWarningMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SeekingWeaponWarningMessage::lockOn, (StreamCodec)UUIDUtil.STREAM_CODEC, SeekingWeaponWarningMessage::uuid, SeekingWeaponWarningMessage::new);

    public static void handler(SeekingWeaponWarningMessage message, IPayloadContext context) {
        Player player = context.player();
        Entity entity = EntityFindUtil.findEntity(player.level(), String.valueOf(message.uuid));
        if (entity != null) {
            entity.level().playSound(null, entity.getOnPos(), entity instanceof Pig ? SoundEvents.PIG_HURT : (message.lockOn ? (SoundEvent)ModSounds.LOCKED_WARNING.get() : (SoundEvent)ModSounds.LOCKING_WARNING.get()), SoundSource.PLAYERS, 2.0f, 1.0f);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

