/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public enum SetFiringParametersMessage implements CustomPacketPayload
{
    INSTANCE;

    public static final CustomPacketPayload.Type<SetFiringParametersMessage> TYPE;
    public static final StreamCodec<ByteBuf, SetFiringParametersMessage> STREAM_CODEC;

    public static void handler(IPayloadContext context) {
        Item isDepressed2;
        Player player = context.player();
        ItemStack stack = player.getOffhandItem();
        ItemStack mainStack = player.getMainHandItem();
        boolean lookAtEntity = false;
        Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, 520.0);
        BlockHitResult result = player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(player.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 hitPos = result.getLocation();
        if (lookingEntity != null && !player.isShiftKeyDown()) {
            lookAtEntity = true;
        }
        if (stack.is((Item)ModItems.FIRING_PARAMETERS.get())) {
            int radius;
            FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
            boolean isDepressed2 = parameters != null && parameters.isDepressed();
            int n = radius = parameters != null ? parameters.radius() : 0;
            if (lookAtEntity) {
                stack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters(lookingEntity.blockPosition(), radius, isDepressed2));
            } else {
                stack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters(new BlockPos((int)hitPos.x, (int)hitPos.y, (int)hitPos.z), radius, isDepressed2));
            }
            BlockPos pos = Objects.requireNonNull((FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS)).pos();
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.mortar.target_pos").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("[" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + "]"))), true);
        }
        if ((isDepressed2 = mainStack.getItem()) instanceof ArtilleryIndicator) {
            ArtilleryIndicator indicator = (ArtilleryIndicator)isDepressed2;
            BlockPos pos = lookAtEntity ? lookingEntity.blockPosition() : new BlockPos((int)hitPos.x, (int)hitPos.y, (int)hitPos.z);
            FiringParameters.Parameters parameters = (FiringParameters.Parameters)mainStack.get(ModDataComponents.FIRING_PARAMETERS);
            boolean isDepressed3 = parameters != null && parameters.isDepressed();
            int radius = parameters != null ? parameters.radius() : 0;
            mainStack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters(pos, radius, isDepressed3));
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.mortar.target_pos").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("[" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + "]"))), true);
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_IN.get(), 2.0f, 1.0f);
            indicator.setTarget(mainStack, player);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        TYPE = new CustomPacketPayload.Type(Mod.loc("set_firing_parameters"));
        STREAM_CODEC = StreamCodec.unit((Object)((Object)INSTANCE));
    }
}

