/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record VehicleFireMessage(Optional<UUID> uuid, Optional<Vector3f> targetPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VehicleFireMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("vehicle_fire"));
    public static final StreamCodec<ByteBuf, VehicleFireMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), VehicleFireMessage::uuid, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VECTOR3F), VehicleFireMessage::targetPos, VehicleFireMessage::new);

    public static void handler(VehicleFireMessage message, IPayloadContext context) {
        Player player = context.player();
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            if (message.targetPos.isPresent()) {
                vehicle.vehicleShoot((LivingEntity)player, message.uuid.orElse(null), new Vec3(message.targetPos.get()));
            } else {
                vehicle.vehicleShoot((LivingEntity)player, message.uuid.orElse(null), null);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

