/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.functional;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;

public class FieldDoctor
extends Perk {
    public FieldDoctor() {
        super("field_doctor", Perk.Type.FUNCTIONAL);
    }

    @Override
    public void onHurtEntity(float damage, GunData data, PerkInstance instance, Entity target, DamageSource source) {
        super.onHurtEntity(damage, data, instance, target, source);
        if (!this.trigger(target, source)) {
            return;
        }
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.heal(damage * Math.min(1.0f, 0.25f + 0.05f * (float)instance.level()));
        }
    }

    public boolean trigger(Entity target, DamageSource source) {
        ProjectileEntity projectile;
        Entity entity = source.getDirectEntity();
        if (entity instanceof ProjectileEntity && !(projectile = (ProjectileEntity)entity).isZoom()) {
            OwnableEntity ownableEntity;
            Entity player;
            LivingEntity living;
            LivingEntity attacker = null;
            Entity entity2 = source.getEntity();
            if (entity2 instanceof LivingEntity) {
                living = (LivingEntity)entity2;
                if (living instanceof ServerPlayer) {
                    player = (ServerPlayer)living;
                    attacker = player;
                } else {
                    attacker = living;
                }
            }
            if ((player = projectile.getOwner()) instanceof LivingEntity) {
                OwnableEntity ownableEntity2;
                living = (LivingEntity)player;
                if (living instanceof ServerPlayer) {
                    player = (ServerPlayer)living;
                    attacker = player;
                } else if (living instanceof OwnableEntity && (ownableEntity2 = (OwnableEntity)living).getOwner() instanceof ServerPlayer) {
                    attacker = living;
                }
            }
            return attacker != null && target != null && (target.isAlliedTo((Entity)attacker) || attacker instanceof OwnableEntity && (ownableEntity = (OwnableEntity)attacker) == target);
        }
        return false;
    }
}

