/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class VehicleResetRecipe
extends CustomRecipe {
    public VehicleResetRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level pLevel) {
        ItemStack kit = ItemStack.EMPTY;
        ItemStack container = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is((Item)ModItems.VEHICLE_RESET_KIT.get())) {
                if (!kit.isEmpty()) {
                    return false;
                }
                kit = stack;
                continue;
            }
            if (!stack.is((Item)ModItems.CONTAINER.get())) continue;
            if (!container.isEmpty()) {
                return false;
            }
            container = stack;
        }
        return !kit.isEmpty() && !container.isEmpty();
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack kit = ItemStack.EMPTY;
        ItemStack container = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is((Item)ModItems.VEHICLE_RESET_KIT.get())) {
                if (!kit.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                kit = stack.copy();
                continue;
            }
            if (!stack.is((Item)ModItems.CONTAINER.get())) continue;
            if (!container.isEmpty()) {
                return ItemStack.EMPTY;
            }
            container = stack.copy();
        }
        if (!kit.isEmpty() && !container.isEmpty()) {
            String type;
            EntityType entityType;
            CompoundTag tag;
            CustomData data = (CustomData)container.get(DataComponents.BLOCK_ENTITY_DATA);
            CompoundTag compoundTag = tag = data != null ? data.copyTag() : new CompoundTag();
            if (tag.contains("EntityType") && (entityType = (EntityType)EntityType.byString((String)(type = tag.getString("EntityType"))).orElse(null)) != null) {
                return ContainerBlockItem.createInstance(entityType);
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.VEHICLE_RESET_SERIALIZER.get();
    }
}

