/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe.vehicle;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingIngredient;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class VehicleAssemblingRecipe
implements Recipe<RecipeWrapper> {
    private final Category category;
    private final VehicleAssemblingResult result;
    private final List<VehicleAssemblingIngredient> inputs;

    public VehicleAssemblingRecipe(List<VehicleAssemblingIngredient> inputs, String recipeCategory, VehicleAssemblingResult result) {
        this.category = Category.valueOf(recipeCategory);
        this.result = result;
        this.inputs = inputs;
    }

    public VehicleAssemblingRecipe(List<VehicleAssemblingIngredient> inputs, Category recipeCategory, VehicleAssemblingResult result) {
        this.category = recipeCategory;
        this.result = result;
        this.inputs = inputs;
    }

    public static VehicleAssemblingRecipe create(Map<String, Integer> ingredients, Category recipeCategory, EntityType<?> type) {
        ArrayList<VehicleAssemblingIngredient> inputs = new ArrayList<VehicleAssemblingIngredient>();
        for (Map.Entry<String, Integer> entry : ingredients.entrySet()) {
            inputs.add(new VehicleAssemblingIngredient(entry.getKey(), entry.getValue()));
        }
        VehicleAssemblingResult result = new VehicleAssemblingResult(ModItems.CONTAINER.getId().toString(), BuiltInRegistries.ENTITY_TYPE.getKey(type).toString(), 1);
        return new VehicleAssemblingRecipe(inputs, recipeCategory, result);
    }

    public static VehicleAssemblingRecipe create(Map<String, Integer> ingredients, Category recipeCategory, Item result, int count) {
        ArrayList<VehicleAssemblingIngredient> inputs = new ArrayList<VehicleAssemblingIngredient>();
        for (Map.Entry<String, Integer> entry : ingredients.entrySet()) {
            inputs.add(new VehicleAssemblingIngredient(entry.getKey(), entry.getValue()));
        }
        return new VehicleAssemblingRecipe(inputs, recipeCategory, new VehicleAssemblingResult(BuiltInRegistries.ITEM.getKey((Object)result).toString(), "", count));
    }

    @ParametersAreNonnullByDefault
    public boolean matches(RecipeWrapper pContainer, Level pLevel) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack assemble(RecipeWrapper recipeWrapper, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.result.getResult().copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.VEHICLE_ASSEMBLING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.VEHICLE_ASSEMBLING_TYPE.get();
    }

    public Category getCategory() {
        return this.category;
    }

    public VehicleAssemblingResult getResult() {
        return this.result;
    }

    public List<VehicleAssemblingIngredient> getInputs() {
        return this.inputs;
    }

    public static enum Category {
        LAND("land"),
        DEFENSE("defense"),
        AIRCRAFT("aircraft"),
        CIVILIAN("civilian"),
        WATER("water"),
        MISC("misc");

        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Category getCategory(String name) {
            for (Category category : Category.values()) {
                if (!category.getName().equals(name)) continue;
                return category;
            }
            return MISC;
        }
    }
}

