/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.TagDataParser;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VehicleAssemblingResult {
    @SerializedName(value="item")
    public String itemString = "";
    @SerializedName(value="entity")
    public String entityTypeString = "";
    @SerializedName(value="count")
    public int count = 1;
    @SerializedName(value="nbt")
    public JsonObject nbt;
    public static final Codec<VehicleAssemblingResult> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("item", (Object)BuiltInRegistries.ITEM.getKey((Object)((Item)ModItems.CONTAINER.value())).toString()).forGetter(r -> r.itemString), (App)Codec.STRING.optionalFieldOf("entity", (Object)"").forGetter(r -> r.entityTypeString), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(r -> r.count)).apply((Applicative)builder, VehicleAssemblingResult::new)).codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, VehicleAssemblingResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.itemString, (StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.entityTypeString, (StreamCodec)ByteBufCodecs.VAR_INT, r -> r.count, VehicleAssemblingResult::new);
    public transient ItemStack result = null;

    public VehicleAssemblingResult() {
    }

    public VehicleAssemblingResult(String itemString, String entityTypeString, int count) {
        this.itemString = itemString;
        this.entityTypeString = entityTypeString;
        this.count = count;
    }

    public ItemStack getResult() {
        if (this.result != null) {
            return this.result;
        }
        if (!this.entityTypeString.isEmpty()) {
            EntityType type = EntityType.byString((String)this.entityTypeString).orElse(null);
            if (type == null) {
                Mod.LOGGER.warn("invalid entity type: {}", (Object)this.entityTypeString);
                this.result = ItemStack.EMPTY;
            } else {
                this.result = ContainerBlockItem.createInstance(type).copyWithCount(this.count);
            }
        } else if (!this.itemString.isEmpty()) {
            ResourceLocation location = ResourceLocation.parse((String)this.itemString);
            Item item = (Item)BuiltInRegistries.ITEM.get(location);
            if (this.nbt != null) {
                CompoundTag tag = TagDataParser.parse(this.nbt);
                tag.putString("id", location.toString());
                tag.putInt("count", 1);
                ItemStack.parse((HolderLookup.Provider)RegistryAccess.EMPTY, (Tag)tag).ifPresent(stack -> {
                    this.result = stack;
                });
            } else {
                this.result = new ItemStack((ItemLike)item, this.count);
            }
        } else {
            this.result = ItemStack.EMPTY;
        }
        return this.result;
    }
}

