/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.resource.vehicle;

import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.resource.vehicle.DefaultVehicleResource;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class VehicleResource
implements DefaultDataSupplier<DefaultVehicleResource> {
    public static final LoadingCache<VehicleEntity, VehicleResource> RESOURCE_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<VehicleEntity, VehicleResource>(){

        @NotNull
        public VehicleResource load(@NotNull VehicleEntity vehicle) {
            return new VehicleResource(vehicle);
        }
    });
    public final VehicleEntity vehicle;
    public final String id;
    private DefaultVehicleResource cache = null;

    private VehicleResource(VehicleEntity vehicle) {
        this.vehicle = vehicle;
        this.id = VehicleResource.getRegistryId(vehicle.getType());
    }

    public static DefaultVehicleResource compute(VehicleEntity vehicle) {
        return VehicleResource.from(vehicle).compute();
    }

    public DefaultVehicleResource compute() {
        DefaultVehicleResource defaultResource;
        if (this.cache != null) {
            return this.cache;
        }
        this.cache = defaultResource = (DefaultVehicleResource)this.getDefault().copy();
        return defaultResource;
    }

    public void update() {
        this.cache = null;
    }

    @Override
    public DefaultVehicleResource getDefault() {
        return VehicleResource.getDefault(this.id);
    }

    public static DefaultVehicleResource getDefault(String id) {
        return CustomData.VEHICLE_RESOURCE.getOrElseGet(id, DefaultVehicleResource::new);
    }

    public static DefaultVehicleResource getDefault(VehicleEntity vehicle) {
        return VehicleResource.getDefault(vehicle.getType());
    }

    public static DefaultVehicleResource getDefault(EntityType<?> type) {
        return VehicleResource.getDefault(VehicleResource.getRegistryId(type));
    }

    public static VehicleResource from(VehicleEntity stack) {
        return (VehicleResource)RESOURCE_CACHE.getUnchecked((Object)stack);
    }

    public static String getRegistryId(EntityType<?> type) {
        return EntityType.getKey(type).toString();
    }
}

