/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class NBTTool {
    public static CompoundTag getTag(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            return data.copyTag();
        }
        return new CompoundTag();
    }

    public static void saveTag(ItemStack stack, CompoundTag tag) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag oldTag = data != null ? data.copyTag() : new CompoundTag();
        CompoundTag newTag = oldTag.merge(tag);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)newTag));
    }

    public static ItemStack withTag(DeferredHolder<Item, ? extends Item> item, int count, Consumer<CompoundTag> setter) {
        return NBTTool.withTag(new ItemStack(item, count), setter);
    }

    public static ItemStack withTag(DeferredHolder<Item, ? extends Item> item, Consumer<CompoundTag> setter) {
        return NBTTool.withTag(item, 1, setter);
    }

    public static ItemStack withTag(ItemStack stack, Consumer<CompoundTag> setter) {
        CompoundTag tag = new CompoundTag();
        setter.accept(tag);
        NBTTool.saveTag(stack, tag);
        return stack;
    }
}

