/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectiond;
import org.joml.Math;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public record OBB(Vector3d center, Vector3d extents, Quaterniond rotation, Part part) {
    public void setCenter(Vector3d center) {
        this.center.set((Vector3dc)center);
    }

    public void setExtents(Vector3d extents) {
        this.extents.set((Vector3dc)extents);
    }

    public void setRotation(Quaterniond rotation) {
        this.rotation.set((Quaterniondc)rotation);
    }

    public int getEmbeddingFace(Vec3 vec3) {
        Vector3d rel = OBB.vec3ToVector3d(vec3).sub((Vector3dc)this.center);
        Vector3d[] axes = new Vector3d[]{this.rotation.transform(new Vector3d(1.0, 0.0, 0.0)), this.rotation.transform(new Vector3d(0.0, 1.0, 0.0)), this.rotation.transform(new Vector3d(0.0, 0.0, 1.0))};
        double projX = Math.abs((double)rel.dot((Vector3dc)axes[0]));
        double projY = Math.abs((double)rel.dot((Vector3dc)axes[1]));
        double projZ = Math.abs((double)rel.dot((Vector3dc)axes[2]));
        double min = Double.MAX_VALUE;
        int index = 0;
        double dx = this.extents.x - projX;
        double dy = this.extents.y - projY;
        double dz = this.extents.z - projZ;
        if (dx < min) {
            min = dx;
            index = 1;
        }
        if (dy < min) {
            min = dy;
            index = 2;
        }
        if (dz < min) {
            index = 3;
        }
        return index * (rel.dot((Vector3dc)axes[index - 1]) < 0.0 ? -1 : 1);
    }

    public double getEmbeddingDepth(Vec3 vec3) {
        Vector3d rel = OBB.vec3ToVector3d(vec3).sub((Vector3dc)this.center);
        Vector3d[] axes = new Vector3d[]{this.rotation.transform(new Vector3d(1.0, 0.0, 0.0)), this.rotation.transform(new Vector3d(0.0, 1.0, 0.0)), this.rotation.transform(new Vector3d(0.0, 0.0, 1.0))};
        double projX = Math.abs((double)rel.dot((Vector3dc)axes[0]));
        double projY = Math.abs((double)rel.dot((Vector3dc)axes[1]));
        double projZ = Math.abs((double)rel.dot((Vector3dc)axes[2]));
        double dx = this.extents.x - projX;
        double dy = this.extents.y - projY;
        double dz = this.extents.z - projZ;
        double minDepth = Double.MAX_VALUE;
        if (Math.abs((double)dx) < Math.abs((double)minDepth)) {
            minDepth = dx;
        }
        if (Math.abs((double)dy) < Math.abs((double)minDepth)) {
            minDepth = dy;
        }
        if (Math.abs((double)dz) < Math.abs((double)minDepth)) {
            minDepth = dz;
        }
        return minDepth;
    }

    public Vector3d[] getVertices() {
        Vector3d[] vertices = new Vector3d[8];
        Vector3d[] localVertices = new Vector3d[]{new Vector3d(-this.extents.x, -this.extents.y, -this.extents.z), new Vector3d(this.extents.x, -this.extents.y, -this.extents.z), new Vector3d(this.extents.x, this.extents.y, -this.extents.z), new Vector3d(-this.extents.x, this.extents.y, -this.extents.z), new Vector3d(-this.extents.x, -this.extents.y, this.extents.z), new Vector3d(this.extents.x, -this.extents.y, this.extents.z), new Vector3d(this.extents.x, this.extents.y, this.extents.z), new Vector3d(-this.extents.x, this.extents.y, this.extents.z)};
        for (int i = 0; i < 8; ++i) {
            Vector3d vertex = localVertices[i];
            vertex.rotate((Quaterniondc)this.rotation);
            vertex.add((Vector3dc)this.center);
            vertices[i] = vertex;
        }
        return vertices;
    }

    public Vector3d[] getAxes() {
        Vector3d[] axes = new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, 1.0)};
        this.rotation.transform(axes[0]);
        this.rotation.transform(axes[1]);
        this.rotation.transform(axes[2]);
        return axes;
    }

    public static boolean isColliding(OBB obb, OBB other) {
        Vector3d[] axes1 = obb.getAxes();
        Vector3d[] axes2 = other.getAxes();
        return Intersectiond.testObOb((Vector3d)obb.center(), (Vector3d)axes1[0], (Vector3d)axes1[1], (Vector3d)axes1[2], (Vector3d)obb.extents(), (Vector3d)other.center(), (Vector3d)axes2[0], (Vector3d)axes2[1], (Vector3d)axes2[2], (Vector3d)other.extents());
    }

    public static boolean isColliding(OBB obb, AABB aabb) {
        Vector3d obbCenter = obb.center();
        Vector3d[] obbAxes = obb.getAxes();
        Vector3d obbHalfExtents = obb.extents();
        Vector3d aabbCenter = OBB.vec3ToVector3d(aabb.getCenter());
        Vector3d aabbHalfExtents = new Vector3d(aabb.getXsize() / 2.0, aabb.getYsize() / 2.0, aabb.getZsize() / 2.0);
        return Intersectiond.testObOb((double)obbCenter.x, (double)obbCenter.y, (double)obbCenter.z, (double)obbAxes[0].x, (double)obbAxes[0].y, (double)obbAxes[0].z, (double)obbAxes[1].x, (double)obbAxes[1].y, (double)obbAxes[1].z, (double)obbAxes[2].x, (double)obbAxes[2].y, (double)obbAxes[2].z, (double)obbHalfExtents.x, (double)obbHalfExtents.y, (double)obbHalfExtents.z, (double)aabbCenter.x, (double)aabbCenter.y, (double)aabbCenter.z, (double)1.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)aabbHalfExtents.x, (double)aabbHalfExtents.y, (double)aabbHalfExtents.z);
    }

    public static Vector3d getClosestPointOBB(Vector3d point, OBB obb) {
        Vector3d nearP = new Vector3d((Vector3dc)obb.center());
        Vector3d dist = point.sub((Vector3dc)nearP, new Vector3d());
        double[] extents = new double[]{obb.extents().x, obb.extents().y, obb.extents().z};
        Vector3d[] axes = obb.getAxes();
        for (int i = 0; i < 3; ++i) {
            double distance = dist.dot((Vector3dc)axes[i]);
            distance = Math.clamp((double)distance, (double)(-extents[i]), (double)extents[i]);
            nearP.x += distance * axes[i].x;
            nearP.y += distance * axes[i].y;
            nearP.z += distance * axes[i].z;
        }
        return nearP;
    }

    public Optional<Vector3d> clip(Vector3d pFrom, Vector3d pTo) {
        Vector3d[] axes = new Vector3d[]{this.rotation.transform(new Vector3d(1.0, 0.0, 0.0)), this.rotation.transform(new Vector3d(0.0, 1.0, 0.0)), this.rotation.transform(new Vector3d(0.0, 0.0, 1.0))};
        Vector3d localFrom = this.worldToLocal(pFrom, axes);
        Vector3d localTo = this.worldToLocal(pTo, axes);
        Vector3d dir = new Vector3d((Vector3dc)localTo).sub((Vector3dc)localFrom);
        double tEnter = 0.0;
        double tExit = 1.0;
        for (int i = 0; i < 3; ++i) {
            double min = -this.extents.get(i);
            double max = this.extents.get(i);
            double origin = localFrom.get(i);
            double direction = dir.get(i);
            if (Math.abs((double)direction) < (double)1.0E-7f) {
                if (!(origin < min) && !(origin > max)) continue;
                return Optional.empty();
            }
            double t1 = (min - origin) / direction;
            double t2 = (max - origin) / direction;
            double tNear = Math.min((double)t1, (double)t2);
            double tFar = Math.max((double)t1, (double)t2);
            if (tNear > tEnter) {
                tEnter = tNear;
            }
            if (tFar < tExit) {
                tExit = tFar;
            }
            if (!(tEnter > tExit)) continue;
            return Optional.empty();
        }
        Vector3d localHit = new Vector3d((Vector3dc)dir).mul(tEnter).add((Vector3dc)localFrom);
        return Optional.of(this.localToWorld(localHit, axes));
    }

    private Vector3d worldToLocal(Vector3d worldPoint, Vector3d[] axes) {
        Vector3d rel = new Vector3d((Vector3dc)worldPoint).sub((Vector3dc)this.center);
        return new Vector3d(rel.dot((Vector3dc)axes[0]), rel.dot((Vector3dc)axes[1]), rel.dot((Vector3dc)axes[2]));
    }

    private Vector3d localToWorld(Vector3d localPoint, Vector3d[] axes) {
        Vector3d result = new Vector3d((Vector3dc)this.center);
        result.add((Vector3dc)axes[0].mul(localPoint.x, new Vector3d()));
        result.add((Vector3dc)axes[1].mul(localPoint.y, new Vector3d()));
        result.add((Vector3dc)axes[2].mul(localPoint.z, new Vector3d()));
        return result;
    }

    public OBB inflate(double amount) {
        Vector3d newExtents = new Vector3d((Vector3dc)this.extents).add(amount, amount, amount);
        return new OBB(this.center, newExtents, this.rotation, this.part);
    }

    public OBB inflate(double x, double y, double z) {
        Vector3d newExtents = new Vector3d((Vector3dc)this.extents).add(x, y, z);
        return new OBB(this.center, newExtents, this.rotation, this.part);
    }

    public OBB move(Vec3 vec3) {
        Vector3d newCenter = new Vector3d(this.center.x + vec3.x, this.center.y + vec3.y, this.center.z + vec3.z);
        return new OBB(newCenter, this.extents, this.rotation, this.part);
    }

    public boolean contains(Vec3 vec3) {
        Vector3d rel = OBB.vec3ToVector3d(vec3).sub((Vector3dc)this.center);
        Vector3d[] axes = new Vector3d[]{this.rotation.transform(new Vector3d(1.0, 0.0, 0.0)), this.rotation.transform(new Vector3d(0.0, 1.0, 0.0)), this.rotation.transform(new Vector3d(0.0, 0.0, 1.0))};
        double projX = Math.abs((double)rel.dot((Vector3dc)axes[0]));
        double projY = Math.abs((double)rel.dot((Vector3dc)axes[1]));
        double projZ = Math.abs((double)rel.dot((Vector3dc)axes[2]));
        return projX <= this.extents.x && projY <= this.extents.y && projZ <= this.extents.z;
    }

    @Nullable
    public static OBB getLookingObb(Player player, double range) {
        OBBEntity obbEntity;
        Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, range);
        if (!(lookingEntity instanceof OBBEntity) || (obbEntity = (OBBEntity)lookingEntity).enableAABB()) {
            return null;
        }
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 viewVec = player.getViewVector(1.0f);
        Vec3 lookEnd = eyePos.add(viewVec.scale(range));
        OBB closestOBB = null;
        double minDistanceSq = Double.MAX_VALUE;
        for (OBB obb : obbEntity.getOBBs()) {
            double distanceSq;
            Vec3 hitPos = OBB.rayIntersect(obb, eyePos, lookEnd);
            if (hitPos == null || !((distanceSq = eyePos.distanceToSqr(hitPos)) < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            closestOBB = obb;
        }
        return closestOBB;
    }

    @Nullable
    public static Vec3 rayIntersect(OBB obb, Vec3 start, Vec3 end) {
        Vec3 center = OBB.vector3dToVec3(obb.center());
        Vec3 extents = OBB.vector3dToVec3(obb.extents());
        Quaterniond rotation = obb.rotation();
        Quaterniond inverse = new Quaterniond((Quaterniondc)rotation).conjugate();
        Vector3d localStart = OBB.toLocal(obb, start);
        Vector3d localEnd = OBB.toLocal(obb, end);
        double minX = -extents.x;
        double minY = -extents.y;
        double minZ = -extents.z;
        double maxX = extents.x;
        double maxY = extents.y;
        double maxZ = extents.z;
        Vector2d result = new Vector2d();
        boolean intersects = Intersectiond.intersectRayAab((double)localStart.x, (double)localStart.y, (double)localStart.z, (double)(localEnd.x - localStart.x), (double)(localEnd.y - localStart.y), (double)(localEnd.z - localStart.z), (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Vector2d)result);
        if (intersects) {
            double t = result.x;
            Vector3d localHit = new Vector3d(localStart.x + t * (localEnd.x - localStart.x), localStart.y + t * (localEnd.y - localStart.y), localStart.z + t * (localEnd.z - localStart.z));
            rotation.transform(localHit);
            return new Vec3(localHit.x + center.x, localHit.y + center.y, localHit.z + center.z);
        }
        return null;
    }

    private static Vector3d toLocal(OBB obb, Vec3 worldPoint) {
        Vec3 center = OBB.vector3dToVec3(obb.center());
        Quaterniond rotation = obb.rotation();
        Quaterniond inverse = new Quaterniond((Quaterniondc)rotation).conjugate();
        Vector3d relative = new Vector3d(worldPoint.x - center.x, worldPoint.y - center.y, worldPoint.z - center.z);
        inverse.transform(relative);
        return relative;
    }

    public static Vector3d vec3ToVector3d(Vec3 vec3) {
        return new Vector3d(vec3.x, vec3.y, vec3.z);
    }

    public static Vec3 vector3dToVec3(Vector3d vector3d) {
        return new Vec3(vector3d.x, vector3d.y, vector3d.z);
    }

    public static enum Part {
        EMPTY,
        WHEEL_LEFT,
        WHEEL_RIGHT,
        TURRET,
        MAIN_ENGINE,
        SUB_ENGINE,
        BODY,
        INTERACTIVE;

    }
}

